/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_defaults.c,v 1.1 2001/06/27 21:26:29 root Exp root $
 * $Author: root $
 *
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_defaults.c,v $
 * Revision 1.1  2001/06/27 21:26:29  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"


void set_defaults(struct pkt_info *pkt,
                  struct pkt_info_tcp *pkttcp,
                  struct pkt_info_icmp *pkticmp,
#if defined(RAIN_IPV6)
                  struct pkt_info_icmp6 *pkticmp6,
#endif
                  struct pkt_info_igmp *pktigmp)
{

  /* set default pkt info */
  packetsize      =        1024;  /* 1 kilobyte */
  pkt->num        =          -1;  /* infinite */
  pkt->dport      =         138;
  pkt->sport      =         420;
  strcpy(pkt->saddr,"127.0.0.1");
  pkt->delay      =       15000;  /* delay in microseconds */
  if(getuid() == 0) {
    pkt->type     =     DEFAULT;  /* see rain_inet_common.h */
  } else {
    pkt->type     =   TCPSTREAM;  /* see rain_inet_common.h */
  }
  pkt->tos        =           0;  /* see rain_inet_common.h */
  pkt->ttl        =          64;  /* well known default */
  pkt->tot_len    =         0x0;
  pkt->id         =    getpid();
  pkt->id_of      =           0;
  pkt->frag       =           0;
  pkt->frag_off   =           0;
  pkt->simulate   =           0;
  pkt->randip     =           0;

  /* set default pkt_info_tcp */
  pkttcp->seq     = getpid();
  pkttcp->window  =       56;
  pkttcp->urg     =        0;
  pkttcp->ack     =        0;
  pkttcp->ack_seq =        0;
  pkttcp->psh     =        0;
  pkttcp->rst     =        0;
  pkttcp->fin     =        0;
  pkttcp->syn     =        1;
  pkttcp->beenset =        0; /* flag set to 1 when one of the previous flags are set */


  /* set default pkt_info_icmp */
  pkticmp->type = 0; /* echo */
  pkticmp->code = 0; /* echo reply */


#if defined(RAIN_IPV6)
  /* set default pkt_info_icmp6 */
  pkticmp6->type = 129;
  pkticmp6->code =   0; /* echo reply */
#endif

  /* set default pkt_info_igmp */
  pktigmp->type = 0x11; /* membership query */
  pktigmp->code = 0x0; /* max response time: 0 */


  return;
}
