/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_inet_common.h,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_inet_common.h
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_inet_common.h,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:47  root
 * Initial revision
 *
 *-------------------------------------------------*/

#ifndef _RAIN_INET_COMMON_H
#define _RAIN_INET_COMMON_H

#define DEFAULT    0x1
#define TCP        0x2
#define UDP        0x3
#define SYN        0x4
#define ICMP       0x5
#define IGMP       0x6
#define ICMP6      0x7
#define TCPSTREAM  0x8
#define TCPCONNECT 0x9

/* Type of Service - RFC 791 */
#define TOS_NORMAL_DELAY          (0)
#define TOS_LOW_DELAY             (1<<4)
#define TOS_NORMAL_THROUGHPUT     (0)
#define TOS_HIGH_THROUGHPUT       (1<<3)
#define TOS_NORMAL_RELIABILITY    (0)
#define TOS_HIGH_RELIABILITY      (1<<2)

/* Type of Service - Precedence */
#define TOSP_NETWORK_CONTROL      (7<<5)
#define TOSP_INTERNETWORK_CONTROL (6<<5)
#define TOSP_CRITIC_ECP           (5<<5)
#define TOSP_FLASH_OVERRIDE       (4<<5)
#define TOSP_FLASH                (3<<5)
#define TOSP_IMMEDIATE            (2<<5)
#define TOSP_PRIORITY             (1<<5)
#define TOSP_ROUTINE              (0)

/* Default Type of Service to use */
#define TOS_DEFAULT (TOS_NORMAL_DELAY | TOS_HIGH_RELIABILITY | TOSP_PRIORITY)



struct pkt_info {
  int   		num;   /* number of packets to send */
  u_int16_t           dport;   /* destination port */
  u_int16_t           sport;   /* source port */
  u_long              delay;   /* delay between packet sends */
  u_char         saddr[256];   /* source address */
#if defined(RAIN_IPV6)
  u_char         saddr6[16];   /* source address (ipv6) */
#endif
  u_char         daddr[256];   /* destination address */
#if defined(RAIN_IPV6)
  u_char         daddr6[16];   /* destination address (ipv6) */
#endif
  u_int8_t         type : 8;   /* TCP, SYN, UDP, ICMP or IGMP */
  u_int8_t          tos : 8;   /* type of service (IP header) */
  u_int8_t          ttl : 8;
  u_int16_t         tot_len;
  u_short          frag : 1;
  u_int16_t        frag_off;
  u_short      simulate : 1;
  u_int             simtype;
  u_int			 id;
  u_int           id_of : 1;
  u_short        randip : 1;
};

struct pkt_info_tcp {
  u_int16_t    window;
  u_int32_t       seq;
  u_short     urg : 1;
  u_short     ack : 1;
  u_int32_t   ack_seq;
  u_short     psh : 1;
  u_short     rst : 1;
  u_short     syn : 1;
  u_short     fin : 1;
  u_short beenset : 1;
};


struct pkt_info_icmp {
    u_short type : 8;
    u_short code : 8;
};

#if defined(RAIN_IPV6)
struct pkt_info_icmp6 {
    u_short type : 8;
    u_short code : 8;
};
#endif

struct pkt_info_igmp {
  u_short type : 8;
  u_short code : 8;
};

struct iptcp {
  struct iphdr   ip;
  struct tcphdr tcp;
};

struct ipudp {
  struct iphdr   ip;
  struct udphdr udp;
};

struct ipicmp {
  struct iphdr  ip;
  struct icmphdr icmp;
};

#if defined(RAIN_IPV6)
struct ipicmp6 {
  struct ip6_hdr     ip6;
  struct icmp6_hdr icmp6;
};
#endif

struct ipigmp {
  struct iphdr  ip;
  struct igmp igmp;
};



/* global variables */
u_int16_t packetsize;
unsigned char      *buffer;   /* For holding packets. Declared globally to ensure it is freed when the program exits */
time_t          send_start;   /* for storing start and finish time of total packets sent */
time_t         send_finish;
unsigned long packets_sent;
/*---------------------------*/


/* function prototypes */
extern unsigned short in_cksum(u_short *, int);
extern u_int32_t randip(void);

#undef RAIN_IPV6  /* IPv6 support is not ready yet */

#endif /* _RAIN_INET_COMMON_H */
