/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_common.h,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_common.h
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_common.h,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:47  root
 * Initial revision
 *
 *-------------------------------------------------*/

#ifndef _RAIN_COMMON_H
#define _RAIN_COMMON_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#if defined(RAIN_IPV6)
  #include <netinet/ip6.h>
  #include <netinet/icmp6.h>
#endif
#include <arpa/inet.h>
#include <netdb.h>

#include "rain_inet_common.h"
#include "rain_command_line.h"
#include "rain_tcp.h"
#include "rain_udp.h"
#if defined(RAIN_IPV6)
  #include "rain_icmp6.h"
#endif
#include "rain_igmp.h"
#include "rain_die.h"
#include "rain_resolv.h"
#include "rain_signal.h"
#include "rain_string.h"
#include "rain_mem.h"
#include "rain_defaults.h"
#include "rain_services.h"
#include "rain_icmp.h"
#include "rain_errno.h"

#define RAIN_VERSION "1.2.6"

#define TRUE  (1)
#define FALSE (0)

#define UID_CHECK(uid,opt) { \
  switch(uid) { \
    case  0: { break; } \
    default:{ \
      fprintf(stderr,"\n- - Error: uid %d is not permitted to use %s (must be root)\n",uid,opt); \
      exit(1); \
    } \
  } \
}

#endif /* _RAIN_H */
