/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_icmp.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_icmp.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_icmp.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/
#include "rain_common.h"


/* initializes an array that stores information on ICMP types and codes */
extern void
icmp_info_init(struct pkt_info_icmp *pkticmp) {

  switch(pkticmp->type) {
    case 0:  	/* echo reply */
    case 3:  	/* destination unreachable */
    case 4:  	/* source quench */
    case 5:  	/* redirect (change route) */
    case 8:  	/* echo request */
    case 11: 	/* time exceeded */
    case 12: 	/* paramater problem */
    case 13: 	/* timestamp request */
    case 14: 	/* timestamp reply */
    case 15: 	/* information request */
    case 16: 	/* information reply */
    case 17: 	/* address mask request */
    case 18: 	/* address mask reply */
    { break; }
    default: { DieWithError("unknown ICMP type", R_UNKNOWNICMP); }
  }

  memset(icmpinfo, 0xFF, sizeof(icmpinfo));

/* type 0: echo reply */
  if((pkticmp->type == 0) && (pkticmp->code != 0))
    DieWithError("ICMP type 0 must have code 0", 0);
  strcpy(icmpinfo[0][0]," echo reply"); 


/* type: 3 (unreachable) */
  if((pkticmp->type == 3) && (pkticmp->code > 5))
    DieWithError("unknown ICMP code (Unreachable must be 0-5)", 0);
  strcpy(icmpinfo[3][0], " network unreachable");
  strcpy(icmpinfo[3][1], " host unreachable");
  strcpy(icmpinfo[3][2], " protocol unreachable");
  strcpy(icmpinfo[3][3], " port unreachable");
  strcpy(icmpinfo[3][4], " frag needed but DF set");
  strcpy(icmpinfo[3][5], " source route failed");

/* type 4: source quench */
  if((pkticmp->type == 4) && (pkticmp->code != 0))
    DieWithError("ICMP type 4 must have code 0", 0);
  strcpy(icmpinfo[4][0], " source quench message");

/* type 5: redirect */
  if((pkticmp->type == 5) && (pkticmp->code > 3))
    DieWithError("unknown ICMP code (Redirect must be 0-3)", 0);
  strcpy(icmpinfo[5][0]," redirect dgrams for network");
  strcpy(icmpinfo[5][1]," redirect dgrams for host");
  strcpy(icmpinfo[5][2]," redirect dgrams for ToS and network");
  strcpy(icmpinfo[5][3]," redirect dgrams for Tos and host");

/* type 8: echo or echo reply */
  if((pkticmp->type == 8) && (pkticmp->code != 0))
    DieWithError("ICMP type 8 must have code 0", 0);
  strcpy(icmpinfo[8][0]," echo request"); 

/* type 11: time exceeded */
  strcpy(icmpinfo[11][0], " ttl exceeded in transit");
  strcpy(icmpinfo[11][1], " fragment reassembly time exceeded");

/* type 12: parameter problem */
  if((pkticmp->type == 12) && (pkticmp->code != 0))
    DieWithError("ICMP type 12 must have code 0", 0);
  strcpy(icmpinfo[12][0]," parameter problem message");

/* type 13: timestamp message */
  if((pkticmp->type == 13) && (pkticmp->code != 0))
    DieWithError("ICMP type 13 must have code 0", 0);
  strcpy(icmpinfo[13][0]," timestamp");

/* type 14: timestamp reply */
  if((pkticmp->type == 14) && (pkticmp->code != 0))
    DieWithError("ICMP type 14 must have code 0", 0);
  strcpy(icmpinfo[14][0]," timestamp reply");

/* type 15: info request */
  if((pkticmp->type == 15) && (pkticmp->code != 0))
    DieWithError("ICMP type 15 must have code 0", 0);
  strcpy(icmpinfo[15][0]," information request");

/* type 16: info reply */
  if((pkticmp->type == 16) && (pkticmp->code != 0))
    DieWithError("ICMP type 16 must have code 0", 0);
  strcpy(icmpinfo[16][0]," information reply");

/* type 17: address mask request */
   if((pkticmp->type == 17) && (pkticmp->code != 0))
     DieWithError("ICMP type 17 must have code 0", 0);
   strcpy(icmpinfo[17][0], " address mask request");  

/* type 18: address mask reply */
   if((pkticmp->type == 18) && (pkticmp->code != 0))
     DieWithError("ICMP type 18 must have code 0", 0);
   strcpy(icmpinfo[18][0], " address mask reply");  

  return;
}

/* ICMP shower */

extern int
icmp_shower(int raw_socket, struct sockaddr_in *source, struct sockaddr_in *target, struct pkt_info *pkt, struct pkt_info_icmp *pkticmp) {
  struct ipicmp *ip_icmp;  
  struct iphdr *ip;
  struct icmphdr *icmp;
  int i = 0;

  packetsize -= sizeof(struct icmphdr);

/* We use a global buffer to ward off memory leaks *
 * it will be freed when the program exits         */
  buffer = malloc(sizeof(char)*packetsize);
  if(!buffer) DieWithError("malloc()", ENOMEM);

  ip_icmp = (struct ipicmp*)buffer;
  ip = &ip_icmp->ip;
  icmp = &ip_icmp->icmp;

  memset(buffer, pkt->filler, (sizeof(char)*packetsize));

  /* store the user-specified string in the payload, if there is one.. */
  if(ctoi(pkt->payload[0]) != 0) {
   for(; i < strlen(pkt->payload); i++)
     buffer[(sizeof(struct iphdr) + sizeof(struct icmphdr)) + i] = pkt->payload[i];
  }


  pkt->tot_len = (sizeof(struct icmphdr) + strlen(buffer));

  icmp->type    = pkticmp->type;
  icmp->code    = pkticmp->code;
  if((icmp->type == 13) || (icmp->code == 14)) {
    icmp->un.echo.id = pkticmp->id;
    icmp->un.echo.sequence = pkticmp->seq;
  }
  icmp->un.frag.mtu = htons(pkticmp->mtu);
  icmp->un.gateway = group.s_addr;
  icmp->checksum = in_cksum((u_short*)icmp, sizeof(struct icmphdr), 0);

  pkt->tot_len += (sizeof(struct iphdr));
  
  ip->version  = 4;
  ip->ihl      = (sizeof(struct iphdr) >> 2);
  ip->tos      = pkt->tos;
  ip->tot_len  = htons(pkt->tot_len);
  ip->id       = htons(pkt->id);
  if(pkt->frag == 1) {
    ip->frag_off  = htons(pkt->frag_off); /* set fragment offset */
    ip->frag_off |= htons(0x2000);  /* set fragment bit */
  } else {
    ip->frag_off = 0x0;  /* don't fragment */
  }
  ip->ttl      = pkt->ttl;
  ip->protocol = IPPROTO_ICMP;
  ip->saddr    = source->sin_addr.s_addr;
  ip->daddr    = target->sin_addr.s_addr;
  ip->check    = in_cksum((u_short*)ip,sizeof(struct iphdr), 0);

 
  while(packets_sent < pkt->num) {
    if(sendto(raw_socket,
              ip_icmp,
              pkt->tot_len,
              0,
              (struct sockaddr*)target,
              sizeof(struct sockaddr_in)) < 0) return -1;
    packets_sent++;

    /* for id overloading: */
    if(pkt->id_of == 1) { ip->id++; ip->id = htons(ip->id) ; ip->check = in_cksum((u_short*)ip, sizeof(ip), 0); }
    usleep(pkt->delay);
  }

  return 0;
}

/* EOF */
