/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_inet_common.h,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_inet_common.h
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_inet_common.h,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:47  root
 * Initial revision
 *
 *-------------------------------------------------*/

#ifndef _RAIN_INET_COMMON_H
#define _RAIN_INET_COMMON_H


#ifndef in_addr_t
  #define in_addr_t u_int32_t
#endif


#define MAXPORT 65535
 
/* packet types for storing in pkt->type */
#define DEFAULT     0x1
#define TCP         0x2
#define UDP         0x3
#define SYN         0x4
#define ICMP        0x5
#define IGMP        0x6
#define ICMP6       0x7
#define TCPSTREAM   0x8
#define TCPCONNECT  0x9
#define USERDEFAULT TCPSTREAM


/* Type of Service - RFC 791 */
#define TOS_NORMAL_DELAY          (0)
#define TOS_LOW_DELAY             (1<<4)
#define TOS_NORMAL_THROUGHPUT     (0)
#define TOS_HIGH_THROUGHPUT       (1<<3)
#define TOS_NORMAL_RELIABILITY    (0)
#define TOS_HIGH_RELIABILITY      (1<<2)

/* Type of Service - Precedence */
#define TOSP_NETWORK_CONTROL      (7<<5)
#define TOSP_INTERNETWORK_CONTROL (6<<5)
#define TOSP_CRITIC_ECP           (5<<5)
#define TOSP_FLASH_OVERRIDE       (4<<5)
#define TOSP_FLASH                (3<<5)
#define TOSP_IMMEDIATE            (2<<5)
#define TOSP_PRIORITY             (1<<5)
#define TOSP_ROUTINE              (0)

/* Default Type of Service to use */
#define TOS_DEFAULT (TOS_NORMAL_DELAY | TOS_HIGH_RELIABILITY | TOSP_PRIORITY)

/*-----------------------------------------------------------*/
/* Internet header structures from the glibc library headers */
/*-----------------------------------------------------------*/
struct iphdr
  {
#if __BYTE_ORDER == __LITTLE_ENDIAN
    unsigned int ihl:4;
    unsigned int version:4;
#elif __BYTE_ORDER == __BIG_ENDIAN
    unsigned int version:4;
    unsigned int ihl:4;
#else
# error "Please fix <bits/endian.h>"
#endif
    u_int8_t tos;
    u_int16_t tot_len;
    u_int16_t id;
    u_int16_t frag_off;
    u_int8_t ttl;
    u_int8_t protocol;
    u_int16_t check;
    u_int32_t saddr;
    u_int32_t daddr;
    /*The options start here. */
  };

struct tcphdr
  {
    u_int16_t source;
    u_int16_t dest;
    u_int32_t seq;
    u_int32_t ack_seq;
#  if __BYTE_ORDER == __LITTLE_ENDIAN
    u_int16_t res1:4;
    u_int16_t doff:4;
    u_int16_t fin:1;
    u_int16_t syn:1;
    u_int16_t rst:1;
    u_int16_t psh:1;
    u_int16_t ack:1;
    u_int16_t urg:1;
    u_int16_t res2:2;
#  elif __BYTE_ORDER == __BIG_ENDIAN
    u_int16_t doff:4;
    u_int16_t res1:4;
    u_int16_t res2:2;
    u_int16_t urg:1;
    u_int16_t ack:1;
    u_int16_t psh:1;
    u_int16_t rst:1;
    u_int16_t syn:1;
    u_int16_t fin:1;
#  else
#   error "Adjust your <bits/endian.h> defines"
#  endif
    u_int16_t window;
    u_int16_t check;
    u_int16_t urg_ptr;
};

struct udphdr {
  u_int16_t     source;
  u_int16_t     dest;
  u_int16_t     len;
  u_int16_t     check;
};


struct icmphdr
{
  u_int8_t type;                /* message type */
  u_int8_t code;                /* type sub-code */
  u_int16_t checksum;
  union
  {
    struct
    {
      u_int16_t id;
      u_int16_t sequence;
    } echo;                     /* echo datagram */
    u_int32_t   gateway;        /* gateway address */
    struct
    {
      u_int16_t __unused;
      u_int16_t mtu;
    } frag;                     /* path mtu discovery */
  } un;
};

struct igmp {
  u_int8_t igmp_type;             /* IGMP type */
  u_int8_t igmp_code;             /* routing code */
  u_int16_t igmp_cksum;           /* checksum */
  struct in_addr igmp_group;      /* group address */
};

/*-----------------------------------------------------------*/
/*-----------------------------------------------------------*/



struct pkt_info {
  int   		num;   /* number of packets to send */
  u_int16_t           dport;   /* destination port */
  u_int16_t           sport;   /* source port */
  int               timeout;
  u_long              delay;   /* delay between packet sends */
  u_char         saddr[256];   /* source address */
#if defined(RAIN_IPV6)
  u_char        saddr6[256];   /* source address (ipv6) */
#endif
  u_char         daddr[256];   /* destination address */
#if defined(RAIN_IPV6)
  u_char        daddr6[256];   /* destination address (ipv6) */
#endif
  u_char         gaddr[256];   /* gateway address used in ICMP */
  u_int8_t         type : 8;   /* TCP, SYN, UDP, ICMP or IGMP rev.1: TCPSTREAM, TCPCONNECT */
  u_int8_t          tos : 8;   /* type of service (IP header) */
  u_int8_t          ttl : 8;
  u_int16_t         tot_len;
  u_short          frag : 1;
  u_int16_t        frag_off;
  u_short      simulate : 1;
  u_int             simtype;
  u_int			 id;
  u_int           id_of : 1;
  u_short        randip : 1;
  u_char      payload[1024];
  u_short     rsport    : 1;  /* random source port specifier */
  u_short     rdport    : 1;  /* random dest port specifier */
  char               filler;
};


struct pkt_info_tcp {
  u_int16_t    window;
  u_int32_t       seq;
  u_short     urg : 1;
  u_short     ack : 1;
  u_int32_t   ack_seq;
  u_short     psh : 1;
  u_short     rst : 1;
  u_short     syn : 1;
  u_short     fin : 1;
  u_short beenset : 1;
};


struct pkt_info_icmp {
    u_short type : 8;
    u_short code : 8;
    u_int16_t     id;  /* id */
    u_int16_t    seq;  /* sequence */
    u_int16_t    mtu;  /* maximum transfer unit */
    u_int32_t     gw;  /* gateway address */
};

#if defined(RAIN_IPV6)
struct pkt_info_icmp6 {
    u_short type : 8;
    u_short code : 8;
};
#endif

struct pkt_info_igmp {
  u_short type : 8;
  u_short code : 8;
};

struct iptcp {
  struct iphdr   ip;
  struct tcphdr tcp;
};

struct ipudp {
  struct iphdr   ip;
  struct udphdr udp;
};

struct ipicmp {
  struct iphdr  ip;
  struct icmphdr icmp;
};

#if defined(RAIN_IPV6)
struct ipicmp6 {
  struct ip6_hdr     ip6;
  struct icmp6_hdr icmp6;
};
#endif

struct ipigmp {
  struct iphdr  ip;
  struct igmp igmp;
};



/* global variables */
u_int16_t packetsize;
unsigned char      *buffer;   /* For holding packets. Declared globally to ensure it is freed when the program exits */
time_t          send_start;   /* for storing start and finish time of total packets sent */
time_t         send_finish;
unsigned long packets_sent;
u_short            verbose;
struct in_addr       group;  /* for ICMP gateway and IGMP group addresses */

/*---------------------------*/


/* function prototypes */
unsigned short in_cksum(const u_short *, register int, u_short);
extern u_int32_t randip(void);

#undef RAIN_IPV6  /* IPv6 support is not ready yet */

#endif /* _RAIN_INET_COMMON_H */
