/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_inet_common.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_inet_common.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_inet_common.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 03:36:15  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

u_short
in_cksum(const u_short *addr, register int len, u_short csum)
{
        int nleft = len;
        const u_short *w = addr;
        u_short answer;
        int sum = csum;

        /*
         *  Our algorithm is simple, using a 32 bit accumulator (sum),
         *  we add sequential 16 bit words to it, and at the end, fold
         *  back all the carry bits from the top 16 bits into the lower
         *  16 bits.
         */
        while (nleft > 1)  {
                sum += *w++;
                nleft -= 2;
        }
        if (nleft == 1)
                sum += htons(*(u_char *)w<<8);

        /*
         * add back carry outs from top 16 bits to low 16 bits
         */
        sum = (sum >> 16) + (sum & 0xffff);     /* add hi 16 to low 16 */
        sum += (sum >> 16);                     /* add carry */
        answer = ~sum;                          /* truncate to 16 bits */
        return (answer);
}


extern u_int32_t
randip(void)
{
  struct sockaddr_in sin;
  char *buf = malloc(sizeof(char)*16);
  char seg1[4], seg2[4], seg3[4], seg4[4];

  srand(time(NULL));

  sprintf(seg1,"%d", (1+(int) (191.0*rand()/(RAND_MAX+1.0))+23));
  sprintf(seg2,"%d", (1+(int) (253.0*rand()/(RAND_MAX+1.0))+23));
  sprintf(seg3,"%d", (1+(int) (253.0*rand()/(RAND_MAX+1.0))+23));
  sprintf(seg4,"%d", (1+(int) (253.0*rand()/(RAND_MAX+1.0))+23));

  sprintf(buf, "%s.%s.%s.%s",seg1, seg2, seg3, seg4);

  inet_aton(buf, (struct in_addr *)&sin);

  freebuf(buf);

  return sin.sin_addr.s_addr;
}

/* EOF */
