#ifndef _SENDIP_PROTOCOLS_H
#define _SENDIP_PROTOCOLS_H

#ifndef __GNU_LIBRARY__
#define __GNU_LIBRARY__ 42
#endif
#if __GNU_LIBRARY__ < 6
#define icmp     icmphdr
#endif

#include "rip.h"

extern void ip_initialize(struct ip *iph);
extern void ip6_initialize(struct ip6_hdr *hdr);
extern void icmp_initialize(struct icmp *icp);
extern void icmp6_initialize(struct icmp6_hdr *icmp6);
extern void tcp_initialize(struct tcphdr *tcp);
extern void udp_initialize(struct udphdr *udp);

extern void do_ipopt(struct ip *ip, char *opt, char *arg);
extern void do_ip6opt(struct ip6_hdr *hdr, char *opt, char *arg);
extern void do_icmpopt(struct icmp *icp, char *opt, char *arg);
extern void do_icmp6opt(struct icmp6_hdr *icmp6, char *opt, char *arg);
extern void do_tcpopt(struct tcphdr *tcp, unsigned char *tcpopts, char *opt, char *arg);
extern void do_udpopt(struct udphdr *udp, char *opt, char *arg);
extern void do_ripopt(struct rip_options *rippack, char *opt, char **arg);

extern void ip_set_addr(struct ip *iph, struct sockaddr_in *to);
extern void ip6_set_addr(struct ip6_hdr *hdr, struct sockaddr_in6 *to);
extern void ip_finalize(struct ip *iph, int length, struct sockaddr_in *to);
extern void ip6_finalize(struct ip6_hdr *hdr, int length, struct sockaddr_in6 *to);
extern void icmp_finalize(struct ip *iph, struct icmp *icp, int length);
extern void icmp6_finalize(struct ip6_hdr *hdr, struct icmp6_hdr *icmp6, int length);
extern void tcp_finalize(struct ip *iph, struct tcphdr *tcp, int length);
extern void udp_finalize(struct ip *iph, struct udphdr *udp, int length);
extern void rip_finalize(struct rip_options *rippack, unsigned char *dataStart);

#endif /* _SENDIP_PROTOCOLS_H */
