#!/usr/bin/perl
#
# menuconfig is part of the SScript package
#
# This is used to make the file config.h
# This thing assumes a 80 columns display
$HANDLE_EMPTY_STRINGS = "ON ";
$GET_REMOTE_IP = "ON ";
$FORK_START = "ON ";
$HEADER = "ON ";
$GUI = "OFF";
$GTK = "OFF";
$EDITOR = "pico";
$LOGFILE = "sscript.log";
$CL_GUI_TK_PATH = "/usr/bin/wish";
$PERL_BIN = "/usr/bin/perl";
$TEMP_DIR = ".";
$COLORSET = 2;
sub colorset
{
  print "\n";  
  system clear;
  print "\n\n";
  print "  -----------------------------------------------------\n";
  print "  |              Socket Script MenuConfig             |\n";
  print "  -----------------------------------------------------\n";
  print "  | This is the color set to use when SScript runs as |\n";
  print "  | a graphical application only                      |\n";
  print "  -----------------------------------------------------\n";
  if($COLORSET==1) { print "  | 1 - Standard                                 [X]  |\n"; }
  else { print "  | 1 - Standard                                 [ ]  |\n"; }
  if($COLORSET==2) { print "  | 2 - 3D look                                  [X]  |\n"; }
  else { print "  | 2 - 3D look                                  [ ]  |\n"; }
  if($COLORSET==3) { print "  | 3 - Colorful                                 [X]  |\n"; }
  else { print "  | 3 - Colorful                                 [ ]  |\n"; }
  print "  -----------------------------------------------------\n";
  print "Menuconfig> ";
  $choice = <STDIN>;
  if($choice eq "1\n") { $COLORSET = 1; }
  if($choice eq "2\n") { $COLORSET = 2; }
  if($choice eq "3\n") { $COLORSET = 3; }
}

sub settkpath
{
  print "\n";
  system clear;
  print "\n\n";
  print "  -----------------------------------------------------\n";
  print "  |              Socket Script MenuConfig             |\n";
  print "  -----------------------------------------------------\n";
  print "  | Enter the path to the TK interpreter              |\n";
  print "  | (usualy called wish)                              |\n";
  print "  -----------------------------------------------------\n";
  print "Current path is: $CL_GUI_TK_PATH\n";
  print "Menuconfig> ";
  $CL_GUI_TK_PATH = <STDIN>;
  chop $CL_GUI_TK_PATH;
  if($CL_GUI_TK_PATH eq "") { $CL_GUI_TK_PATH = "/usr/bin/wish"; }
}

sub settempdir
{
  print "\n";
  system clear;
  print "\n\n";
  print "  -----------------------------------------------------\n";
  print "  |              Socket Script MenuConfig             |\n";
  print "  -----------------------------------------------------\n";
  print "  | Enter a temporary directory where SScript will    |\n";
  print "  | store it's temp files. It should be a place where |\n";
  print "  | you have owner access, and is not readable from   |\n";
  print "  | others. Use /tmp only as last.                    |\n";
  print "  -----------------------------------------------------\n";
  print "Current dir is: $TEMP_DIR\n";
  print "Menuconfig> ";
  $TEMP_DIR = <STDIN>;
  chop $TEMP_DIR;
  if($TEMP_DIR eq "") { $TEMP_DIR = "."; }
}

sub setperlpath
{
  print "\n";
  system clear;
  print "\n\n";
  print "  -----------------------------------------------------\n";
  print "  |              Socket Script MenuConfig             |\n";
  print "  -----------------------------------------------------\n";
  print "  | Enter the path for the PERL binary                |\n";
  print "  -----------------------------------------------------\n";
  print "Current path is: $PERL_BIN\n";
  print "Menuconfig> ";
  $PERL_BIN = <STDIN>;
  chop $PERL_BIN;
  if($PERL_BIN eq "") { $PERL_BIN = "/usr/bin/perl"; }
}

sub seteditor
{
  print "\n";  
  system clear;
  print "\n\n";
  print "  -----------------------------------------------------\n";
  print "  |              Socket Script MenuConfig             |\n";
  print "  -----------------------------------------------------\n";
  print "  | Which editor do you want to use for composer in   |\n";
  print "  | text mode?                                        |\n";
  print "  -----------------------------------------------------\n";
  print "Current editor is: $EDITOR\n";
  print "Menuconfig> ";
  $EDITOR = <STDIN>;
  chop $EDITOR;
  if($EDITOR eq "") { $EDITOR = "pico"; }
}

sub setlogfile
{
  print "\n";
  system clear;
  print "\n\n";
  print "  -----------------------------------------------------\n";
  print "  |              Socket Script MenuConfig             |\n";
  print "  -----------------------------------------------------\n";
  print "  | What do you want the LOG file to be?              |\n"; 
  print "  -----------------------------------------------------\n";
  print "Current log file is: $LOGFILE\n";
  print "Menuconfig> ";
  $LOGFILE = <STDIN>;
  chop $LOGFILE;
  if($LOGFILE eq "") { $LOGFILE = "sscript.log"; }
}

sub main_menu
{
 while(1)
 {
  print "\n";
  system clear;
  print "\n\n";
  print "  -----------------------------------------------------\n";
  print "  |              Socket Script MenuConfig             |\n";
  print "  -----------------------------------------------------\n";
  print "  | 1 - Handle empty strings                     $HANDLE_EMPTY_STRINGS  |\n";
  print "  | 2 - Get remote IP for server scripts         $GET_REMOTE_IP  |\n";
  print "  | 3 - Go to background for server scripts      $FORK_START  |\n";
  print "  | 4 - Show header on startup                   $HEADER  |\n";
  print "  | 5 - Run in graphical mode                    $GUI  |\n";
  print "  | 6 - Run in GTK mode                          $GTK  |\n";
  print "  | 7 - Set LOG file                              ->  |\n";
  print "  | 8 - Set TK path                               ->  |\n";
  print "  | 9 - Set PERL path                             ->  |\n";
  print "  | A - Set temporary directory                   ->  |\n";
  print "  | B - Set editor                                ->  |\n";
  print "  | C - Choose color set                          ->  |\n";
  print "  -----------------------------------------------------\n";
  print "  | S - Save and quit                                 |\n";
  print "  | Q - Quit                                          |\n";
  print "  -----------------------------------------------------\n";
  print "Menuconfig> ";
  $choice = <STDIN>;
  if($choice eq "1\n")
  {
   if($HANDLE_EMPTY_STRINGS eq "ON ") { $HANDLE_EMPTY_STRINGS = "OFF"; }
   elsif($HANDLE_EMPTY_STRINGS eq "OFF") { $HANDLE_EMPTY_STRINGS = "ON "; }
  }
  if($choice eq "2\n")
  {
   if($GET_REMOTE_IP eq "ON ") { $GET_REMOTE_IP = "OFF"; }
   elsif($GET_REMOTE_IP eq "OFF") { $GET_REMOTE_IP = "ON "; }
  }
  if($choice eq "3\n")
  {
   if($FORK_START eq "ON ") { $FORK_START = "OFF"; }
   elsif($FORK_START eq "OFF") { $FORK_START = "ON "; }
  }
  if($choice eq "4\n")
  {
   if($HEADER eq "ON ") { $HEADER = "OFF"; }
   elsif($HEADER eq "OFF") { $HEADER = "ON "; }
  }
  if($choice eq "5\n")
  {
   if($GUI eq "ON ") { $GUI = "OFF"; }
   elsif($GUI eq "OFF") { $GUI = "ON "; }
  }
  if($choice eq "6\n")
  {
   if($GTK eq "ON ") { $GTK = "OFF"; }
   elsif($GTK eq "OFF") { $GTK = "ON "; }
  }
  if($choice eq "q\n")
  {
   exit;
  }
  if($choice eq "7\n")
  {
   &setlogfile;
  }
  if($choice eq "8\n")
  {
   &settkpath;
  }
  if($choice eq "9\n")
  {
   &setperlpath;
  }
  if($choice eq "a\n")
  {
   &settempdir;
  }
  if($choice eq "b\n")
  {
   &seteditor;
  }
  if($choice eq "c\n")
  {
   &colorset;
  }
  if($choice eq "s\n")
  {
   open(CONFIG_H, ">../src/config.h");
   print CONFIG_H "/* Made with config */\n";
   print CONFIG_H "/* Change empty strings with <NO-STRING> */\n";
   if($HANDLE_EMPTY_STRINGS eq "ON ")
   { print CONFIG_H "#define HANDLE_EMPTY_STRINGS\n"; }
   else { print CONFIG_H "#undef HANDLE_EMPTY_STRINGS\n"; }
   print CONFIG_H "/* Get remote IP when running a server-oriented script */\n";
   if($GET_REMOTE_IP eq "ON ")
   { print CONFIG_H "#define GET_REMOTE_IP\n"; }
   else { print CONFIG_H "#undef GET_REMOTE_IP\n"; }
   print CONFIG_H "/* Fork on starting of server-oriented scripts */\n";
   if($FORK_START eq "ON ")
   { print CONFIG_H "#define FORK_START\n"; }
   else { print CONFIG_H "#undef FORK_START\n"; }
   print CONFIG_H "#define LOGFILE \"$LOGFILE\"\n";
   print CONFIG_H "#define CL_GUI_TK_PATH \"$CL_GUI_TK_PATH\"\n";
   print CONFIG_H "#define PERL_BIN \"$PERL_BIN\"\n";
   print CONFIG_H "/* This is the dir where SScript puts temp files. It should be onwed by you with read permission by you only */\n";
   print CONFIG_H "#define TEMP_DIR \"$TEMP_DIR\"\n";
   print CONFIG_H "/* Show the header when starting SScript */\n";
   if($HEADER eq "ON ")
   { print CONFIG_H "#define HEADER\n"; }
   else { print CONFIG_H "#undef HEADER\n"; }
   print CONFIG_H "#define EDITOR \"$EDITOR\"\n";
   print CONFIG_H "/* Run in graphical mode */\n";
   if($GUI eq "ON ")
   { print CONFIG_H "#define GUI\n"; }
   else { print CONFIG_H "#undef GUI\n"; }
   print CONFIG_H "/* define ONE of the following to set a custom GUI color set */\n";
   if($COLORSET==1) { print CONFIG_H "#define RES_STANDARD\n"; }
   else { print CONFIG_H "#undef RES_STANDARD\n"; }
   if($COLORSET==2) { print CONFIG_H "#define RES_3D\n"; }
   else { print CONFIG_H "#undef RES_3D\n"; }
   if($COLORSET==3) { print CONFIG_H "#define RES_COLORFUL\n"; }
   else { print CONFIG_H "#undef RES_COLORFUL\n"; }
   print "Done.\n";
   close(CONFIG_H);
   exit;
  }
 }
 exit;
}

&main_menu;
