/*
(C) 1998-99 Patrick Lambert <drow@fastethernet.net>

This program is under the GPL

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR   
PURPOSE.

Latest version of Socket Script is always available from
http://devplanet.fastethernet.net/sscript.html
*/

#include <stdio.h>
int ncurses, socks, lz, se, modem, snmp, sd, db;
char tmp_dir[255], log_file[255];

main(int argc, char *argv[])
{
 int os,type;
 char temp[255];
 sd=0;
 if(argv[1]!=NULL)
 {
  if(!strcasecmp(argv[1],"linux-gui")) make_config(0,1,1,1,1,1,1,1,0,1,0);
  else if(!strcasecmp(argv[1],"freebsd-gui")) make_config(1,1,1,1,1,1,1,1,0,1,0);
  else if(!strcasecmp(argv[1],"solaris-gui")) make_config(2,1,1,1,1,1,1,1,0,1,0);
  else if(!strcasecmp(argv[1],"bsdos-gui")) make_config(3,1,1,1,1,1,1,1,0,1,0);
  else if(!strcasecmp(argv[1],"noflags-gui")) make_config(4,1,1,1,1,1,1,1,0,1,0);
  else if(!strcasecmp(argv[1],"linux-console")) make_config(0,0,1,1,1,1,1,1,0,1,0);
  else if(!strcasecmp(argv[1],"freebsd-console")) make_config(1,0,1,1,1,1,1,1,0,1,0);
  else if(!strcasecmp(argv[1],"solaris-console")) make_config(2,0,1,1,1,1,1,1,0,1,0);
  else if(!strcasecmp(argv[1],"bsdos-console")) make_config(3,0,1,1,1,1,1,1,0,1,0);
  else if(!strcasecmp(argv[1],"noflags-console")) make_config(4,0,1,1,1,1,1,1,0,1,0);
  else printf("WARNING: unknown option: %s\n",argv[1]);
 }
 printf("\n\nWelcome to the Socket Script configuration!\n\n");
 printf("Which platform are you on (choices: linux, freebsd, bsdos, solaris, noflags   If your platform isn't listed, use noflags) ?\n");
 scanf("%s",temp);
 if(temp==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 if(!strcasecmp(temp,"linux")) os = 0;
 else if(!strcasecmp(temp,"freebsd")) os = 1;
 else if(!strcasecmp(temp,"solaris")) os = 2;
 else if(!strcasecmp(temp,"bsdos")) os = 3;
 else if(!strcasecmp(temp,"noflags")) os = 4;
 else { printf("STOP: Unknown choice\n"); exit(1); }
 printf("\n\nYou can compile Socket Script in graphical mode or in text-only console mode. You need the GTK library (available at www.gtk.org) for GUI graphical mode. Do you want to compile in graphical mode [yes/no] ? ");
 scanf("%s",temp);
 if(temp==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 if(!strcasecmp(temp,"yes")) type=2;
 else if(!strcasecmp(temp,"y")) type=2;
 else if(!strcasecmp(temp,"no")) type=0;
 else if(!strcasecmp(temp,"n")) type=0;
 else { printf("STOP: Unknown choice\n"); exit(1); }
 printf("\nEnter a temporary directory where SScript will store its temp files. Good choices would be '.' or '/tmp' without the quotes: ");
 scanf("%s",tmp_dir);
 if(tmp_dir==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 printf("\nEnter a filename where SScript will log to. Good choices would be 'sscript.log' or 'syslog' without the quotes, of course. Entering 'syslog' here will use the syslogd utility to log everything: ");
 scanf("%s",log_file);
 if(log_file==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 printf("\n\nThe following are modules which add commands to Socket Script, but also require libraries available from sunsite.unc.edu.\n");
 printf("\nDo you want to use the ncurses library? This will allow you to use the 'draw' command, but you must be sure to have libncurses on the system. If unsure, answer no. [yes/no]? ");
 scanf("%s",temp);
 if(temp==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 if(!strcasecmp(temp,"yes")) ncurses=1;
 else if(!strcasecmp(temp,"y")) ncurses=1;
 else if(!strcasecmp(temp,"no")) ncurses=0;
 else if(!strcasecmp(temp,"n")) ncurses=0;
 else { printf("STOP: Unknown choice\n"); exit(1); }
 printf("\nDo you use a SOCKS5 proxy server to access the Internet? If unsure, answer no. [yes/no]? ");
 scanf("%s",temp);
 if(temp==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 if(!strcasecmp(temp,"yes")) socks=1;
 else if(!strcasecmp(temp,"y")) socks=1;
 else if(!strcasecmp(temp,"no")) socks=0;
 else if(!strcasecmp(temp,"n")) socks=0;
 else { printf("STOP: Unknown choice\n"); exit(1); }
 printf("\nDo you want to use the LIBZ library? It will enable you to use the 'zipstring' and 'unzipstring' commands. If unsure, answer no. [yes/no]? ");
 scanf("%s",temp);
 if(temp==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 if(!strcasecmp(temp,"yes")) lz=1;
 else if(!strcasecmp(temp,"y")) lz=1;
 else if(!strcasecmp(temp,"no")) lz=0;
 else if(!strcasecmp(temp,"n")) lz=0;
 else { printf("STOP: Unknown choice\n"); exit(1); }
 printf("\nDo you want to use the modem library? This will allow you to use the modem command to dial, read and write to modems (experimental). If unsure, answer no. [yes/no] ? ");
 scanf("%s",temp);
 if(temp==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 if(!strcasecmp(temp,"yes")) modem=1;
 else if(!strcasecmp(temp,"y")) modem=1;
 else if(!strcasecmp(temp,"no")) modem=0;
 else if(!strcasecmp(temp,"n")) modem=0;
 else { printf("STOP: Unknown choice\n"); exit(1); }
 printf("\nDo you want to use the CMU SNMP library? It enables you to use the snmp command to query remote routers and systems. If unsure, answer no. [yes/no] ? ");
 scanf("%s",temp);
 if(temp==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 if(!strcasecmp(temp,"yes")) snmp=1;   
 else if(!strcasecmp(temp,"y")) snmp=1;
 else if(!strcasecmp(temp,"no")) snmp=0;
 else if(!strcasecmp(temp,"n")) snmp=0;
 else { printf("STOP: Unknown choice\n"); exit(1); }
 printf("\nDo you want to include GDBM database support? This will allow you to use the db command, but you need the gdbm library installed. If unsure, answer no. [yes/no] ? ");
 scanf("%s",temp);
 if(temp==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 if(!strcasecmp(temp,"yes")) db=1;
 else if(!strcasecmp(temp,"y")) db=1;
 else if(!strcasecmp(temp,"no")) db=0;
 else if(!strcasecmp(temp,"n")) db=0;
 else { printf("STOP: Unknown choice\n"); exit(1); }
 printf("\nDo you want sound capability? You must have access to /dev/dsp to be able to use the say command. If unsure, answer no. [yes/no] ? ");
 scanf("%s",temp);
 if(temp==NULL)
 {
  printf("STOP: Unknown choice\n");
  exit(1);
 }
 if(!strcasecmp(temp,"yes")) sd=1;
 else if(!strcasecmp(temp,"y")) sd=1;
 else if(!strcasecmp(temp,"no")) sd=0;
 else if(!strcasecmp(temp,"n")) sd=0;
 else { printf("STOP: Unknown choice\n"); exit(1); }
 printf("\nSetting defaults...\nUsing gcc...\nEditor: pico\nPerl: /usr/bin/perl\nTK: /usr/bin/wish\n\n");
 make_config(os,type,1,1,1,1,1,1,0,1,0);
 exit(0);
}

int make_config(int os, int type, int o1, int o2, int o3, int o4, int o5, int o6, int o7, int o8, int o9)
{
 FILE *fd, *fda;
 fd=fopen("Makefile","w");
 printf("Creating Makefile\n");
 fputs("# Made with config\n",fd);
 fputs("CC = gcc\n",fd);
 fputs("CFLAGS = ",fd);
 if(os!=4) fputs("-O ",fd);
 if(socks==1) fputs("-DUSE_SOCKS ",fd);
 if(ncurses==1) fputs("-DUSE_NCURSES ",fd);
 if(lz==1) fputs("-DUSE_LIBZ ",fd);
 if(sd==1) fputs("-DSOUND ",fd);
 if(modem==1) fputs("-DUSE_MOD ",fd);
 if(snmp==1) fputs("-DUSE_SNMP ",fd);
 if(db==1) fputs("-DDB ",fd);
 if(os==0) fputs("-DRAWLINUX -DPOSIX ",fd);
 if(os==2) fputs("-DSOLARIS ",fd);
 if(type==1) fputs("-I/usr/X11R6/include ",fd);
 if(type==2) fputs("-I/usr/X11R6/include `gtk-config --cflags`",fd);
 fputs("\nLIBS = ",fd);
 if(os==1) fputs("-lcrypt ",fd);
 if(os==2) fputs("-lsocket -lnsl ",fd);
 if(socks==1) fputs("-lsocks5 ",fd);
 if(ncurses==1) fputs("-lncurses ",fd);
 if(lz==1) fputs("-lz ",fd);
 if(modem==1) fputs("-lmodem ",fd);
 if(db==1) fputs("-lgdbm ",fd);
 if(snmp==1) fputs("/lib/libsnmp.so.2 ",fd);
 if(type==0) fputs("-lm ",fd);
 if(type==1) fputs("-L/usr/X11R6/lib -lXaw -lXmu -lXt -lSM -lICE -lXext -lX11 -lm ",fd);
 if(type==2) fputs("-L/usr/X11R6/lib `gtk-config --libs` -lm ",fd);
 fputs("\n",fd);
 if(sd==1) fputs("OBJS = src/gui-gtk.o src/sscript.o src/gui-tk.o src/utils.o src/ssdb.o src/rawlinux.o src/ssdb2.o src/curses.o src/z.o src/www.o src/snmp.o src/say/say.a",fd);
 else fputs("OBJS = src/gui-gtk.o src/sscript.o src/gui-tk.o src/utils.o src/ssdb.o src/rawlinux.o src/ssdb2.o src/curses.o src/z.o src/www.o src/snmp.o",fd);
 fputs("\n\nall:\n",fd);
 fputs("\t@echo \"Compiling... This may take a few minutes...\"\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/gui-gtk.o -c src/gui-gtk.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/z.o -c src/z.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/snmp.o -c src/snmp.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/www.o -c src/www.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/curses.o -c src/curses.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/sscript.o -c src/sscript.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/gui-tk.o -c src/gui-tk.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/ssdb.o -c src/ssdb.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/ssdb2.o -c src/ssdb2.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/utils.o -c src/utils.c\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o src/rawlinux.o -c src/rawlinux.c\n",fd);
 if(sd==1) fputs("\t(cd src/say; make; cd ../..)\n",fd);
 fputs("\t$(CC) $(CFLAGS) -o sscript $(OBJS) $(LIBS)\n",fd);
 fputs("\trm -f src/*.o\n",fd);
 fputs("install:\n",fd);
 fputs("\tcp sscript /usr/bin/sscript\n",fd);
 fputs("\tchmod +x /usr/bin/sscript\n",fd);
 fputs("\tmkdir /usr/doc/sscript\n",fd);
 fputs("\tcp docs/sscript.1 /usr/man/man1/sscript.1\n",fd);
 fputs("\tcp docs/sscript.doc /usr/doc/sscript/sscript.doc\n\n",fd);
 fputs("\tcp -R docs/tech_papers /usr/doc/sscript/tech_papers \n",fd);
 fputs("install-man:\n",fd);
 fputs("\tcp docs/sscript.1 /usr/man/man1/sscript.1\n\n",fd);
 fputs("clean:\n",fd);
 fputs("\trm -f src/*.o\n",fd);
 fclose(fd);
 fd=fopen("src/config.h","w");
 printf("Creating config.h\n");
 fputs("/* Made with config */\n",fd);
 fputs("/* Change empty strings with <NO-STRING> */\n",fd);
 fputs("#define HANDLE_EMPTY_STRINGS\n",fd);
 fputs("/* Get remote IP when running a server-oriented script */\n",fd);
 fputs("#define GET_REMOTE_IP\n",fd);
 fputs("/* Fork on starting of server-oriented scripts */\n",fd);
 fputs("#define FORK_START\n",fd);
 fputs("#define IPFW \"/sbin/ipfwadm\"\n",fd);
 fputs("#define LOGFILE \"",fd);
 fputs(log_file,fd);
 fputs("\"\n",fd);
 fputs("#define CL_GUI_TK_PATH \"/usr/bin/wish\"\n",fd);
 fputs("#define PERL_BIN \"/usr/bin/perl\"\n",fd);
 fputs("/* This is the dir where SScript puts temp files. It should be onwed by you with read permission by you only */\n",fd);
 fputs("#define TEMP_DIR \"",fd);
 fputs(tmp_dir,fd);
 fputs("\"\n",fd);
 fputs("/* Show the header when starting SScript */\n",fd);
 fputs("#undef HEADER\n",fd);
 fputs("#define EDITOR \"pico\"\n",fd);
 fputs("/* Run in graphical mode */\n",fd);
 if(type==0) fputs("#undef GUI\n",fd);
 if(type==1) fputs("#define GUI\n",fd);
 if(type==2) fputs("#define GUI\n",fd);
 if(type==0) fputs("#undef GTK\n",fd);
 if(type==1) fputs("#undef GTK\n",fd);
 if(type==2) fputs("#define GTK\n",fd);
 fputs("/* define ONE of the following to set a custom GUI color set */\n",fd);
 fputs("#undef RES_STANDARD\n",fd);
 fputs("#define RES_3D\n",fd);
 fputs("#undef RES_COLORFUL\n",fd);
 printf("Done. Ready for compiling. You should read docs/sscript.doc too.\n");
 exit(0);
 return 0;
}
