/*
(C) 1998-99 Patrick Lambert <drow@fastethernet.net>

This program is under the GPL

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

Latest version of Socket Script is always available from
http://devplanet.fastethernet.net/sscript.html
*/

/* This program needs one of the ncurses or the curses library available
   from sunsite.unc */

#include "sscript.h"
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

void draw(char in[1024][512])
{
#if defined (USE_CURSES) || defined (USE_NCURSES)
 if(!strcasecmp(lindex(temp,1),"INIT"))
 {
  initscr();
  keypad(stdscr, TRUE);
  echo();
 }
 if(!strcasecmp(lindex(temp,1),"MOVE")) 
  move(atoi(lindex(temp,2)), atoi(lindex(temp,3)));
 if(!strcasecmp(lindex(temp,1),"SET"))
 { 
  if(!strcasecmp(lindex(temp,2),"BOLD")) attron(A_BOLD);
  if(!strcasecmp(lindex(temp,2),"DIM")) attron(A_DIM);
  if(!strcasecmp(lindex(temp,2),"UNDERLINE")) attron(A_UNDERLINE);
  if(!strcasecmp(lindex(temp,2),"BLINK")) attron(A_BLINK);
  if(!strcasecmp(lindex(temp,2),"REVERSE")) attron(A_REVERSE);
  if(!strcasecmp(lindex(temp,2),"NORMAL")) attron(A_NORMAL);
 }
 if(!strcasecmp(lindex(temp,1),"UNSET"))
 { 
  if(!strcasecmp(lindex(temp,2),"BOLD")) attroff(A_BOLD);
  if(!strcasecmp(lindex(temp,2),"DIM")) attroff(A_DIM);
  if(!strcasecmp(lindex(temp,2),"UNDERLINE")) attroff(A_UNDERLINE);
  if(!strcasecmp(lindex(temp,2),"BLINK")) attroff(A_BLINK);
  if(!strcasecmp(lindex(temp,2),"REVERSE")) attroff(A_REVERSE);
  if(!strcasecmp(lindex(temp,2),"NORMAL")) attroff(A_NORMAL);
 }
 if(!strcasecmp(lindex(temp,1),"PRINT"))
 {
  if(lindex(temp,3)!=NULL && lindex(temp,2)!=NULL && lindex(temp,4)!=NULL)
  {
   move(atoi(lindex(temp,3)), atoi(lindex(temp,2)));
   printw("%s", in[atoi(lindex(temp,4))]);
  }
 }
 if(!strcasecmp(lindex(temp,1),"GOTO"))
 {
  if(lindex(temp,3)!=NULL && lindex(temp,2)!=NULL)
  {
   move(atoi(lindex(temp,3)), atoi(lindex(temp,2)));
  }
 }
 if(!strcasecmp(lindex(temp,1),"REFRESH")) refresh();
 if(!strcasecmp(lindex(temp,1),"BREFRESH")) wrefresh(main_win);
 if(!strcasecmp(lindex(temp,1),"END")) endwin();
 if(!strcasecmp(lindex(temp,1),"BEEP")) beep();
 if(!strcasecmp(lindex(temp,1),"ASK")) getstr(in[atoi(lindex(temp,2))]);
 if(!strcasecmp(lindex(temp,1),"CLEAR")) clear();
 if(!strcasecmp(lindex(temp,1),"ERASE")) erase();
 if(!strcasecmp(lindex(temp,1),"LINES")) sprintf(in[atoi(lindex(temp,2))], "%d", LINES);
 if(!strcasecmp(lindex(temp,1),"COLS")) sprintf(in[atoi(lindex(temp,2))], "%d", COLS);
 if(!strcasecmp(lindex(temp,1),"BOX")) 
 {
  main_win=newwin(atoi(lindex(temp,3)), atoi(lindex(temp,2)), atoi(lindex(temp,5)), atoi(lindex(temp,4)));
  box(main_win, '|', '-');
 }
 if(!strcasecmp(lindex(temp,1),"DELBOX"))
 {
  delwin(main_win);
 }
 if(!strcasecmp(lindex(temp,1),"PRINTBOX")) 
 {
  mvwprintw(main_win,atoi(lindex(temp,3)),atoi(lindex(temp,2)),"%s",in[atoi(lindex(temp,4))]);
 }
 if(!strcasecmp(lindex(temp,1),"COLOR"))
 {
  start_color();
  if(!strcasecmp(lindex(temp,2),"RED"))
   init_pair(1, COLOR_RED, COLOR_BLACK);
  if(!strcasecmp(lindex(temp,2),"WHITE"))
   init_pair(1, COLOR_WHITE, COLOR_BLACK);
  if(!strcasecmp(lindex(temp,2),"GREEN"))
   init_pair(1, COLOR_GREEN, COLOR_BLACK);
  if(!strcasecmp(lindex(temp,2),"CYAN"))
   init_pair(1, COLOR_CYAN, COLOR_BLACK);
  attrset(COLOR_PAIR(1));
 }
#endif
}
