/*
(C) 1998-99 Patrick Lambert <drow@fastethernet.net>

This program is under the GPL

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

Latest version of Socket Script is always available from
http://devplanet.fastethernet.net/sscript.html
*/

/* This program uses ZLIB by Jean-loup Gailly and Mark Adler available
   from sunsite.unc.edu */

#include "sscript.h"
#ifdef USE_LIBZ
#include <stdio.h>
#include <zlib.h>
#include <malloc.h>

int zip_string(char *string, char *file)
{
 gzFile gfd;
 int len = strlen(string)+1;
 gfd = gzopen(file, "wb");
 if(gfd==NULL) { lasterror=124; return -1; }
 gzwrite(gfd, string, len);
 gzclose(gfd);
}

char *unzip_string(char *file)
{
 gzFile gfd;
 char data[512];
 int len = sizeof(data);
 gfd = gzopen(file, "rb");
 if(gfd==NULL) { lasterror=124; return (char *)"(null)"; }
 gzread(gfd, data, len);
 gzclose(gfd);
 strcpy(queryGlVar,data);
 return (char *)queryGlVar;
}

int unzip_file(char *i, char *o)
{
 gzFile gfd;
 FILE *fd;
 char *data;
 data = malloc(1);
 gfd = gzopen(i, "rb");
 fd = fopen(o, "w");
 while(gzread(gfd, data, 1)>0)
 fwrite(data, 1, 1, fd);
 gzclose(gfd);
 if(fd!=NULL) fclose(fd);
 free(data);
}

int zip_file(char *i, char *o)
{
 gzFile gfd;
 FILE *fd;
 char *data;
 data = malloc(1);
 fd = fopen(i, "r");
 gfd = gzopen(o, "wb");
 while(fread(data, 1, 1, fd)>0)
 gzwrite(gfd, data, 1);
 gzclose(gfd);
 free(data);
}
#endif
