/*
(C) 1998 Patrick Lambert <drow@fastethernet.net>

This program is free software. You can use, distribute and modify it if
you let this legal note in all future versions, and if the program made
stays under free software.

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

Latest version of Socket Script is always available from
http://devplanet.fastethernet.net/sscript.html
*/

#define VERSION 12
#include "sscript.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/file.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <netdb.h>
#include <arpa/inet.h>
#ifdef GUI
#include <malloc.h>
#include <sys/stat.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Dialog.h>  
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/SmeLine.h>
#define SetArg(which, val)      XtSetArg(args[nargs], (which),\
                                         (XtArgVal) (val)); nargs++
Widget  toplevel, top;
Screen  *screen;
Display *display;
XtAppContext ac, ac2;
XEvent event, qevent;
int displayed=0;

static Widget msgwidget, textbox, last, entrybox, mainbox, dialog1, okbutton, quitbutton, continuebutton, viewbox;
static Widget form, widgets[3], choicebutton[10], form, menu, menubutton1, menubutton2, menubutton3, menubutton4, menubutton5, menubutton6, menubutton7, menubutton8, menubutton9, menubutton10, entry;

static String sscript_resources[] = {
    "*resizeGravity: NorthWest",
    "*beNiceToColormap: false",
    "*topShadowContrast: 20",
    "*bottomShadowContrast: 40",
#ifdef RES_COLORFUL
    "*textbox*background: #503080",
    "*textbox*foreground: #FFAAFF",
    "*textbox*shadowWidth: 2",
    "*viewbox*shadowWidth: 2",
    "*dialog1*font: *-*-bold-i-*-*-14-*-*-*-*-*-*-*",
    "*text*font: *-*-bold-*-*-*-12-*-*-*-*-*-*-*",
    "*foreground: #AA2050",
    "*background: LightGray",
    "*viewbox*foreground: #000050",
    "*viewbox*background: #FFFFFF",
    "*Label*foreground: #050505",
#endif
#ifdef RES_STANDARD
    "*textbox*shadowWidth: 0",
    "*viewbox*shadowWidth: 0",
    "*foreground: #000000", 
    "*background: #FFFFFF",
#endif
#ifdef RES_3D
    "*textbox*foreground: #503080",
    "*textbox*shadowWidth: 2",
    "*viewbox*shadowWidth: 2",
    "*dialog1*font: *-*-bold-i-*-*-12-*-*-*-*-*-*-*",
    "*foreground: NavyBlue",
    "*background: LightGray",
    "*viewbox*foreground: #000000",
    "*viewbox*background: #FFFFFF",
    "*Label*foreground: #050505",
#endif
    NULL
};

void closebox() {
    XtDestroyWidget(msgwidget);  
    displayed=0;
}

int queryQuit(Widget result, XtPointer p1, XtPointer p2);
int queryOk(Widget result, XtPointer p1, XtPointer p2);

#endif

void handle_segv()
{
 char templog[512];
 sprintf(templog,"[%ld] Segmentation fault while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: Segmentation fault. I suggest you check your script for any typos.\nerrno=%d currently processing=%s pid=%d",errno,temp,pid);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Erreur de protection de memoire. Vous devriez verifier votre script pour des erreurs possibles.");
 else if(lang==2)
 sprintf(templog,"Error Interno: Falla en Segmentacin. Sugiero que cheques tu script para ver si no hay errores en ortografa.");
 if(!set_signals_off) { XFlush(display);
  msgbox("error",templog,strlen(templog)); }
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: Segmentation fault. I suggest you check your script for any typos. If the problem is an internal bug, please contact the author.\nerrno=%d\ncurrently processing=%s\npid=%d\n",errno,temp,pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Erreur de protection de memoire. Vous devriez verifier votre script pour des erreurs possibles.\n");
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: Falla en Segmentacin. Sugiero que cheques tu script para ver si no hay errores en ortografa.\n");
 }
#endif
 if(cas_cmp(cron,"")) system(cron);
 press();
 exit(1);
}

void handle_hup()
{
 char templog[512];
 sprintf(templog,"[%ld] Hangup while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: Hangup. Someone kill'ed -HUP this program... [pid=%d]",pid);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Hangup. Quelqu'un a tuer votre script...");
 else if(lang==2)
 sprintf(templog,"Error Interno: Hangup.");
 if(!set_signals_off) { XFlush(display);
  msgbox("error",templog,strlen(templog)); }
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: Hangup. Someone kill'ed -HUP this program... [pid=%d]\n",pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Hangup. Quelqu'un a tuer votre script...\n");
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: Hangup.\n");
 }
#endif
 if(cas_cmp(cron,"")) system(cron);
 press();
 exit(1);
}

void handle_int()
{
 char templog[512];
 sprintf(templog,"[%ld] Interrupt while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: Interrupt. Exiting... [pid=%d]",pid);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Interrupt. Sort... [pid=%d]",pid);
 else if(lang==2)
 sprintf(templog,"Error Interno: Interrupcin. Saliendo... [pid=%d]",pid);
 if(!set_signals_off) msgbox("error",templog,strlen(templog));
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: Interrupt. Exiting... [pid=%d]\n",pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Interrupt. Sort... [pid=%d]\n",pid);
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: Interrupcin. Saliendo... [pid=%d]\n",pid);
 }
#endif
 if(cas_cmp(cron,"")) system(cron);
 press();
 exit(1);
}

void handle_pipe()
{
 char templog[512];
 sprintf(templog,"[%ld] Broken pipe while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: Broken pipe. I tried to write when the connection was off [pid=%d]",pid);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Connection ferme. J'ai essaye d'ecrire quand la connection etait ferme.");
 else if(lang==2)
 sprintf(templog,"Error Interno: Pipa rota. Trat de escribir cuando la conexion estaba");
 if(!set_signals_off) { XFlush(display);
  msgbox("error",templog,strlen(templog)); }
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: Broken pipe. I tried to write when the connection wasn't established [pid=%d].\n",pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Connection ferme. J'ai essaye d'ecrire quand la connection etait ferme.\n");
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: Pipa rota. Trat de escribir cuando la conexion estaba\n");
 }
#endif
 if(cas_cmp(cron,"")) system(cron);
 press();
 exit(1);
}

void handle_bus()
{
 char templog[512];
 sprintf(templog,"[%ld] Bus error while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: Bus error [pid=%d]",pid);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Erreur du bus [pid=%d]",pid);
 else if(lang==2)
 sprintf(templog,"Error Interno: Bus error [pid=%d]",pid);
 if(!set_signals_off) { XFlush(display); msgbox("error",templog,NULL,0); }
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: Bus error [pid=%d].\n",pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Erreur du bus [pid=%d]\n",pid);
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: Bus error [pid=%d]\n",pid);
 }
#endif
 if(cas_cmp(cron,"")) system(cron);
 press();
 exit(1);
}

char *lindex(char *input_string, int word_number)
{
 char *tokens[1024];
 static char tmpstring[1024];
 int i;
 strcpy(tmpstring,input_string);
 tokens[i=0] = strtok(tmpstring, " ");
 while ((tokens[++i] = strtok(NULL, " ")));
 tokens[i] = NULL;
 return(tokens[word_number]);
}

int main(int argc, char *argv[])
{
 /* Ya.. a bit too many.. but it doesn't hang memory.. promise:) */
 int j,sockfd,len,port,debug,res,lenght,i,chop,loop=1,userhost=0;
 int temp3,listen_len,sockfd2,result,server_oriented=0,is_a_service=0;
 int pain_in_the=0,reversechop=0,current_for,max_for,min_for,strictwrite=0;
 int goto_on=0,strictcheck=0,from_len,othersck,rsck,tracing=0;
 int windows=0, cnt, opt=1;
 char server[255],in[1024][1024],buf[1024],blah[255],inchar;
 char master[255],virtual[255],inall[1024],temp2[255],matching[1024];
 char nick[255],user[255],temp4[255],filename[255],subnumber[255];
 char remote_ip[255]="", include_files[255][255], setremoteecho=0;
 struct sockaddr_in address;
 struct sockaddr_in listen_addr;
 struct sockaddr_in la;
 struct sockaddr_in from_addr;
 struct sockaddr_in other_addr;
 struct sockaddr_in r_addr;
 struct hostent     *hp;
 time_t lt;
 FILE *fp, *fpa, *fpb;
 set_signals_off=0;
 pid=0;
 for(i=0;i<255;i++) { strcpy(include_files[i],""); }
 strcpy(cron,"");
 strcpy(logfilename,LOGFILE);
 lang=0;
 if(getenv("LANG")!=NULL)
 {
  if(!cas_cmp(getenv("LANG"),"french")) lang=1;
  if(!cas_cmp(getenv("LANG"),"francais")) lang=1;
  if(!cas_cmp(getenv("LANG"),"spanish")) lang=2;
  if(!cas_cmp(getenv("LANG"),"espanol")) lang=2;
 }
 if(argv[1]==NULL)
 {
  strcpy(filename,"sscript.file");
 }
 else 
 {
  if(lang==0)
  if(strlen(argv[1])>250) printf("*** Warning: File name too long.\n");
  else if(lang==1)
  if(strlen(argv[1])>250) printf("*** Attention: Nom de fichier trop long\n");
  else if(lang==2)
  if(strlen(argv[1])>250) printf("*** Peligro: Nombre de arch ivo es muy grande.\n");
  strcpy(filename,argv[1]);
 }
 if(!cas_cmp(filename,"-d"))
 {
  if(argv[2]==NULL)
  {
   press();
   exit(1);
  }
  debugger(argv[2]);
  press();
  exit(0);
 }
#ifdef GUI
 /* initialization for msgbox, since it doesn't really handle callbacks */
 toplevel = XtAppInitialize(&ac2, "SScript", NULL, 0, &argc, argv, sscript_resources, NULL, 0);
 display = XtDisplay(toplevel);
 screen  = XtScreen(toplevel);
 if(!cas_cmp(filename,"-help"))
 {
  help(1, argc, argv);
  press();
  exit(0);
 }
 if(!cas_cmp(filename,"-c"))
 {
  if(argv[2]==NULL)
  {
   press();
   exit(1);
  }
  composer(argv[2], argc, argv);
  press();
  exit(0);
 }
#ifdef HEADER
 XFlush(display);
 if(lang==0)
 msgbox("header","Socket Script (win32 v1.2) by Drow <drow@wildstar.net>\nPlease see the documentation in docs/sscript.doc",50);
 else if(lang==1)
 msgbox("header","Socket Script (win32 v1.2) par Drow <drow@wildstar.net>\nVoir la documentation dans docs/sscript.doc",50);
 else if(lang==2)
 msgbox("header","Script de Socket (win32 v1.2) por Drow <drow@wildstar.net>\nPor Favor ve la documentacion en docs/sscript.doc",50);
 if(!cas_cmp(filename,"-version"))
 {
  press();
  exit(0);
 }
#endif
#else
 if(!cas_cmp(filename,"-help"))
 {
  help(0, argc, argv);
  press();  
  exit(0);
 }
 if(!cas_cmp(filename,"-c"))
 {
  /* for now it launches EDITOR.. but someday I might make a built in */
  if(argv[2]==NULL)
  {
   press();
   exit(1);
  }
  if(lang==0)
  {
   printf("Not in X-Window graphical mode, can't launch composer.\n");
   printf("Trying to launch: %s\n",EDITOR);
  }
  else if(lang==1)
  {
   printf("Pas en mode X-Window graphique. Incapable d'ouvrir le composer.\n");
   printf("Essayons: %s\n",EDITOR);
  }
  else if(lang==2)
  {
   printf("No en modo X-Window grafico, no se puede lanzar compositor.\n");
   printf("Tratando de lanzar: %s\n",EDITOR);
  }
  sleep(2);
  sprintf(temp4,"%s %s\n",EDITOR,argv[2]);
  system(temp4);
  press();
  exit(0);
 }
#ifdef HEADER
 if(lang==0)
 printf("\nSocket Script (win32 v1.2) by Drow <drow@wildstar.net>\nLoading script...\n");
 else if(lang==1)
 printf("\nSocket Script (win32 v1.2) par Drow <drow@wildstar.net>\nOverture du script...\n");
 else if(lang==2)
 printf("\nSocket Script (win32 v1.2) por Drow <drow@wildstar.net>\nCargando script...\n");
 if(!cas_cmp(filename,"-version"))
 {
  press();
  exit(0);
 }
#endif
#endif
 if(geteuid()==0 && getuid()!=0)
 {
  if(lang==0)
  printf("*** Can't run while being setuid root (eUID=%d UID=%d)\n",geteuid(),getuid());
  else if(lang==1)
  printf("*** Ne pas mettre ce programme root! (eUID=%d UID=%d)\n",geteuid(),getuid());
  else if(lang==2)
  printf("*** No se puede correr estando en setuid root (eUID=%d UID=%d)\n",geteuid(),getuid());
  press();
  exit(1);
 }
 sprintf(temp4,"[%ld] SScript starting: %s\n",time(NULL),filename);
 appendlog(temp4);
 if(!cas_cmp(filename,"-r"))
 {
  if(argv[2]==NULL || argv[3]==NULL || argv[4]==NULL)
  {
   printf("*** Syntax: sscript -r <remote ip> <port> <filename>\n");
   press();
   exit(1);
  }
#ifdef USE_TMP
  sprintf(filename,"/tmp/.ss%ld.file",time(NULL));
#else
  sprintf(filename,"ss%ld.file",time(NULL));
#endif
  remote(argv[2],argv[3],atoi(argv[4]),filename);
 }
 if(!(fp=fopen(filename,"r")))
 {
#ifdef GUI
  if(lang==0)
  sprintf(temp4,"Script %s not found. Try sscript -help.",filename);
  else if(lang==1)
  sprintf(temp4,"Script %s n'existe pas. Voir sscript -help.",filename);
  else if(lang==2)
  sprintf(temp4,"Script %s no encontrado. Prueba sscript -help.",filename);
  XFlush(display);
  msgbox("error",temp4,strlen(temp4));
#else
  if(lang==0)
  fprintf(stderr,"*** Script %s not found. Try sscript -help\n",filename);
  else if(lang==1)
  fprintf(stderr,"*** Script %s n'existe pas. Voir sscript -help\n",filename);
  else if(lang==2)
  fprintf(stderr,"*** Script %s no encontrado. Prueba sscript -help.\n",filename);
#endif
  press();
  exit(1);
 }
 /* check if it's a project file (*.prj) */
 if( filename[strlen(filename)-1]=='j' && filename[strlen(filename)-2]=='r' && filename[strlen(filename)-3]=='p')
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("info","Project file detected... merging scripts...",45);
  else if(lang==1)
  msgbox("info","Fichier project detecte... ouverture des scripts...",45);
  else if(lang==2)
  msgbox("info","Archivo de proyacto detectado... uniendo scripts...",45);
#else
  if(lang==0)
  printf("Project file detected... merging scripts...\n");
  else if(lang==1)
  printf("Fichier project detecte... ouverture des scripts...\n");
  else if(lang==2)
  printf("Archivo de proyacto detectado... uniendo scripts...\n");
#endif
  sprintf(filename,"/tmp/.ss%ld.script",time(NULL));
  /* prevents unauthorized tmp hacking */
  sprintf(temp4,"rm %s 2>/dev/null",filename);
  system(temp4);
  while(fgets(temp,255,fp)!=NULL)
  {
   if(lindex(temp,0)!=NULL && lindex(temp,1)!=NULL)
   if(temp[0]=='$')
   {
    temp[strlen(temp)-1]=' ';
    sprintf(temp4,"cat %s >> %s 2>> sscript.log \n",lindex(temp,1),filename);
    system(temp4);
   }
  }
  fclose(fp);
  fp=fopen(filename,"r");
 }
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: No header.",25);
  else if(lang==1)
  msgbox("error","Erreur script: Pas d'entete.",25);
  else if(lang==2)
  msgbox("error","Error en Script: no hay titulo.",25);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: No header.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Pas d'entete.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: no hay titulo.\n");
#endif
  press();
  exit(1);
 }
 if(cas_cmp(lindex(temp,0),"server"))
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Script must start with server <ip>.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Le script doit commencer avec server <ip>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: Script debe empezar con servidor <ip>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Script must start with server <ip>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Le script doit commencer avec server <ip>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Script debe empezar con servidor <ip>.\n");
#endif
  press();
  exit(1);
 }
 strcpy(server,(char *)lindex(temp,1));
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Expected port <port> and got EOF.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais port <port>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: puerto esperado <port>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected port <port> and got EOF.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais port <port>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: puerto esperado <port>.\n");
#endif
  press();
  exit(1);
 }
 if(cas_cmp(lindex(temp,0),"port"))
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Expected port <port>.",30);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais port <port>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: puerto esperado <port>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected port <port>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais port <port>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: puerto esperado <port>.\n");
#endif
  press();
  exit(1);
 }
 port = atoi(lindex(temp,1));
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Expected debug <mode> and got EOF.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais debug <mode>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: esperado debug <moda>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected debug <mode> and got EOF.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais debug <mode>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: esperado debug <moda>.\n");
#endif
  press();
  exit(1);
 }
 if(cas_cmp(lindex(temp,0),"debug"))
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Expected debug <mode>.",25);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais debug <mode>.",45);  
  else if(lang==2)
  msgbox("error","Error en Script: esperado debug <moda>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected debug <mode>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais debug <mode>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: esperado debug <moda>.\n");
#endif
  press();
  exit(1);
 }
 debug = atoi(lindex(temp,1));
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Expected chop <mode> and got EOF.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais chop <mode>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: Chop esperado <moda>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected chop <mode> and got EOF.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais chop <mode>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Chop esperado <moda>.\n");
#endif
  press();
  exit(1);
 }
 if(cas_cmp(lindex(temp,0),"chop"))
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Expected chop <mode>.",25);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais chop <mode>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: Chop esperado <moda>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected chop <mode>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais chop <mode>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Chop esperado <moda>.\n");
#endif
  press();
  exit(1);
 }
 chop = atoi(lindex(temp,1));
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Expected virtual <ip> and got EOF.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais virtual <ip>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: Virtual esperado <ip>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected virtual <ip> and got EOF.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais virtual <ip>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Virtual esperado <ip>.\n");
#endif
  press();
  exit(1);
 }
 if(cas_cmp(lindex(temp,0),"virtual"))
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Expected virtual <ip>.",25);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais virtual <ip>.",45);  
  else if(lang==2)
  msgbox("error","Error en Script: Virtual esperado <ip>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected virtual <ip>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais virtual <ip>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Virtual esperado <ip>.\n");
#endif
  press();
  exit(1);
 }
 strcpy(virtual,(char *)lindex(temp,1));
#ifdef HEADER
#ifndef GUI
 if(lang==0)
 {
  if(cas_cmp(server,"0")) printf("Connecting to %s port %d\n",server,port);
  else printf("Listening to port %d\n",port);
  if(debug) printf("Debug mode ON\n");
  if(!debug) printf("Debug mode OFF\n");
 }
 else if(lang==1)
 {
  if(cas_cmp(server,"0")) printf("Branchement sur %s port %d\n",server,port);
  else printf("Ecoute sur %d...\n",port);
  if(debug) printf("Debug mode active\n");
  if(!debug) printf("Debug mode non active\n");
 }
 else if(lang==2)
 {
  if(cas_cmp(server,"0")) printf("Conectando a puerto %s %d\n",server,port);
  else printf("Escuchando al puerto %d...\n",port);
  if(debug) printf("Modo debug ACTIVADO\n");
  if(!debug) printf("Modo debug NON ACTIVADO\n");
 }
#endif
#endif
#ifdef FORK_START
 if(!cas_cmp(server,"0"))
 /* server-oriented script */
 if(pid=fork())
 {
#ifdef HEADER
#ifndef GUI
  if(lang==0)
  printf("Going into the background...[pid=%d]\n",pid);
  else if(lang==1)
  printf("Allant en arriere-plan...[pid=%d]\n",pid);
  else if(lang==2)
  printf("Yendo hacia la portada...[pid=%d]\n",pid);
#endif
#endif
  press();
  exit(0);
 }
#endif
 /* connecting */
 if(!cas_cmp(server,"no-connection"))
 { /* no-connection script */ }
 else if(cas_cmp(server,"0"))
 {
  /* client-oriented script */
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if(sockfd<1)
  {
#ifdef GUI
   XFlush(display);
   if(lang==0)
   msgbox("error","Internal error: Socket failed.",25);
   else if(lang==1)
   msgbox("error","Erreur interne: Socket erreur.",25);
   else if(lang==2)
   msgbox("error","Error Interno: Fallo el Socket.",25);
#else
   if(lang==0)
   fprintf(stderr,"*** Internal error: Socket failed [%d].\n",errno);
   else if(lang==1)
   fprintf(stderr,"*** Erreur interne: Socket erreur. [%d].\n",errno);
   else if(lang==2)
   fprintf(stderr,"*** Error Interno: Fallo el Socket. [%d].\n",errno);
#endif
   press();
   exit(1);
  }
  address.sin_family = AF_INET;
  address.sin_addr.s_addr = inet_addr(server);
  address.sin_port = htons(port);
  len = sizeof(address);
  if(cas_cmp(virtual,"0"))
  {
   la.sin_family = AF_INET;
   la.sin_addr.s_addr = inet_addr(virtual);
   la.sin_port = 0;
   bind(sockfd, (struct sockaddr *)&la, sizeof(la));
  }
  result = connect(sockfd, (struct sockaddr *)&address, len);
  if(result==-1)
  {
#ifdef GUI
   XFlush(display);
   if(lang==0)
   msgbox("error","Script error: Can't connect to remote host.",30);
   else if(lang==1)
   msgbox("error","Erreur script: Incapable de me connecter.",30);
   else if(lang==2)
   msgbox("error","Error en Script: No se puede conectar a host remoto.",30);
#else
   if(lang==0)
   fprintf(stderr,"*** Script error: Can't connect to %s port %d [%d].\n",server,port,errno);
   else if(lang==1)
   fprintf(stderr,"*** Erreur script: Incapable de me connecter sur %s port %d [%d].\n",server,port,errno);
   else if(lang==2)
   fprintf(stderr,"*** Error en Script: No se puede conectar a host remoto %s %d [%d].\n",server,port,errno);
#endif
   press();
   exit(1);
  }
 }
 else
 {
  /* server-oriented script */
  server_oriented = 1;
  sockfd2 = socket(AF_INET, SOCK_STREAM, 0);
  if(sockfd2<1)
  {
#ifdef GUI
   XFlush(display);
   if(lang==0)
   msgbox("error","Internal error: Socket failed.",25);
   else if(lang==1)
   msgbox("error","Erreur interne: Socket erreur.",25);
   else if(lang==2)
   msgbox("error","Error Interno: Fallo el Socket.",25);
#else
   if(lang==0)
   fprintf(stderr,"*** Internal error: Socket failed [%d].\n",errno);
   else if(lang==1)
   fprintf(stderr,"*** Erreur interne: Socket erreur. [%d].\n",errno);
   else if(lang==2)
   fprintf(stderr,"*** Error Interno: Fallo el Socket. [%d].\n",errno);
#endif
   press();
   exit(1);
  }
  listen_addr.sin_family = AF_INET;
  listen_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  listen_addr.sin_port = htons(port);
  listen_len = sizeof(listen_addr); 
  if(geteuid()==0)
   setsockopt(sockfd2, SOL_SOCKET, SO_REUSEADDR, (char *) &opt, sizeof(int));
  /* ok how do you unlink something if the program gets kill'ed -5 ? */
  if(bind(sockfd2, (struct sockaddr *)&listen_addr, listen_len))
  {
#ifdef GUI
   XFlush(display);
   if(lang==0)
   msgbox("error","Internal error: Binding failed. Wait a few minutes and try again or recompile the server.",80);
   else if(lang==1)
   msgbox("error","Erreur interne: Erreur de l'attribution de l'addresse locale. Attendez quelque minutes et reessayez, ou recompilez le server.",80);
   else if(lang==2)
   msgbox("error","Error Interno: Union Fallo. Espera unos minutos y vuelve a intent ar o recompila el servidor.",80);
#else
   if(lang==0)
   fprintf(stderr,"*** Internal error: Binding failed. Wait a few minutes and try again or recompile the server.\n");
   else if(lang==1)
   fprintf(stderr,"*** Erreur interne: Erreur de l'attribution de l'addresse locale. Attendez quelque minutes et reessayez, ou recompilez le server.\n");
   else if(lang==2)
   fprintf(stderr,"*** Error Interno: Union Fallo. Espera unos minutos y vuelve a intent ar o recompila el servidor.\n");
#endif
   press();
   exit(1);
  }
  listen(sockfd2, 5);
  for(;;)
  {
   if(sockfd!=(int)NULL) close(sockfd);
   sockfd = accept(sockfd2, (struct sockaddr *)&address, &len);
   if(pid=fork()) break;
  }
#ifdef GET_REMOTE_IP
  from_len=sizeof(from_addr);
  memset(&from_addr, 0, sizeof(from_addr));
  if(getpeername(sockfd, (struct sockaddr *)&from_addr,&from_len) < 0)
  {
   sprintf(temp4,"[%ld] Connection from unknown host [pid=%d]\n",time(NULL),pid);
   appendlog(temp4);
  }
  else
  {
   sprintf(temp4,"[%ld] Connection from %s [pid=%d]\n",time(NULL),inet_ntoa(from_addr.sin_addr),pid);
   appendlog(temp4);
   strcpy(remote_ip,inet_ntoa(from_addr.sin_addr));
  }
#endif
 } /* main loop */
 signal(SIGSEGV, handle_segv);
 signal(SIGINT, handle_int);
 signal(SIGPIPE, handle_pipe);
 signal(SIGHUP, handle_hup);
 signal(SIGBUS, handle_bus);
 strcpy(in[0],"");
 for(i=0;argv[i]!=NULL;i++)
 {
  strcat(in[0],argv[i]);
  strcat(in[0]," ");
 }
 while(fgets(temp,255,fp)!=NULL)
 {
  temp[strlen(temp)-1]=' ';
  if(lindex(temp,0)==NULL || lindex(temp,0)==NULL) continue;
  if(tracing) addtrace();
  if(!cas_cmp(lindex(temp,0),"command"))
  {
   strcpy(temp4,in[atoi(lindex(temp,1))]);
   strcpy(temp,temp4);
  }
  if(!cas_cmp(lindex(temp,0),"setsignalsoff"))
  {
   set_signals_off=1;
  }
  if(!cas_cmp(lindex(temp,0),"setremoteecho"))
  {
   setremoteecho=1;
  }
  if(!cas_cmp(lindex(temp,0),"setwindows"))
  {
   windows=1;
  }
  if(!cas_cmp(lindex(temp,0),"settrace"))
  {
   tracing=1;
  }
  if(!cas_cmp(lindex(temp,0),"random"))
  {
   srandom(time(NULL));
   sprintf(in[atoi(lindex(temp,1))],"%d",random() % atoi(lindex2(temp,2)));
  }
  if(!cas_cmp(lindex(temp,0),"loop") && !cas_cmp(lindex(temp,1),"end"))
  {
   if(loop!=0)
   {
    if(fp!=NULL) fclose(fp);
    strcpy(temp2,lindex(temp,2));
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    {
     if(!cas_cmp(lindex(temp,0),"loop") && !cas_cmp(lindex(temp,1),"start") && !cas_cmp(lindex(temp,2),temp2))
     break;
    }
   }
   else
   {
    loop = 1;
   }
  }
  if(!cas_cmp(lindex(temp,0),"save"))
  {
   fpa=fopen(lindex(temp,2),"w");
   fputs(in[atoi(lindex(temp,1))],fpa);
   fputs("\n",fpa);
   if(fpa!=NULL) fclose(fpa);
  }
  if(!cas_cmp(lindex(temp,0),"cron"))
  {
   strcpy(cron,lrange(temp,1));
  }
  if(!cas_cmp(lindex(temp,0),"setstrictcheck"))
  {
   strictcheck = 1;
  }
  if(!cas_cmp(lindex(temp,0),"setlogfile"))
  {
   strcpy(logfilename,lindex(temp,1));
  }
  if(!cas_cmp(lindex(temp,0),"setuserhost"))
  {
   userhost = 1;
  }
  if(!cas_cmp(lindex(temp,0),"setservice"))
  {
   is_a_service = 1;
  }
  if(!cas_cmp(lindex(temp,0),"exit"))
  {
   sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
   appendlog(temp4);
   shutdown(sockfd,2);
   close(sockfd);
   if(cas_cmp(cron,"")) system(cron);
   press();
   exit(0);
  }
  if(!cas_cmp(lindex(temp,0),"goto"))
  {
   strcpy(subnumber,lindex(temp,1));
   if(fp!=NULL) fclose(fp);
   fp=fopen(filename,"r");
   while(fgets(temp,255,fp)!=NULL)
   { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
  }
  if(!cas_cmp(lindex(temp,0),"for"))
  {
   min_for=atoi(lindex(temp,2));
   max_for=atoi(lindex(temp,4));
   current_for=min_for;
  }
  if(!cas_cmp(lindex(temp,0),"endfor"))
  {
   if(current_for==max_for) break;
   current_for++;
   strcpy(temp4,lindex(temp,1));
   if(fp!=NULL) fclose(fp);
   fp=fopen(filename,"r");
   while(fgets(temp,255,fp)!=NULL)
   {
    if(!cas_cmp(lindex(temp,0),"for") && !cas_cmp(lindex(temp,1),temp4)) break;
   }
  }
  if(!cas_cmp(lindex(temp,0),"getenv"))
  {
   if(getenv(lindex2(temp,1))!=NULL)
   strncpy(in[atoi(lindex(temp,2))],getenv(lindex2(temp,1)),1024);
  }
  if(!cas_cmp(lindex(temp,0),"background"))
  {
   if(fork()) 
   {
    press();
    exit(0);
   }
  }
  if(!cas_cmp(lindex(temp,0),"choicebox"))
  {
#ifdef GUI
   choicebox(argc, argv);
   strcpy(in[atoi(lindex(temp,1))],queryGlVar);
#endif
  }
  if(!cas_cmp(lindex(temp,0),"setowner"))
  {
   setuid(atoi(lindex(temp,1)));
  }
  if(!cas_cmp(lindex(temp,0),"run"))
  {
   system(in[atoi(lindex(temp,1))]);
  }
  if(!cas_cmp(lindex(temp,0),"append"))
  {
   fpa=fopen(lindex(temp,2),"a");
   fputs(in[atoi(lindex(temp,1))],fpa);
   fputs("\n",fpa);
   if(fpa!=NULL) fclose(fpa);
  }
  if(!cas_cmp(lindex(temp,0),"remove"))
  {
   fpa=fopen(lindex(temp,2),"r");
#ifdef USE_TMP
   fpb=fopen("/tmp/.temp.tmp","w");
#else
   fpb=fopen("temp.tmp","w");
#endif
   while(fgets(temp4,255,fpa)!=NULL)
   if(cas_cmp(temp4,in[atoi(lindex(temp,1))])) fputs(temp4,fpb);
   if(fpb!=NULL) fclose(fpb);
   if(fpa!=NULL) fclose(fpa);
#ifdef USE_TMP
   sprintf(temp4,"mv /tmp/.temp.tmp %s\n",lindex(temp,2));
#else
   sprintf(temp4,"mv temp.tmp %s\n",lindex(temp,2));
#endif
   system(temp4);
  }
  if(!cas_cmp(lindex(temp,0),"rementry"))
  {
   fpa=fopen(lindex(temp,2),"r");
#ifdef USE_TMP
   fpb=fopen("/tmp/.temp.tmp","w");
#else
   fpb=fopen("temp.tmp","w");
#endif
   while(fgets(temp4,255,fpa)!=NULL)   
   if(cas_cmp(lindex(temp4,0),lindex2(in[atoi(lindex(temp,1))],0)))
    fputs(temp4,fpb);
   if(fpb!=NULL) fclose(fpb);
   if(fpa!=NULL) fclose(fpa);
#ifdef USE_TMP
   sprintf(temp4,"mv /tmp/.temp.tmp %s\n",lindex(temp,2));
#else
   sprintf(temp4,"mv temp.tmp %s\n",lindex(temp,2));
#endif
   system(temp4);
  }
  if(!cas_cmp(lindex(temp,0),"ask"))
  {
   gets(in[atoi(lindex(temp,1))]);
  }
  if(!cas_cmp(lindex(temp,0),"set"))
  {
   bzero(buf,1024);
   strcpy(buf,"");
   for(i=2;lindex(temp,i)!=NULL;i++)
   {
    if(reversechop) strcat(buf," ");
    if(*lindex(temp,i)=='$')
    {
     if(*(lindex(temp,i)+1)=='w')
     {
      i++;
      if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
      strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
     if(*(lindex(temp,i)+1)=='1') { sleep(1); }
     if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
     if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
     if(*(lindex(temp,i)+1)=='/')
     {
      i++;
      if(*(lindex(temp,i))=='0') strcat(buf,"\000");
      if(*(lindex(temp,i))=='1') strcat(buf,"\001");
      if(*(lindex(temp,i))=='2') strcat(buf,"\002");
      if(*(lindex(temp,i))=='3') strcat(buf,"\003");
      if(*(lindex(temp,i))=='4') strcat(buf,"\004");
      if(*(lindex(temp,i))=='5') strcat(buf,"\005");
      if(*(lindex(temp,i))=='6') strcat(buf,"\006");
      if(*(lindex(temp,i))=='7') strcat(buf,"\007");
      if(*(lindex(temp,i))=='8') strcat(buf,"\008");
      if(*(lindex(temp,i))=='9') strcat(buf,"\009");
     }
     if(*(lindex(temp,i)+1)=='p')
     { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
     if(*(lindex(temp,i)+1)=='t')
     {
      lt=time(NULL);
      strcpy(temp4,ctime(&lt));
      temp4[strlen(temp4)-1]=' ';
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='r')
     {
      if(fp!=NULL) fclose(fp);
      fp=fopen(lindex(temp,1),"r");
     }
     if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
     if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
     if(*(lindex(temp,i)+1)=='%')
     {
      sprintf(temp4,"%d",current_for);
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='2') { sleep(2); }
     if(*(lindex(temp,i)+1)=='3') { sleep(3); }
     if(*(lindex(temp,i)+1)=='g')
     {
      strcpy(subnumber,lindex(temp,(i+1)));
      if(fp!=NULL) fclose(fp);
      fp=fopen(filename,"r");
      while(fgets(temp,255,fp)!=NULL)
       { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
      goto_on = 1;
      break;
     }
     if(*(lindex(temp,i)+1)=='4') { sleep(4); }
     if(*(lindex(temp,i)+1)=='5') { sleep(5); }
     if(*(lindex(temp,i)+1)=='6') { sleep(6); }
     if(*(lindex(temp,i)+1)=='7') { sleep(7); }
     if(*(lindex(temp,i)+1)=='8') { sleep(8); }
     if(*(lindex(temp,i)+1)=='9') { sleep(9); }
     if(*(lindex(temp,i)+1)=='n')
     {
      strcat(buf,nick);  
     } 
     if(*(lindex(temp,i)+1)=='u')
     {
      strcat(buf,user);
     }
     if(*(lindex(temp,i)+1)=='e')
     {
      sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
      appendlog(temp4);         
      shutdown(sockfd,2);
      close(sockfd);
      if(cas_cmp(cron,"")) system(cron);
      press();
      exit(0);
     }
     if(*(lindex(temp,i)+1)=='i')
     {
      i++;
      fpa=fopen(lindex(temp,i),"r");
      strcpy(temp2,"");
      for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
       fgets(temp2,255,fpa);
      strcat(buf,temp2);
      if(fpa!=NULL) fclose(fpa);
      i++;
     }
     if(*(lindex(temp,i)+1)=='b')
     {
      goto_on = 1;
      loop = 0;
     }
     if(*(lindex(temp,i)+1)=='s')
     {
      i++;
      strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
    }   
    else
    {
     strcat(buf,lindex(temp,i));
    }
    if(!reversechop) strcat(buf," ");
   }
   strcpy(in[atoi(lindex(temp,1))],buf);
  }
  if(!cas_cmp(lindex(temp,0),"setstrictwrite"))
  {
   strictwrite=1;
  }
  if(!cas_cmp(lindex(temp,0),"setmaster"))
  {
   strcpy(master,lindex(temp,1));
  }
  if(!cas_cmp(lindex(temp,0),"file"))
  {
   if(!cas_cmp(lindex(temp,1),"exist"))
   {
    fpb=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpb==NULL) strcpy(in[atoi(lindex(temp,3))],"1 ;");
    else if(fileno(fpb)<0) strcpy(in[atoi(lindex(temp,3))],"1 ;");
    else strcpy(in[atoi(lindex(temp,3))],"0 ;");
    if(fpb!=NULL) fclose(fpb);
   }
  }
  if(!cas_cmp(lindex(temp,0),"dump"))
  {
   fpa=fopen(lindex2(in[atoi(lindex(temp,1))],0),"r");
   while((cnt = read(fileno(fpa), temp4, 250))>0)
    write(sockfd, temp4, cnt);
   if(fpa!=NULL) fclose(fpa);
  }
  /* future binary c/s work */
  if(!cas_cmp(lindex(temp,0),"binary-get"))
  {
   fpa=fopen(lindex(temp,1),"w");
   while((cnt = read(sockfd, temp4, sizeof(temp4)))>0)
    write((int)fpa, temp4, cnt);
   if(fpa!=NULL) fclose(fpa);
  }
/*
  if(!cas_cmp(lindex(temp,0),"devstat"))
  {
   strcpy(in[atoi(lindex(temp,2))],if_setup(lindex(temp,1)));
  }
*/
  if(!cas_cmp(lindex(temp,0),"parse"))
  {
   if(!cas_cmp(lindex(temp,1),"<<"))
   {
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    {
     if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3)) break;
     in[atoi(lindex(temp,2))][i]=' ';
    }
   }
   if(!cas_cmp(lindex(temp,1),"<"))
   {
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    {
     if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3)) break;
     in[atoi(lindex(temp,2))][i]=' ';
    }
    in[atoi(lindex(temp,2))][i]=' ';
   }
   if(!cas_cmp(lindex(temp,1),">"))
   {
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    { if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3)) break; }
    for(i=i;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    { in[atoi(lindex(temp,2))][i]=' '; }
   }
   if(!cas_cmp(lindex(temp,1),">>"))
   {
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    { if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3)) break; }
    i++;
    for(i=i;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    { in[atoi(lindex(temp,2))][i]=' '; }
   } 
   if(!cas_cmp(lindex(temp,1),"!"))
   {
    strcpy(temp4,"");
    for(i=0;lindex(in[atoi(lindex2(temp,2))],i)!=NULL;i++)
    {
     strcat(temp4,lindex(in[atoi(lindex2(temp,2))],i));
    }
    strcpy(in[atoi(lindex2(temp,2))],temp4);
   }
   if(!cas_cmp(lindex(temp,1),"_>"))
   {
    j=0;
    strcpy(inall,"");
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    {
     inall[j]=in[atoi(lindex(temp,2))][i];
     j++;
     if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3))
     {
      inall[j]=' ';
      j++;
     }
    }
    strcpy(in[atoi(lindex(temp,2))],inall);
   }
   if(!cas_cmp(lindex(temp,1),"<_"))
   {
    j=0;
    strcpy(inall,"");
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    {
     if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3))
     {
      inall[j]=' ';
      j++;
     }
     inall[j]=in[atoi(lindex(temp,2))][i];
     j++;
    }
    strcpy(in[atoi(lindex(temp,2))],inall);
   }
  }
  if(!cas_cmp(lindex(temp,0),"cl"))
  {
   if(!cas_cmp(lindex(temp,1),"gui-tk"))
   {
    gui_tk_cl(sockfd,in);
   }
   else if(!cas_cmp(lindex(temp,1),"utils"))
   {
    utils_cl(sockfd,in);
   }
   else if(!cas_cmp(lindex(temp,1),"ssdb"))
   {
    ssdb_cl(sockfd,in);
   }
   else if(!cas_cmp(lindex(temp,1),"ssdb2"))
   {
    ssdb2_cl(in);
   }
/* ---------------------------------------------------------------- */
/* *****        CUSTOM LIBRARIES SHOULD BE ADDED HERE        ****** */
/* ---------------------------------------------------------------- */
   else
   {
    for(i=0;lindex(include_files[i],0)!=NULL;i++)
    {
     if(!cas_cmp(lindex(include_files[i],0),lindex2(temp,1)))
     {
      sprintf(temp4,"%s %s",lindex(include_files[i],1),temp);
      system(temp4);
     }
    }
   }
  }
  if(!cas_cmp(lindex(temp,0),"ping"))
  {
   othersck=socket(AF_INET, SOCK_STREAM, 0);
   other_addr.sin_family = AF_INET;
   other_addr.sin_addr.s_addr = inet_addr(lindex(temp,1));
   other_addr.sin_port = htons(7);
   connect(othersck, (struct sockaddr*) &other_addr,sizeof(other_addr));
   temp3=write(othersck,"ping\n",strlen("ping\n"));
   temp3=read(othersck,temp4,temp3);
   close(othersck);
  }
  if(!cas_cmp(lindex(temp,0),"test"))
  {
   if((othersck=socket(AF_INET, SOCK_STREAM, 0))<0)
   sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
   other_addr.sin_family = AF_INET;
   other_addr.sin_addr.s_addr = inet_addr(lindex2(in[atoi(lindex(temp,1))],0));
   other_addr.sin_port = htons(atoi(lindex2(in[atoi(lindex(temp,1))],1)));
   if(connect(othersck, (struct sockaddr*)&other_addr,sizeof(other_addr))==-1)
   sprintf(in[atoi(lindex(temp,1))],"CONNECT FAILED: %s",strerror(errno));
   else strcpy(in[atoi(lindex(temp,1))],"0");
   close(othersck);
  }
  if(!cas_cmp(lindex(temp,0),"rdisconnect"))
  {
   shutdown(rsck,2);
   close(rsck);
  }
  if(!cas_cmp(lindex(temp,0),"rconnect"))
  {
   if((rsck=socket(AF_INET, SOCK_STREAM, 0))<0)
   sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
   r_addr.sin_family = AF_INET;
   r_addr.sin_addr.s_addr = inet_addr(lindex2(in[atoi(lindex(temp,1))],0));
   r_addr.sin_port = htons(atoi(lindex2(in[atoi(lindex(temp,1))],1)));
   if(connect(rsck, (struct sockaddr*)&r_addr,sizeof(r_addr))==-1)
   sprintf(in[atoi(lindex(temp,1))],"CONNECT FAILED: %s",strerror(errno));
   else strcpy(in[atoi(lindex(temp,1))],"0");
  }
  if(!cas_cmp(lindex(temp,0),"rread"))
  {
   bzero(in[atoi(lindex(temp,1))], 1024);
   for(i=0;(result=read(rsck,&inchar,1))!='\0';i++)
   {
    in[atoi(lindex(temp,1))][i]=inchar;
    if(inchar=='\n') break;
   }
   if (chop) in[atoi(lindex(temp,1))][i-1]=' ';
   in[atoi(lindex(temp,1))][i]=' ';
   if(lindex(in[atoi(lindex2(temp,1))],0)==NULL) strcpy(in[atoi(lindex2(temp,1))],"<NO-STRING>");
  }
  if(!cas_cmp(lindex(temp,0),"rwrite"))
  {
   bzero(buf,1024);
   strcpy(buf,"");
   for(i=0;lindex(in[atoi(lindex2(temp,1))],i)!=NULL;i++)
   {
    if(reversechop) strcat(buf," ");
    strcat(buf,lindex(in[atoi(lindex2(temp,1))],i));
    if(!reversechop) strcat(buf," ");
   }
   if(!strictwrite)
   {
    if(windows) strcat(buf,"\r\n");
    else strcat(buf,"\n");
   }  
   else buf[strlen(buf)-1]='\n';
   if(goto_on) goto_on=0; else
   write(rsck, buf, strlen(buf));
   if(debug) printf(">>> %s\n",buf);
  }
  if(!cas_cmp(lindex(temp,0),"include"))
  {
   for(i=0;lindex(include_files[i],0)!=NULL;i++) { }
   sprintf(include_files[i],"%s %s ;",lindex(temp,1),lindex2(temp,2));
  }
  if(!cas_cmp(lindex(temp,0),"require-gui"))
  {
#ifndef GUI
   if(lang==0)
   printf("This script needs SScript to be compiled as a graphical application (in X-Window).\n");
   else if(lang==1)
   printf("Ce script a besoin que SScript soit compile comme application graphique (dans X-Window).\n");
   else if(lang==2)
   printf("Este Script necesita SScript paea ser compilado como aplicacion grafica (X-Window).\n");
   press();
   exit(1);
#endif
  }
  if(!cas_cmp(lindex(temp,0),"require"))
  {
   if(atoi(lindex(temp,1)) > VERSION)
   {
#ifdef GUI
    XFlush(display);
    if(lang==0)
    msgbox("error","This script requires a newer Socket Script version. You can find the latest SScript at http://devplanet.fastethernet.net/sscript.html",120); 
    else if(lang==1)
    msgbox("error","Ce script a besoin d'une version de Socket Script plus recente. Vous pouvez en trouver une a http://devplanet.fastethernet.net/sscript.html",120);
    else if(lang==2)
    msgbox("error","Este script necesita una version nueva de Socket Script. Puedes encontrar la mas nueva en http://devplanet.fastethernet.net/sscript.html",120);
#else
    if(lang==0)
    printf("This script requires a newer Socket Script version. You can find the latest SScript at http://devplanet.fastethernet.net/sscript.html\n");
    else if(lang==1)
    printf("Ce script a besoin d'une version de Socket Script plus recente. Vous pouvez en trouver une a http://devplanet.fastethernet.net/sscript.html\n");
    else if(lang==2)
    printf("Este script necesita una version nueva de Socket Script. Puedes encontrar la mas nueva en http://devplanet.fastethernet.net/sscript.html\n");
#endif
    press();
    exit(1);
  } }
  if(!cas_cmp(lindex(temp,0),"version"))
  {
   if(lang==0)
   printf("SScript (win32 v1.2) by Drow <drow@wildstar.net>\n");
   else if(lang==1)
   printf("SScript (win32 v1.2) par Drow <drow@wildstar.net>\n");
   else if(lang==2)
   printf("SScript (win32 v1.2) por Drow <drow@wildstar.net>\n");
  }
  if(!cas_cmp(lindex(temp,0),"addlog"))
  {
   sprintf(temp4,"[%ld] %s\n",time(NULL),in[atoi(lindex(temp,1))]);
   appendlog(temp4);
  }
  if(!cas_cmp(lindex(temp,0),"udpsend"))
  {
   udp_send(in);
  }
  if(!cas_cmp(lindex(temp,0),"udplisten"))
  {
   udp_listen(in);
  }
  if(!cas_cmp(lindex(temp,0),"icmplisten"))
  {
   icmp_detect(in);
  }
  if(!cas_cmp(lindex(temp,0),"resolve"))
  {
   resolve(in);
  }
  if(!cas_cmp(lindex(temp,0),"raw"))
  {
#ifdef RAWLINUX
   raw_linux(in,1);
#endif
  }
  if(!cas_cmp(lindex(temp,0),"rawp"))
  {
#ifdef RAWLINUX   
   raw_linux(in,0);
#endif
  }
  if(!cas_cmp(lindex(temp,0),"read"))
  {
   bzero(in[atoi(lindex(temp,1))], 1024);
   for(i=0;(result=read(sockfd,&inchar,1))!='\0';i++)
   {
    in[atoi(lindex(temp,1))][i]=inchar;
    if(inchar=='\n') break;
    /*strcpy(temp4,"");
    temp4[0]=inchar;*/
   }
   if(setremoteecho) write(sockfd,in[atoi(lindex(temp,1))],sizeof(in[atoi(lindex(temp,1))]));
   if (chop) in[atoi(lindex(temp,1))][i-1]=' ';
   in[atoi(lindex(temp,1))][i]=' ';
#ifdef HANDLE_EMPTY_STRINGS
   /* to prevent SIGSEVG on empty input */
   if(strlen(in[atoi(lindex(temp,1))])<3)
   {
    strcpy(in[atoi(lindex(temp,1))],"<NO-STRING>");
   }
   if(lindex2(in[atoi(lindex(temp,1))],0)==NULL)
   {
    strcpy(in[atoi(lindex(temp,1))],"<NO-STRING>");
   }
#endif
   if(strictcheck)
   {
    if(!cas_cmp(in[atoi(lindex(temp,1))],"") || !cas_cmp(in[atoi(lindex(temp,1))],"\n") || !cas_cmp(in[atoi(lindex(temp,1))],"\0"))
    {
     strcpy(in[atoi(lindex(temp,1))],"<NO-STRING>");
    }
   }
   if(!result && server_oriented)
   { 
    sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
    appendlog(temp4);         
    shutdown(sockfd,2);
    close(sockfd);
    if(cas_cmp(cron,"")) system(cron);
    press();
    exit(0);
   }
   if(debug) printf("[%d] [%s]\n",atoi(lindex(temp,1)),in[atoi(lindex(temp,1))]);
   if(userhost)
   {
    if(lindex(in[atoi(lindex(temp,1))],0)!=NULL) strcpy(temp4,lindex(in[atoi(lindex(temp,1))],0));
    bzero(nick,255);
    bzero(user,255);
    strcpy(nick,"");
    strcpy(user,"");
    if(is_a_service)
    {
     strcpy(nick,temp4);
     nick[0]=' ';
    }
    if(strchr(temp4,'!')!=NULL)
    {
     j=0;
     for(i=1;temp4[i]!='!';i++)
     {
      nick[j]=temp4[i];
      j++;
     }
     j=0;
     for(i=(i+1);(char)temp4[i]!=(char)NULL;i++)
     {
      user[j]=temp4[i];
      j++;
     }
    }
   }
  }
  if(!cas_cmp(lindex(temp,0),"saveall"))
  {
   fpa=fopen(lindex(temp,1),"a");
   while(cas_cmp(inall," "))
   {
    bzero(inall, 1024);
    for(i=0;read(sockfd,&inchar,1)!='\0';i++)
    {
     inall[i]=inchar;
     if(inchar=='\n') break;
    }
    if (chop) inall[i-1]=' ';
    inall[i]=' ';
    if(debug) printf("[%d] [%s]\n",atoi(lindex(temp,1)),inall);
    fputs(inall,fpa);
    fputs("\n",fpa);
   }
   if(fpa!=NULL) fclose(fpa);
  }
  if(!cas_cmp(lindex(temp,0),"wait")) sleep(1);
  if(!cas_cmp(lindex(temp,0),"ifmaster"))
  {
   if(!cas_cmp(lindex(temp,3),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,2)))))
   {
    fpa=fopen(master,"r");
    while(fgets(temp2,255,fpa)!=NULL)
    {
     if(!match(lindex2(temp2,0),lindex(in[atoi(lindex(temp,1))],0)))
     {
      bzero(buf,1024);
      strcpy(buf,"");
      for(i=4;lindex(temp,i)!=NULL;i++)
      {
       if(reversechop) strcat(buf," ");
       if(*lindex(temp,i)=='$')
       {
        if(*(lindex(temp,i)+1)=='w')
        {
         i++;
         if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
         strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
         i++;
        }
        if(*(lindex(temp,i)+1)=='1') { sleep(1); }
        if(*(lindex(temp,i)+1)=='2') { sleep(2); }
        if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
        if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
        if(*(lindex(temp,i)+1)=='/')
        {
         i++;
         if(*(lindex(temp,i))=='0') strcat(buf,"\000");
         if(*(lindex(temp,i))=='1') strcat(buf,"\001");
         if(*(lindex(temp,i))=='2') strcat(buf,"\002");
         if(*(lindex(temp,i))=='3') strcat(buf,"\003");
         if(*(lindex(temp,i))=='4') strcat(buf,"\004");
         if(*(lindex(temp,i))=='5') strcat(buf,"\005");
         if(*(lindex(temp,i))=='6') strcat(buf,"\006");
         if(*(lindex(temp,i))=='7') strcat(buf,"\007");
         if(*(lindex(temp,i))=='8') strcat(buf,"\008");
         if(*(lindex(temp,i))=='9') strcat(buf,"\009");
        }
        if(*(lindex(temp,i)+1)=='p') 
        { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
        if(*(lindex(temp,i)+1)=='t')
        {
         lt=time(NULL);
         strcpy(temp4,ctime(&lt));
         temp4[strlen(temp4)-1]=' ';
         strcat(buf,temp4);
        }
        if(*(lindex(temp,i)+1)=='r')
        {
         if(fp!=NULL) fclose(fp);
         fp=fopen(lindex(temp,1),"r");
        }
        if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
        if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
        if(*(lindex(temp,i)+1)=='3') { sleep(3); }
        if(*(lindex(temp,i)+1)=='%')              
        {
         sprintf(temp4,"%d",current_for);
         strcat(buf,temp4);
        }
        if(*(lindex(temp,i)+1)=='4') { sleep(4); }
        if(*(lindex(temp,i)+1)=='g')
        {
         strcpy(subnumber,lindex(temp,(i+1)));
         if(fp!=NULL) fclose(fp);
         fp=fopen(filename,"r");
         while(fgets(temp,255,fp)!=NULL)
         { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
         pain_in_the=1;
         goto_on = 1;
         break;
        }
        if(*(lindex(temp,i)+1)=='5') { sleep(5); }
        if(*(lindex(temp,i)+1)=='6') { sleep(6); }
        if(*(lindex(temp,i)+1)=='7') { sleep(7); }
        if(*(lindex(temp,i)+1)=='8') { sleep(8); }
        if(*(lindex(temp,i)+1)=='i')
        {    
         i++;
         fpa=fopen(lindex(temp,i),"r");
         strcpy(temp2,"");
         for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
          fgets(temp2,255,fpa);
         strcat(buf,temp2);
         if(fpa!=NULL) fclose(fpa); 
         i++;
        }
        if(*(lindex(temp,i)+1)=='9') { sleep(9); }
        if(*(lindex(temp,i)+1)=='n')
        {
         strcat(buf,nick);
        }
        if(*(lindex(temp,i)+1)=='u')
        {
         strcat(buf,user);
        }
        if(*(lindex(temp,i)+1)=='e')
        {
         sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
         appendlog(temp4);         
         shutdown(sockfd,2);
         close(sockfd);
         if(cas_cmp(cron,"")) system(cron);
         press();
         exit(0);
        }
        if(*(lindex(temp,i)+1)=='b')
        {
         goto_on = 1;
         loop = 0;
        }
        if(*(lindex(temp,i)+1)=='s')
        {
         i++;
         strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
         i++;
        }
       } 
       else
       {   
        strcat(buf,lindex(temp,i));
       }
       if(!reversechop) strcat(buf," ");
      }
      strcat(buf,"\n");
      if(goto_on) goto_on=0; else
      write(sockfd, buf, strlen(buf));
      if(debug) printf(">>> %s\n",buf);
     }
     if(pain_in_the) { pain_in_the=0; break; }
    }  
   if(fpa!=NULL) fclose(fpa);
   }
  }
  if(!cas_cmp(lindex(temp,0),"ifmaster2"))
  {
   if(!cas_cmp(lindex(temp,3),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,2)))))
   {   
    if(!cas_cmp(lindex(temp,5),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,4)))))
    {
     fpa=fopen(master,"r");
     while(fgets(temp2,255,fpa)!=NULL)
     {
      if(!match(lindex2(temp2,0),lindex(in[atoi(lindex(temp,1))],0)))
      {
       bzero(buf,1024);
       strcpy(buf,"");
       for(i=6;lindex(temp,i)!=NULL;i++)
       {
        if(reversechop) strcat(buf," ");
        if(*lindex(temp,i)=='$')
        {
         if(*(lindex(temp,i)+1)=='w')
         {
          i++;
          if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
          strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
          i++;
         }
         if(*(lindex(temp,i)+1)=='1') { sleep(1); }
         if(*(lindex(temp,i)+1)=='2') { sleep(2); }
         if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
         if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
         if(*(lindex(temp,i)+1)=='/')
         {
          i++;
          if(*(lindex(temp,i))=='0') strcat(buf,"\000");
          if(*(lindex(temp,i))=='1') strcat(buf,"\001");
          if(*(lindex(temp,i))=='2') strcat(buf,"\002");
          if(*(lindex(temp,i))=='3') strcat(buf,"\003");
          if(*(lindex(temp,i))=='4') strcat(buf,"\004");
          if(*(lindex(temp,i))=='5') strcat(buf,"\005");
          if(*(lindex(temp,i))=='6') strcat(buf,"\006");
          if(*(lindex(temp,i))=='7') strcat(buf,"\007");
          if(*(lindex(temp,i))=='8') strcat(buf,"\008");
          if(*(lindex(temp,i))=='9') strcat(buf,"\009");
         }
         if(*(lindex(temp,i)+1)=='p') 
         { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
         if(*(lindex(temp,i)+1)=='t')
         {
          lt=time(NULL);
          strcpy(temp4,ctime(&lt));
          temp4[strlen(temp4)-1]=' ';
          strcat(buf,temp4);
         }
         if(*(lindex(temp,i)+1)=='r')
         {
          if(fp!=NULL) fclose(fp);
          fp=fopen(lindex(temp,1),"r");
         }
         if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
         if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
         if(*(lindex(temp,i)+1)=='3') { sleep(3); }
         if(*(lindex(temp,i)+1)=='%')              
         {
          sprintf(temp4,"%d",current_for);
          strcat(buf,temp4);
         }
         if(*(lindex(temp,i)+1)=='4') { sleep(4); }
         if(*(lindex(temp,i)+1)=='5') { sleep(5); }
         if(*(lindex(temp,i)+1)=='g')
         {
          strcpy(subnumber,lindex(temp,(i+1)));
          if(fp!=NULL) fclose(fp);
          fp=fopen(filename,"r");
          while(fgets(temp,255,fp)!=NULL)
          { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
          pain_in_the=1;
          goto_on = 1;
          break;
         }
         if(*(lindex(temp,i)+1)=='6') { sleep(6); }
         if(*(lindex(temp,i)+1)=='i')
         {    
          i++;
          fpa=fopen(lindex(temp,i),"r");
          strcpy(temp2,"");
          for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
           fgets(temp2,255,fpa);
          strcat(buf,temp2);
          if(fpa!=NULL) fclose(fpa); 
          i++;
         }
         if(*(lindex(temp,i)+1)=='7') { sleep(7); }
         if(*(lindex(temp,i)+1)=='8') { sleep(8); }
         if(*(lindex(temp,i)+1)=='9') { sleep(9); }
         if(*(lindex(temp,i)+1)=='e')
         {
          sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
          appendlog(temp4);         
          shutdown(sockfd,2);
          close(sockfd);
          if(cas_cmp(cron,"")) system(cron);
          press();
          exit(0);
         }
         if(*(lindex(temp,i)+1)=='n')
         {
          strcat(buf,nick);
         }
         if(*(lindex(temp,i)+1)=='u')
         {
          strcat(buf,user);
         }
         if(*(lindex(temp,i)+1)=='b')
         {
          goto_on = 1;
          loop = 0;
         }
         if(*(lindex(temp,i)+1)=='s')
         {
          i++;
          strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
          i++;
         }
        } 
        else
        {   
         strcat(buf,lindex(temp,i));
        } 
        if(!reversechop) strcat(buf," ");
       }
       strcat(buf,"\n");
       if(goto_on) goto_on=0; else
       write(sockfd, buf, strlen(buf));
       if(debug) printf(">>> %s\n",buf);
      }
     if(pain_in_the) { pain_in_the=0; break; }
     }
    if(fpa!=NULL) fclose(fpa);
    }
   }
  }
  if(!cas_cmp(lindex(temp,0),"msgbox"))
  {
#ifdef GUI
   XFlush(display);
   msgbox("info",in[atoi(lindex(temp,1))],strlen(in[atoi(lindex(temp,1))]));
#endif
  }
  if(!cas_cmp(lindex(temp,0),"viewfile"))
  {
#ifdef GUI
   if(lindex(temp,2)==NULL || cas_cmp(lindex(temp,2),"-query"))
    viewfile(lindex(temp,1),argc,argv);
   else
   {
    view_n_query(lindex(temp,1),in[atoi(lindex(temp,3))],argc,argv);  
    strcpy(in[atoi(lindex(temp,3))],queryGlVar);
   }
#endif
  }
  if(!cas_cmp(lindex(temp,0),"query"))
  {
#ifdef GUI
   query(in[atoi(lindex(temp,1))],argc,argv);
   strcpy(in[atoi(lindex(temp,2))],queryGlVar);
#endif
  }
  if(!cas_cmp(lindex(temp,0),"print"))
  {
   bzero(buf,1024);
   strcpy(buf,"");
   for(i=1;lindex(temp,i)!=NULL;i++)
   {
    if(reversechop) strcat(buf," ");
    if(*lindex(temp,i)=='$')
    {
     if(*(lindex(temp,i)+1)=='w')
     {
      i++;
      if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
      strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
     if(*(lindex(temp,i)+1)=='n')
     {
      strcat(buf,nick);
     }
     if(*(lindex(temp,i)+1)=='1') { sleep(1); }
     if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
     if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
     if(*(lindex(temp,i)+1)=='/')
     {
      i++;
      if(*(lindex(temp,i))=='0') strcat(buf,"\000");
      if(*(lindex(temp,i))=='1') strcat(buf,"\001");
      if(*(lindex(temp,i))=='2') strcat(buf,"\002");
      if(*(lindex(temp,i))=='3') strcat(buf,"\003");
      if(*(lindex(temp,i))=='4') strcat(buf,"\004");
      if(*(lindex(temp,i))=='5') strcat(buf,"\005");
      if(*(lindex(temp,i))=='6') strcat(buf,"\006");
      if(*(lindex(temp,i))=='7') strcat(buf,"\007");
      if(*(lindex(temp,i))=='8') strcat(buf,"\008");
      if(*(lindex(temp,i))=='9') strcat(buf,"\009");
     }
     if(*(lindex(temp,i)+1)=='p') 
     { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
     if(*(lindex(temp,i)+1)=='t')
     {
      lt=time(NULL);
      strcpy(temp4,ctime(&lt));
      temp4[strlen(temp4)-1]=' ';
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='r')
     {
      if(fp!=NULL) fclose(fp);
      fp=fopen(lindex(temp,1),"r");
     }
     if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
     if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
     if(*(lindex(temp,i)+1)=='%')              
     {
      sprintf(temp4,"%d",current_for);
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='2') { sleep(2); }
     if(*(lindex(temp,i)+1)=='3') { sleep(3); }
     if(*(lindex(temp,i)+1)=='4') { sleep(4); }
     if(*(lindex(temp,i)+1)=='g')
     {
      strcpy(subnumber,lindex(temp,(i+1)));
      if(fp!=NULL) fclose(fp);
      fp=fopen(filename,"r");
      while(fgets(temp,255,fp)!=NULL)
      { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
      goto_on = 1;
      break;
     }
     if(*(lindex(temp,i)+1)=='5') { sleep(5); }
     if(*(lindex(temp,i)+1)=='6') { sleep(6); }
     if(*(lindex(temp,i)+1)=='i')
     {
      i++;
      fpa=fopen(lindex(temp,i),"r");
      strcpy(temp2,"");
      for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
       fgets(temp2,255,fpa);
      strcat(buf,temp2);
      if(fpa!=NULL) fclose(fpa); 
      i++;
     }
     if(*(lindex(temp,i)+1)=='7') { sleep(7); }
     if(*(lindex(temp,i)+1)=='8') { sleep(8); }
     if(*(lindex(temp,i)+1)=='9') { sleep(9); }
     if(*(lindex(temp,i)+1)=='u')
     {
      strcat(buf,user);
     }
     if(*(lindex(temp,i)+1)=='e')
     {
      sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
      appendlog(temp4);         
      shutdown(sockfd,2);
      close(sockfd);
      if(cas_cmp(cron,"")) system(cron);
      press();
      exit(0);
     }
     if(*(lindex(temp,i)+1)=='b')
     {
      goto_on = 1;
      loop = 0;
     }
     if(*(lindex(temp,i)+1)=='s')
     {
      i++;
      strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
    }   
    else
    {
     strcat(buf,lindex(temp,i));
    }
    if(!reversechop) strcat(buf," ");
   }
   printf("%s\n",buf);
  }
  if(!cas_cmp(lindex(temp,0),"setreversechop"))
  {
   reversechop = 1;
  }
  if(!cas_cmp(lindex(temp,0),"write"))
  {
   bzero(buf,1024);
   strcpy(buf,""); 
   for(i=1;lindex(temp,i)!=NULL;i++)
   {
    if(reversechop) strcat(buf," ");
    if(*lindex(temp,i)=='$')
    {
     if(*(lindex(temp,i)+1)=='w')
     {
      i++;
      if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
      strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
     if(*(lindex(temp,i)+1)=='n')
     {
      strcat(buf,nick);
     }
     if(*(lindex(temp,i)+1)=='1') { sleep(1); }
     if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
     if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
     if(*(lindex(temp,i)+1)=='/')
     {
      i++;
      if(*(lindex(temp,i))=='0') strcat(buf,"\000");
      if(*(lindex(temp,i))=='1') strcat(buf,"\001");
      if(*(lindex(temp,i))=='2') strcat(buf,"\002");
      if(*(lindex(temp,i))=='3') strcat(buf,"\003");
      if(*(lindex(temp,i))=='4') strcat(buf,"\004");
      if(*(lindex(temp,i))=='5') strcat(buf,"\005");
      if(*(lindex(temp,i))=='6') strcat(buf,"\006");
      if(*(lindex(temp,i))=='7') strcat(buf,"\007");
      if(*(lindex(temp,i))=='8') strcat(buf,"\008");
      if(*(lindex(temp,i))=='9') strcat(buf,"\009");
     }
     if(*(lindex(temp,i)+1)=='p') 
     { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
     if(*(lindex(temp,i)+1)=='t')
     {
      lt=time(NULL);
      strcpy(temp4,ctime(&lt));
      temp4[strlen(temp4)-1]=' ';
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='r')
     {
      if(fp!=NULL) fclose(fp);
      fp=fopen(lindex(temp,1),"r");
     }
     if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
     if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
     if(*(lindex(temp,i)+1)=='%')              
     {
      sprintf(temp4,"%d",current_for);
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='2') { sleep(2); }
     if(*(lindex(temp,i)+1)=='3') { sleep(3); }
     if(*(lindex(temp,i)+1)=='4') { sleep(4); }
     if(*(lindex(temp,i)+1)=='g')
     {
      strcpy(subnumber,lindex(temp,(i+1)));
      if(fp!=NULL) fclose(fp);
      fp=fopen(filename,"r");
      while(fgets(temp,255,fp)!=NULL)
      { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
      goto_on = 1;
      break;
     }
     if(*(lindex(temp,i)+1)=='5') { sleep(5); }
     if(*(lindex(temp,i)+1)=='6') { sleep(6); }
     if(*(lindex(temp,i)+1)=='i')
     {    
      i++;
      fpa=fopen(lindex(temp,i),"r");
      strcpy(temp2,"");
      for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
       fgets(temp2,255,fpa);
      strcat(buf,temp2);
      if(fpa!=NULL) fclose(fpa); 
      i++;
     }
     if(*(lindex(temp,i)+1)=='7') { sleep(7); }
     if(*(lindex(temp,i)+1)=='8') { sleep(8); }
     if(*(lindex(temp,i)+1)=='9') { sleep(9); }
     if(*(lindex(temp,i)+1)=='u')
     {
      strcat(buf,user);
     }
     if(*(lindex(temp,i)+1)=='e')
     {
      sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
      appendlog(temp4);         
      shutdown(sockfd,2);
      close(sockfd);
      if(cas_cmp(cron,"")) system(cron);
      press();
      exit(0);
     }
     if(*(lindex(temp,i)+1)=='b')
     {
      goto_on = 1;
      loop = 0;
     }
     if(*(lindex(temp,i)+1)=='s')
     {
      i++;
      strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
    }   
    else
    {
     strcat(buf,lindex(temp,i));
    }
    if(!reversechop) strcat(buf," ");
   }
   if(!strictwrite) 
   {
    if(windows) strcat(buf,"\r\n");
    else strcat(buf,"\n");
   }
   else buf[strlen(buf)-1]='\n';
   if(goto_on) goto_on=0; else
   write(sockfd, buf, strlen(buf));
   if(debug) printf(">>> %s\n",buf);
  }
  if(!cas_cmp(lindex(temp,0),"remoteip"))
  {
   strcpy(in[atoi(lindex(temp,1))],remote_ip);
  }
  if(!cas_cmp(lindex(temp,0),"?match"))
  {
   if(lindex(in[atoi(lindex(temp,1))],0)!=NULL && lindex2(in[atoi(lindex(temp,2))],0)!=NULL)
   if(!match(lindex(in[atoi(lindex(temp,1))],0),lindex2(in[atoi(lindex(temp,2))],0)))
   {
    strcpy(subnumber,lindex(temp,(3)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
     { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
   }
  }
  if(!cas_cmp(lindex(temp,0),"?compare")) 
  {
   if(lindex(in[atoi(lindex(temp,1))],0)!=NULL && lindex2(in[atoi(lindex(temp,2))],0)!=NULL)
   if(!cas_cmp(lindex(in[atoi(lindex(temp,1))],0),lindex2(in[atoi(lindex(temp,2))],0)))
   {
    strcpy(subnumber,lindex(temp,(3)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
     { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
   }
  }
  if(!cas_cmp(lindex(temp,0),"if"))
  {
   if(!cas_cmp(lindex(temp,2),"="))
   if(atoi(in[atoi(lindex(temp,1))])==atoi(in[atoi(lindex(temp,3))]))
   {
    strcpy(subnumber,lindex(temp,(4)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
   }
   if(!cas_cmp(lindex(temp,2),"=="))
   if(atoi(in[atoi(lindex(temp,1))])==atoi(in[atoi(lindex(temp,3))]))
   {
    strcpy(subnumber,lindex(temp,(4)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
   }
   if(!cas_cmp(lindex(temp,2),">"))
   if(atoi(in[atoi(lindex(temp,1))])>atoi(in[atoi(lindex(temp,3))]))
   {
    strcpy(subnumber,lindex(temp,(4)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
   }
   if(!cas_cmp(lindex(temp,2),"<"))
   if(atoi(in[atoi(lindex(temp,1))])<atoi(in[atoi(lindex(temp,3))]))
   {
    strcpy(subnumber,lindex(temp,(4)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
   }
  }
  if(!cas_cmp(lindex(temp,0),"ifmatch"))
  {
   bzero(matching,1024);
   strcpy(matching,"");
   for(i=0;lindex(in[atoi(lindex(temp,1))],i)!=NULL;i++)
   {
    strcat(matching,lindex(in[atoi(lindex(temp,1))],i));
   }
   if(!match(lindex(temp,2),matching))
   {
    bzero(buf,1024);
    strcpy(buf,"");
    for(i=3;lindex(temp,i)!=NULL;i++)
    {
     if(reversechop) strcat(buf," ");
     if(*lindex(temp,i)=='$')
     {
      if(*(lindex(temp,i)+1)=='w')
      {
       i++;
       if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
       strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
       i++;
      }
      if(*(lindex(temp,i)+1)=='n')
      {
       strcat(buf,nick);
      }
      if(*(lindex(temp,i)+1)=='1') { sleep(1); }
      if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
      if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
      if(*(lindex(temp,i)+1)=='/')
      {
       i++;
       if(*(lindex(temp,i))=='0') strcat(buf,"\000");
       if(*(lindex(temp,i))=='1') strcat(buf,"\001");
       if(*(lindex(temp,i))=='2') strcat(buf,"\002");
       if(*(lindex(temp,i))=='3') strcat(buf,"\003");
       if(*(lindex(temp,i))=='4') strcat(buf,"\004");
       if(*(lindex(temp,i))=='5') strcat(buf,"\005");
       if(*(lindex(temp,i))=='6') strcat(buf,"\006");
       if(*(lindex(temp,i))=='7') strcat(buf,"\007");
       if(*(lindex(temp,i))=='8') strcat(buf,"\008");
       if(*(lindex(temp,i))=='9') strcat(buf,"\009");
      }
      if(*(lindex(temp,i)+1)=='p') 
      { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
      if(*(lindex(temp,i)+1)=='t')
      {
       lt=time(NULL);
       strcpy(temp4,ctime(&lt));
       temp4[strlen(temp4)-1]=' ';
       strcat(buf,temp4);
      }
      if(*(lindex(temp,i)+1)=='r')
      {
       if(fp!=NULL) fclose(fp);
       fp=fopen(lindex(temp,1),"r");
      }
      if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
      if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
      if(*(lindex(temp,i)+1)=='%')              
      {
       sprintf(temp4,"%d",current_for);
       strcat(buf,temp4);
      }
      if(*(lindex(temp,i)+1)=='g')
      {
       strcpy(subnumber,lindex(temp,(i+1)));
       if(fp!=NULL) fclose(fp);
       fp=fopen(filename,"r");
       while(fgets(temp,255,fp)!=NULL)
       { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
       goto_on = 1;
       break;
      }
      if(*(lindex(temp,i)+1)=='2') { sleep(2); }
      if(*(lindex(temp,i)+1)=='i')
      {    
       i++;
       fpa=fopen(lindex(temp,i),"r");
       strcpy(temp2,"");
       for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
        fgets(temp2,255,fpa);
       strcat(buf,temp2);
       if(fpa!=NULL) fclose(fpa); 
       i++;
      }
      if(*(lindex(temp,i)+1)=='3') { sleep(3); }
      if(*(lindex(temp,i)+1)=='4') { sleep(4); }
      if(*(lindex(temp,i)+1)=='5') { sleep(5); }
      if(*(lindex(temp,i)+1)=='6') { sleep(6); }
      if(*(lindex(temp,i)+1)=='7') { sleep(7); }
      if(*(lindex(temp,i)+1)=='e')
      {
       sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
       appendlog(temp4);         
       shutdown(sockfd,2);
       close(sockfd);
       if(cas_cmp(cron,"")) system(cron);
       press();
       exit(0);
      }
      if(*(lindex(temp,i)+1)=='8') { sleep(8); }
      if(*(lindex(temp,i)+1)=='9') { sleep(9); }
      if(*(lindex(temp,i)+1)=='u')
      {
       strcat(buf,user);
      }
      if(*(lindex(temp,i)+1)=='b')
      {
       goto_on = 1;
       loop = 0;
      }
      if(*(lindex(temp,i)+1)=='s')
      {
       i++;
       strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
       i++;
      }
     } 
     else
     { 
      strcat(buf,lindex(temp,i));
     }
     if(!reversechop) strcat(buf," ");
    }
    if(windows) strcat(buf,"\r\n");
    else strcat(buf,"\n");
    if(goto_on) goto_on=0; else
    write(sockfd, buf, strlen(buf));
    if(debug) printf(">>> %s\n",buf);
   }  
  }
  if(!cas_cmp(lindex(temp,0),"ifword")) 
  {
   if(!cas_cmp(lindex(temp,3),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,2)))))
   {
    bzero(buf,1024);
    strcpy(buf,"");
    for(i=4;lindex(temp,i)!=NULL;i++)
    {
     if(reversechop) strcat(buf," ");
     if(*lindex(temp,i)=='$')
     {
      if(*(lindex(temp,i)+1)=='w')
      {
       i++;
       if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
       strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
       i++;
      }
      if(*(lindex(temp,i)+1)=='n')
      {
       strcat(buf,nick);
      }
      if(*(lindex(temp,i)+1)=='1') { sleep(1); }
      if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
      if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
      if(*(lindex(temp,i)+1)=='/')
      {
       i++;
       if(*(lindex(temp,i))=='0') strcat(buf,"\000");
       if(*(lindex(temp,i))=='1') strcat(buf,"\001");
       if(*(lindex(temp,i))=='2') strcat(buf,"\002");
       if(*(lindex(temp,i))=='3') strcat(buf,"\003");
       if(*(lindex(temp,i))=='4') strcat(buf,"\004");
       if(*(lindex(temp,i))=='5') strcat(buf,"\005");
       if(*(lindex(temp,i))=='6') strcat(buf,"\006");
       if(*(lindex(temp,i))=='7') strcat(buf,"\007");
       if(*(lindex(temp,i))=='8') strcat(buf,"\008");
       if(*(lindex(temp,i))=='9') strcat(buf,"\009");
      }
      if(*(lindex(temp,i)+1)=='p') 
      { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
      if(*(lindex(temp,i)+1)=='t')
      {
       lt=time(NULL);
       strcpy(temp4,ctime(&lt));
       temp4[strlen(temp4)-1]=' ';
       strcat(buf,temp4);
      }
      if(*(lindex(temp,i)+1)=='r')
      {
       if(fp!=NULL) fclose(fp);
       fp=fopen(lindex(temp,1),"r");
      }
      if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
      if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
      if(*(lindex(temp,i)+1)=='%')              
      {
       sprintf(temp4,"%d",current_for);
       strcat(buf,temp4);
      }
      if(*(lindex(temp,i)+1)=='g')
      {
       strcpy(subnumber,lindex(temp,(i+1)));
       if(fp!=NULL) fclose(fp);
       fp=fopen(filename,"r");
       while(fgets(temp,255,fp)!=NULL)
       { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
       goto_on = 1;
       break;
      }
      if(*(lindex(temp,i)+1)=='i')
      {    
       i++;
       fpa=fopen(lindex(temp,i),"r");
       strcpy(temp2,"");
       for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
        fgets(temp2,255,fpa);
       strcat(buf,temp2);
       if(fpa!=NULL) fclose(fpa); 
       i++;
      }
      if(*(lindex(temp,i)+1)=='2') { sleep(2); }
      if(*(lindex(temp,i)+1)=='3') { sleep(3); }
      if(*(lindex(temp,i)+1)=='4') { sleep(4); }
      if(*(lindex(temp,i)+1)=='e')
      {
       sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
       appendlog(temp4);
       shutdown(sockfd,2);
       close(sockfd);
       if(cas_cmp(cron,"")) system(cron);
       press();
       exit(0);
      }
      if(*(lindex(temp,i)+1)=='5') { sleep(5); }
      if(*(lindex(temp,i)+1)=='6') { sleep(6); }
      if(*(lindex(temp,i)+1)=='7') { sleep(7); }
      if(*(lindex(temp,i)+1)=='8') { sleep(8); }
      if(*(lindex(temp,i)+1)=='9') { sleep(9); }
      if(*(lindex(temp,i)+1)=='u')
      {
       strcat(buf,user);
      }
      if(*(lindex(temp,i)+1)=='b')
      {
       goto_on = 1;
       loop = 0;
      }
      if(*(lindex(temp,i)+1)=='s')
      {
       i++;
       strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
       i++;
      }
     }
     else
     {
      strcat(buf,lindex(temp,i));
     }
     if(!reversechop) strcat(buf," ");
    }
    if(windows) strcat(buf,"\r\n");
    else strcat(buf,"\n");
    if(goto_on) goto_on=0; else
    write(sockfd, buf, strlen(buf));
    if(debug) printf(">>> %s\n",buf);
   }
  }
  if(!cas_cmp(lindex(temp,0),"ifword2"))
  {
   if(!cas_cmp(lindex(temp,3),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,2)))))
   {
    if(!cas_cmp(lindex(temp,5),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,4)))))
    {
     bzero(buf,1024);
     strcpy(buf,"");
     for(i=6;lindex(temp,i)!=NULL;i++)
     {
      if(reversechop) strcat(buf," ");
      if(*lindex(temp,i)=='$')
      {
       if(*(lindex(temp,i)+1)=='w')
       {
        i++;
        if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
        strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
        i++;
       }
       if(*(lindex(temp,i)+1)=='n')
       {
        strcat(buf,nick);
       }
       if(*(lindex(temp,i)+1)=='u')
       {
        strcat(buf,user);
       }
       if(*(lindex(temp,i)+1)=='1') { sleep(1); }
       if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
       if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
       if(*(lindex(temp,i)+1)=='/')
       {
        i++;
        if(*(lindex(temp,i))=='0') strcat(buf,"\000");
        if(*(lindex(temp,i))=='1') strcat(buf,"\001");
        if(*(lindex(temp,i))=='2') strcat(buf,"\002");
        if(*(lindex(temp,i))=='3') strcat(buf,"\003");
        if(*(lindex(temp,i))=='4') strcat(buf,"\004");
        if(*(lindex(temp,i))=='5') strcat(buf,"\005");
        if(*(lindex(temp,i))=='6') strcat(buf,"\006");
        if(*(lindex(temp,i))=='7') strcat(buf,"\007");
        if(*(lindex(temp,i))=='8') strcat(buf,"\008");
        if(*(lindex(temp,i))=='9') strcat(buf,"\009");
       }
       if(*(lindex(temp,i)+1)=='p') 
       { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
       if(*(lindex(temp,i)+1)=='t')
       {
        lt=time(NULL);
        strcpy(temp4,ctime(&lt));
        temp4[strlen(temp4)-1]=' ';
        strcat(buf,temp4);
       }
       if(*(lindex(temp,i)+1)=='r')
       {
        if(fp!=NULL) fclose(fp);
        fp=fopen(lindex(temp,1),"r");
       }
       if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
       if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
       if(*(lindex(temp,i)+1)=='%')              
       {
        sprintf(temp4,"%d",current_for);
        strcat(buf,temp4);
       }
       if(*(lindex(temp,i)+1)=='g')
       {
        strcpy(subnumber,lindex(temp,(i+1)));
        if(fp!=NULL) fclose(fp);
        fp=fopen(filename,"r");
        while(fgets(temp,255,fp)!=NULL)
        { if(!cas_cmp(lindex(temp,0),"sub") && !cas_cmp(lindex(temp,1),subnumber)) break; }
        goto_on = 1;
        break;
       }
       if(*(lindex(temp,i)+1)=='2') { sleep(2); }
       if(*(lindex(temp,i)+1)=='3') { sleep(3); }
       if(*(lindex(temp,i)+1)=='i')
       {    
        i++;
        fpa=fopen(lindex(temp,i),"r");
        strcpy(temp2,"");
        for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
         fgets(temp2,255,fpa);
        strcat(buf,temp2);
        if(fpa!=NULL) fclose(fpa); 
        i++;
       }
       if(*(lindex(temp,i)+1)=='4') { sleep(4); }
       if(*(lindex(temp,i)+1)=='5') { sleep(5); }
       if(*(lindex(temp,i)+1)=='6') { sleep(6); }
       if(*(lindex(temp,i)+1)=='7') { sleep(7); }
       if(*(lindex(temp,i)+1)=='e')
       {
        sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
        appendlog(temp4);         
        shutdown(sockfd,2);
        close(sockfd);
        if(cas_cmp(cron,"")) system(cron);
        press();
        exit(0);
       }
       if(*(lindex(temp,i)+1)=='8') { sleep(8); }
       if(*(lindex(temp,i)+1)=='9') { sleep(9); }
       if(*(lindex(temp,i)+1)=='b')
       {
        goto_on = 1;
        loop = 0;
       }
       if(*(lindex(temp,i)+1)=='s')
       {
        i++;
        strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
        i++;
       }
      }
      else
      {
       strcat(buf,lindex(temp,i)); 
      } 
      if(!reversechop) strcat(buf," ");
     }
     if(windows) strcat(buf,"\r\n");
     else strcat(buf,"\n");
     if(goto_on) goto_on=0; else
     write(sockfd, buf, strlen(buf));
     if(debug) printf(">>> %s\n",buf);
    }
   }   
  }
 }
 close(sockfd);
 if(cas_cmp(cron,"")) system(cron);
}

int cas_cmp(char *case1,char *case2)
{
        return (strcasecmp(case1,case2));
}

char *lindex2(char *input_string, int word_number)
{
 char *tokens[255];
 static char tmpstring[512];
 int i;
 strcpy(tmpstring,input_string);
 tokens[i=0] = (char *)strtok(tmpstring, " ");
 while ((tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 return (char *)tokens[word_number];
}

char *lrange(char *input_string, int starting_at)
{
 char *tokens[1024];
 static char tmpstring[1024]="";
 int i;
 char out_string[1024]="";
 strcpy(out_string,"");
 if(input_string==NULL) {
  strcpy(out_string," ");
  strcat(out_string,NULL);
  strcpy(global_var,out_string);
  return (char *)global_var; }
 strcpy(tmpstring,input_string);
 tokens[i=0] = strtok(tmpstring, " ");
 while((tokens[++i] = strtok(NULL, " ")));
 tokens[i] = NULL;
 i++;
 if(i<starting_at)
 {
#ifdef GUI
  XFlush(display);
  msgbox("error","Internal error. lrange() on string too short.",40);
#else
  fprintf(stderr,"*** Script error: lrange() error. Expected something longer than what I got.\n"); 
#endif
  if(cas_cmp(cron,"")) system(cron);
  press();
  exit(1);
 }
 while(tokens[starting_at] != NULL)
 {
  strcat(out_string,tokens[starting_at]);
  strcat(out_string, " ");
  starting_at++;
 }
 strcpy(global_var,out_string);
 return (char *)global_var;
}

int match(char *check,char *orig)
{ 
 while(*check == '*' || tolower(*check)==tolower(*orig) || *check == '?') 
  if(*check == '*')
  if(*++check)
  {
   while(*orig)
    if(!match(check,orig++)) return 0;
   return 1;
  }
  else return 0;
  else if (!*check) return 0;
  else if (!*orig) return 1;
  else 
  {
   ++check;
   ++orig;
  }
 return 1;
}

appendlog(char *what)
{
 FILE *fdlog;
 fdlog=fopen(logfilename,"a");
 fputs(what,fdlog);
 if(fdlog!=NULL) fclose(fdlog);
}

udp_send(char in[1024][1024])
{
 int udpsock,i;
 struct sockaddr_in udpaddr;
 char msg[255];
 strcpy(msg,lrange(in[atoi(lindex(temp,1))],2));
 udpsock = socket(AF_INET, SOCK_DGRAM, 0);
 if(udpsock<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
  return -1;
 }
 udpaddr.sin_family = AF_INET;
 udpaddr.sin_port = htons(atoi(lindex(in[atoi(lindex2(temp,1))],1)));
 udpaddr.sin_addr.s_addr = inet_addr(lindex(in[atoi(lindex2(temp,1))],0));
 if(sendto(udpsock,msg,sizeof(msg),0,(struct sockaddr *)&udpaddr,sizeof(udpaddr))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SEND FAILED: %s",strerror(errno));
  return -1;
 }
}

udp_listen(char in[1024][1024])
{
 int udpsock,len;
 struct sockaddr_in udpaddr, from;
 char msg[255];
 udpsock = socket(AF_INET, SOCK_DGRAM, 0);
 if(udpsock<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
  return -1;
 }
 udpaddr.sin_family = AF_INET;
 udpaddr.sin_addr.s_addr = INADDR_ANY;
 udpaddr.sin_port = htons(atoi(lindex(temp,2)));
 if(bind(udpsock,(struct sockaddr *)&udpaddr,sizeof(udpaddr))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"BIND FAILED: %s",strerror(errno));
  return -1;
 }
 len = sizeof(from);
 if(recvfrom(udpsock,msg,sizeof(msg),0,(struct sockaddr *)&from,&len)<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"RECEIVE FAILED: %s",strerror(errno));
  return -1;
 }
 strcpy(in[atoi(lindex(temp,1))],msg);
 close(udpsock);
}

addtrace()
{
 FILE *fptrace;
 fptrace=fopen("trace.log","a");
 fputs(temp,fptrace);
 fputs("\n",fptrace);
 if(fptrace!=NULL) fclose(fptrace);
}

icmp_detect(char in[1024][1024])
{
 /* Should be a better function than this, but this'll have to do for
    now since icmpinfo only seg faults if I try to add it. */
 char readbuf[4096];
 int icmpsock,from,result,type,len;
 struct sockaddr_in icmpaddr;
 strcpy(in[atoi(lindex(temp,1))],"");
 if((icmpsock=socket(AF_INET, SOCK_RAW, IPPROTO_ICMP))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
  return -1;
 }
 icmpaddr.sin_family = AF_INET;
 icmpaddr.sin_addr.s_addr = INADDR_ANY;
 icmpaddr.sin_port = 0;
 if(bind(icmpsock,(struct sockaddr *)&icmpaddr,sizeof(icmpaddr))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"BIND FAILED: %s",strerror(errno));
  return -1;
 }
 len=sizeof(icmpaddr);
 if(getsockname(icmpsock,(struct sockaddr *)&icmpaddr,&len)<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SOCKET ADDRESS: %s",strerror(errno));
  return -1;
 }
 if((result=read(icmpsock,readbuf,sizeof(readbuf)))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"READING FAILED: %s",strerror(errno));
  return -1;
 }
 type=readbuf[20] & 0xff;
 sprintf(in[atoi(lindex(temp,1))],"%ld %d %d.%d.%d.%d ;",time(NULL),type,readbuf[12]&0xff,readbuf[13]&0xff,readbuf[14]&0xff,readbuf[15]&0xff);
}

resolve(char in[1024][1024])
{
 struct hostent *hp;
 struct sockaddr_in from;
 unsigned long dest;
 if(!cas_cmp(lindex(temp,1),"host"))
 {
  /* argh!! no wonder people need stuff like sscript */
  memset(&from, 0, sizeof(struct sockaddr_in));
  from.sin_family = AF_INET;
  hp=gethostbyname(lindex(in[atoi(lindex2(temp,2))],0));
  if(hp==NULL) strcpy(in[atoi(lindex(temp,3))],"unknown");
  else
  {
   memcpy(&from.sin_addr,hp->h_addr,hp->h_length);
   strcpy(in[atoi(lindex(temp,3))],inet_ntoa(from.sin_addr));
  }
 }
 else if(!cas_cmp(lindex(temp,1),"ip"))
 {
  from.sin_family = AF_INET;
  from.sin_addr.s_addr = inet_addr(lindex(in[atoi(lindex2(temp,2))],0));
  hp=gethostbyaddr((char *)&from.sin_addr, sizeof(struct in_addr),from.sin_family);
  if(hp==NULL) strcpy(in[atoi(lindex(temp,3))],"unknown");
  else strcpy(in[atoi(lindex(temp,3))],(char *)hp->h_name);;
 }
 else
 {
  strcpy(in[atoi(lindex(temp,3))],"Unknown request type.");
 }
}

#ifdef GUI
int msgbox(char *type, char *textstring, int len)
{/* based on xmsg by Willy Tarreau, under GPL */
 Arg args[20];
 char blah[255];
 register int nargs, nwidgets;  
 int width;
 XtCallbackRec button1[2];
 if (displayed) return;
 displayed=1;
 if(lang==0)
 {
  if(!cas_cmp(type,"header")) strcpy(blah,"Starting...");
  else if(!cas_cmp(type,"info")) strcpy(blah,"Information:");
  else if(!cas_cmp(type,"error")) strcpy(blah,"ERROR:");
 }
 else if(lang==1)
 {
  if(!cas_cmp(type,"header")) strcpy(blah,"Demarrer...");
  else if(!cas_cmp(type,"info")) strcpy(blah,"Information:");
  else if(!cas_cmp(type,"error")) strcpy(blah,"ERREUR:");
 }
 else if(lang==2)
 {   
  if(!cas_cmp(type,"header")) strcpy(blah,"Iniciando...");
  else if(!cas_cmp(type,"info")) strcpy(blah,"Informacion:");
  else if(!cas_cmp(type,"error")) strcpy(blah,"ERROR:");
 }
 bzero(button1, sizeof(button1));
 button1[0].callback = closebox;
 button1[0].closure = (caddr_t) 0;
 nargs = 0;
 SetArg(XtNx, 10);
 SetArg(XtNy, 10);
 SetArg(XtNtitle, "Socket Script");
 SetArg(XtNmaxHeight, 130);
 SetArg(XtNminHeight, 120);
 SetArg(XtNmaxWidth, (len+25)*8);
 SetArg(XtNminWidth, (len+20)*8);
 msgwidget=XtCreateWidget("window", applicationShellWidgetClass, toplevel, args, nargs);
 nargs = 0;
 form = XtCreateWidget("box", boxWidgetClass, msgwidget, args, nargs);
 XtManageChild(form);
 nargs = 0;
 SetArg(XtNlabel,blah);
 SetArg("borderWidth", 0);
 SetArg(XtNjustify,XtJustifyCenter);
 SetArg(XtNwidth,(len+20)*8);
 SetArg(XtNheight,15);
 XtManageChild(last=XtCreateWidget("label", labelWidgetClass, form, args, nargs));
 nargs = 0;
 SetArg(XtNlabel, textstring);
 SetArg(XtNborderWidth, 1);
 SetArg(XtNjustify,XtJustifyCenter);
 SetArg(XtNfromVert,last);   
 SetArg(XtNwidth,(len+20)*8);
 SetArg(XtNheight,60);
 XtManageChild(textbox=XtCreateWidget("textbox", labelWidgetClass, form, args, nargs));
 nwidgets = 0;
 nargs = 0;
 SetArg(XtNcallback, button1);
 SetArg(XtNfromVert, textbox);
 SetArg(XtNhighlightThickness, -1);
 SetArg(XtNwidth, (len+20)*8);
 widgets[nwidgets++] = XtCreateWidget("OK", commandWidgetClass, form, args, nargs);
 XtManageChild(form);
 XtManageChildren(widgets, nwidgets);
 XtRealizeWidget(msgwidget);
 XtPopup(msgwidget, XtGrabExclusive);
 while(displayed) {
  XtAppNextEvent(ac2, &event);   
  XtDispatchEvent(&event);
 }
 XFlush(display);
}

int queryOk(Widget result, XtPointer p1, XtPointer p2)
{
 strcpy(queryGlVar,XawDialogGetValueString(dialog1));
 XtDestroyWidget(mainbox);
 XtUnrealizeWidget(top);
 XtDestroyApplicationContext(ac);
 displayed = 0;
}

int ContinueIt(Widget result, XtPointer p1, XtPointer p2)
{
 XtDestroyWidget(mainbox);
 XtUnrealizeWidget(top);
 XtDestroyApplicationContext(ac);
 displayed = 0;
}

int queryQuit(Widget result, XtPointer p1, XtPointer p2)
{
 XtDestroyWidget(mainbox);
 press();
 exit(0);
}

int query(char *string, int argc1, char *argv1[])
{
 if(displayed) return 0;
 displayed = 1;
 top = XtVaAppInitialize(&ac, "SScript", NULL, 0, &argc1, argv1, sscript_resources, XtNtitle, "Socket Script", NULL);
 mainbox = XtVaCreateManagedWidget("mainbox", boxWidgetClass, top, NULL);
 dialog1 = XtVaCreateManagedWidget("dialog1", dialogWidgetClass, mainbox, XtNlabel, string, XtNvalue, "", NULL);
 okbutton = XtVaCreateManagedWidget("OK", commandWidgetClass, dialog1, NULL);
 if(lang==0)
 quitbutton = XtVaCreateManagedWidget("Quit", commandWidgetClass, dialog1, NULL);
 else if(lang==1)
 quitbutton = XtVaCreateManagedWidget("Quitter", commandWidgetClass, dialog1, NULL);
 else if(lang==2)
 quitbutton = XtVaCreateManagedWidget("Salida", commandWidgetClass, dialog1, NULL);
 XtAddCallback(okbutton, XtNcallback, (XtPointer)queryOk, NULL);
 XtAddCallback(quitbutton, XtNcallback, (XtPointer)queryQuit, NULL);
 XtRealizeWidget(top);
 while(displayed) {
  XtAppNextEvent(ac, &qevent);
  XtDispatchEvent(&qevent); 
 }
}

int viewfile(char *file, int argc1, char *argv1[])
{
 FILE *fd;
 char *file_buf;
 off_t len;
 struct stat stat_buf;
 if(displayed) return 0;
 displayed = 1;
 top = XtVaAppInitialize(&ac, "SScript", NULL, 0, &argc1, argv1, sscript_resources, XtNtitle, "Socket Script", NULL);
 mainbox = XtVaCreateManagedWidget("mainbox", boxWidgetClass, top, NULL);
 continuebutton = XtVaCreateManagedWidget("Continue",commandWidgetClass,mainbox,NULL);
 viewbox = XtVaCreateManagedWidget("viewbox", asciiTextWidgetClass, mainbox, XtNheight, 300, XtNwidth, 500, XtNscrollVertical, XawtextScrollWhenNeeded, XtNscrollHorizontal, XawtextScrollWhenNeeded, NULL);
 XtAddCallback(continuebutton, XtNcallback, (XtPointer)ContinueIt, NULL);
 if((fd=fopen(file,"ro"))==NULL)
 {
  if(lang==0)
  XtVaSetValues(viewbox, XtNstring, "\nCan't open that file\n\n", NULL);
  else if(lang==1)
  XtVaSetValues(viewbox, XtNstring, "\nNe peut ouvrir ce fichier\n\n", NULL);
  else if(lang==2)
  XtVaSetValues(viewbox, XtNstring, "\nNo se puede abrir el archivo\n\n", NULL);
 }
 else
 {
  fstat(fileno(fd), &stat_buf);
  len = stat_buf.st_size;
  file_buf = malloc(len * sizeof(char) +1);
  fread(file_buf, 1, len, fd);
  file_buf[len] = '\0';
  XtVaSetValues(viewbox, XtNstring, file_buf, NULL);
  free(file_buf);
  fclose(fd);
 }
 XtRealizeWidget(top);
 while(displayed) {
  XtAppNextEvent(ac, &qevent);
  XtDispatchEvent(&qevent);
 }
}

int view_n_query(char *file, char *string, int argc1, char *argv1[])
{
 FILE *fd;
 char *file_buf;
 off_t len;
 struct stat stat_buf;
 if(displayed) return 0;
 displayed = 1;
 top = XtVaAppInitialize(&ac, "SScript", NULL, 0, &argc1, argv1, sscript_resources, XtNtitle, "Socket Script", NULL);
 mainbox = XtVaCreateManagedWidget("mainbox", boxWidgetClass, top, NULL);
 dialog1 = XtVaCreateManagedWidget("dialog1", dialogWidgetClass, mainbox, XtNlabel, string, XtNvalue, "", NULL);
 continuebutton = XtVaCreateManagedWidget("Continue",commandWidgetClass,mainbox,NULL);
 viewbox = XtVaCreateManagedWidget("viewbox", asciiTextWidgetClass, mainbox, XtNheight, 300, XtNwidth, 500, XtNscrollVertical, XawtextScrollWhenNeeded, XtNscrollHorizontal, XawtextScrollWhenNeeded, NULL);
 XtAddCallback(continuebutton, XtNcallback, (XtPointer)queryOk, NULL);
 if((fd=fopen(file,"ro"))==NULL)
  XtVaSetValues(viewbox, XtNstring, "\nCan't open that file\n\n", NULL);
 else
 {
  fstat(fileno(fd), &stat_buf);
  len = stat_buf.st_size;
  file_buf = malloc(len * sizeof(char) +1);
  fread(file_buf, 1, len, fd);
  file_buf[len] = '\0';
  XtVaSetValues(viewbox, XtNstring, file_buf, NULL);
  free(file_buf);
  fclose(fd);
 }
 XtRealizeWidget(top);
 while(displayed) {
  XtAppNextEvent(ac, &qevent);
  XtDispatchEvent(&qevent);
 }
}
#endif

int help(int type, int argc, char *argv[])
{
 char help_string[4048];
 if(lang==0)
 strcpy(help_string,"This is the online help screen for Socket Script.\n");
 else if(lang==1)
 strcpy(help_string,"Ceci est l'aide en ligne de Socket Script. Une traduction n'est pas disponible pour l'instant.\n");
 else if(lang==2)
 strcpy(help_string,"Este es la ayuda en line para Socket Script. Una traduccion para el sistema de ayuda todavia no es disponible.\n");
 if(argv[2]==NULL)
 {
  strcat(help_string,"Syntax:\n");
  strcat(help_string,"        sscript [-d] [-c] [-r <remote ip> <port>] [script or project file] [-help [command]] [-display <screen>]\n");
  strcat(help_string,"\nsscript with no command line argument loads the default sscript.file\n");
  strcat(help_string,"sscript <script file or project file> loads the specified script or project\n");
  strcat(help_string,"sscript -help [command] gets you online help on the specified command. Use sscript -help index  for a list of all commands.\n");
  strcat(help_string,"sscript -d <script> will launch the debugger to check the specified script for possible errors.\n");
  strcat(help_string,"sscript -c <script> will launch the composer which allows you to make your scripts.\n");
  strcat(help_string,"sscript -r <server ip> <server port> <script> will fetch <script> from a remote server running the ERSS script (examples/sscript.script-serving)  \n\n");
  strcat(help_string,"The full documentation is also available in sscript.doc along with technical notes on how to make your scripts.\n");
  strcat(help_string,"You can also look at the examples in the /examples dir that came with this package.\n\n");
  strcat(help_string,"Socket Script is free software.\n(C) 1998 Patrick Lambert <drow@fastethernet.net>\nLatest version available at http://devplanet.fastethernet.net/sscript.html\nor ftp://sunsite.unc.edu/pub/Linux/devel/");
 }
 else if(!cas_cmp(argv[2],"index"))
 {
  strcat(help_string,"Index of available commands as of now:\n");
  strcat(help_string,"server, port, chop, debug, virtual, require, read, write, print, save, append, rementry, remove, version, ping, test,\n");
  strcat(help_string,"parse, dump, set, setmaster, setuserhost, setservice, setreversechop, setstrictcheck, setstrictwrite, setlogfile, settrace,\n");
  strcat(help_string,"setwindows, setsignalsoff, rconnect, rread, rwrite, rdisconnect, for, endfor, ask, exit, ifword, ifword2, ifmaster,\n");
  strcat(help_string,"ifmaster2, ifmatch, ?compare, ?match, loop, saveall, addlog, run, goto, sub, wait, if, cron, remoteip, random,\n");
  strcat(help_string,"command, resolve, cl, udpsend, udplisten,  icmplisten, raw, rawp, msgbox, query, viewfile, devstat, setowner,\n");
  strcat(help_string,"background, require-gui, getenv, file, include, choicebox, setremoteecho\n");
 }
 else if(!cas_cmp(argv[2],"setremoteecho"))
 {
  strcat(help_string,"setremoteecho ;\n");
  strcat(help_string,"Make a server-oriented script return everything it reads from to the\n");
  strcat(help_string,"remote host.\n");
 }
 else if(!cas_cmp(argv[2],"choicebox"))
 {
  strcat(help_string,"choicebox <variable number> <button 1> <button 2> ... | <label>\n");
  strcat(help_string,"The choicebox command will popup a window to the user and ask him the   \n");
  strcat(help_string,"question <label>, with buttons for him to choose an answer. There can be\n");
  strcat(help_string,"up to 10 buttons, where <button 1>, <button 2>, etc are the button's    \n");
  strcat(help_string,"labels. The command will return the button chosen (1, 2, 3... 10) in\n");
  strcat(help_string,"<variable number>.\n");
 }
 else if(!cas_cmp(argv[2],"server"))
 {
  strcat(help_string,"server <ip> ;\n");
  strcat(help_string,"Tells the program what IP to connect to. Enter 0 there if you want to\n");
  strcat(help_string,"use SScript as a server, or \"no-connection\" (without the quotes) for\n");
  strcat(help_string,"a connection-less script. See sscript.server for more.\n");
 }
 else if(!cas_cmp(argv[2],"include"))
 {
  strcat(help_string,"include <name> <cl binary> ;\n");
  strcat(help_string,"This launch <cl binary> whenever SScript sees 'cl <name> ...' in the    \n");
  strcat(help_string,"script. See plugins.txt for details.\n");
 }
 else if(!cas_cmp(argv[2],"require-gui"))
 {
  strcat(help_string,"require-gui ;\n");
  strcat(help_string,"This means that SScript must be compiled as a GUI app for this script to work.\n");
 }
 else if(!cas_cmp(argv[2],"port"))
 {
  strcat(help_string,"port <port> ;\n");
  strcat(help_string,"Tells the program what port to connect to.\n");
 }
 else if(!cas_cmp(argv[2],"debug"))
 {
  strcat(help_string,"debug <mode> ;\n");
  strcat(help_string,"If mode is 1, the program will output everything it reads to the\n");
  strcat(help_string,"screen. Default use should be mode 0.\n");
 }
 else if(!cas_cmp(argv[2],"chop"))
 {
  strcat(help_string,"chop <mode> ;\n");
  strcat(help_string,"Tells the program to chop the last char of a\n");
  strcat(help_string,"string. You choose this\n");
  strcat(help_string,"option depending on what kind of server you need to connect to. Use\n");
  strcat(help_string,"mode 1 for IRC servers, and mode 0 for WEB server and most others.  \n");
 }
 else if(!cas_cmp(argv[2],"virtual"))
 {
  strcat(help_string,"virtual <ip> ;\n");
  strcat(help_string,"Binds to a virtual IP if available. If not, simply put 0.\n");
 }
 else if(!cas_cmp(argv[2],"getenv"))
 {
  strcat(help_string,"getenv <word> <variable number> ;\n");
  strcat(help_string,"Put the environment value corresponding to <word> in <variable number>.\n");
 }
 else if(!cas_cmp(argv[2],"require"))
 {
  strcat(help_string,"require <version> ;\n");
  strcat(help_string,"Requires a Socket Script interpreter <version> or more. Version is a 2\n");
  strcat(help_string,"number word, ie. 16 for version 1.6.\n");
 }
 else if(!cas_cmp(argv[2],"read"))
 {
  strcat(help_string,"read <variable number> ;\n");
  strcat(help_string,"Reads a line of text. Variable number is the variable to save the   \n");
  strcat(help_string,"line to. You have from 1 to 1000. You can always use the same, or use\n");
  strcat(help_string,"different ones if you need to save something for later use. \n");
 }
 else if(!cas_cmp(argv[2],"write"))
 {
  strcat(help_string,"write <string>\n");
  strcat(help_string,"Sends <string> to the remote server. \n");
 }
 else if(!cas_cmp(argv[2],"print"))
 {
  strcat(help_string,"print <string>\n");
  strcat(help_string,"Prints <string> on the screen. \n");
 }
 else if(!cas_cmp(argv[2],"save"))
 {
  strcat(help_string,"save <variable number> <file> ;  \n");
  strcat(help_string,"Saves the line of text in <variable number> to <file>. It overwrites\n");
  strcat(help_string,"what's in the file.\n");
 }
 else if(!cas_cmp(argv[2],"append"))
 {
  strcat(help_string,"append <variable number> <file> ;\n");
  strcat(help_string,"Saves the line of text in <variable number> to <file>. It does not\n");
  strcat(help_string,"overwrites the file. \n");
 }
 else if(!cas_cmp(argv[2],"rementry"))
 {
  strcat(help_string,"rementry <variable number> <file> ;\n");
  strcat(help_string,"Remove the lines matching the 1st word in <variable number> from\n");
  strcat(help_string,"<file>. \n");
 }
 else if(!cas_cmp(argv[2],"remove"))
 {
  strcat(help_string,"remove <vairable number> <file> ;\n");
  strcat(help_string,"Remove the lines matching the string in <variable number> from\n");
  strcat(help_string,"<file>. \n");
 }
 else if(!cas_cmp(argv[2],"version"))
 {
  strcat(help_string,"version ;\n");
  strcat(help_string,"Prints the version information. \n");
 }
 else if(!cas_cmp(argv[2],"ping"))
 {
  strcat(help_string,"ping <remote ip> ;\n");
  strcat(help_string,"Used to check if the remote IP is alive. Will not return if it's\n");
  strcat(help_string,"not (of if port 7 is filtered).  \n");
 }
 else if(!cas_cmp(argv[2],"test"))
 {
  strcat(help_string,"test <variable number> ;\n");
  strcat(help_string,"Tests to see if a remote port is listening. <variable number> must\n");
  strcat(help_string,"contain \"<remote ip> <remote port> ;\" (without the quotes). This\n");
  strcat(help_string,"returns 0 if the port is listening, or an error if not, in that variable number.  \n");
 }
 else if(!cas_cmp(argv[2],"parse"))
 {
  strcat(help_string,"parse [<,<<,>>,>,!,_>,<_] <variable number> <char> ;\n");
  strcat(help_string,"This will remove everything in the first word of <variable\n");
  strcat(help_string,"number> before (<<), before and including (<), after (>>), or\n");
  strcat(help_string,"after and including (>) the <char> if it exist. (!) is use to remove\n");
  strcat(help_string,"every space in the string. So \"this is a string\" will become\n");
  strcat(help_string,"\"thisisastring\". Can be useful for matching commands. The <_ command \n");
  strcat(help_string,"puts a space *before* every <char> in the string, and the _> command\n");
  strcat(help_string,"puts a space *after* every <char>.\n");
 }
 else if(!cas_cmp(argv[2],"dump"))
 {
  strcat(help_string,"dump <variable number> ;\n");
  strcat(help_string,"Writes everything from the file in <variable number>.  \n");
 }
 else if(!cas_cmp(argv[2],"set"))
 {
  strcat(help_string,"set <variable number> <string>\n");
  strcat(help_string,"Enter <string> in <variable number> for future retreval.  \n");
 }
 else if(!cas_cmp(argv[2],"setmaster"))
 {
  strcat(help_string,"setmaster <file containing: <masked nick!user@host> ;> ;  \n");
  strcat(help_string,"Used mainly for IRC bots. Defines who will have access to the\n");
  strcat(help_string,"ifmaster and ifmaster2 functions.  \n");
 }
 else if(!cas_cmp(argv[2],"setuserhost"))
 {
  strcat(help_string,"setuserhost ;\n");
  strcat(help_string,"From that point the program will try to get a nick!user@host from\n");
  strcat(help_string,"what it gets from the server. Useful for IRC bots.  \n");
 }
 else if(!cas_cmp(argv[2],"setservice"))
 {
  strcat(help_string,"setservice ;\n");
  strcat(help_string,"Sets the sscript to be a service server for IRC.\n");
 }
 else if(!cas_cmp(argv[2],"setreversechop"))
 {
  strcat(help_string,"setreversechop ;\n");
  strcat(help_string,"Puts a ' ' before a word rather than after a word\n");
  strcat(help_string,"when parsing a command line.  \n");
 }
 else if(!cas_cmp(argv[2],"setstrictcheck"))
 {
  strcat(help_string,"setstrictcheck ;\n");
  strcat(help_string,"Strict check for empty strings which might get the script to SEG FAULT.  \n");
 }
 else if(!cas_cmp(argv[2],"setstrictwrite"))
 {
  strcat(help_string,"setstrictwrite ;\n");
  strcat(help_string,"Don't append a space at the end of a 'write' command. Useful for web\n");
  strcat(help_string,"servers mainly.  \n");
 }
 else if(!cas_cmp(argv[2],"setlogfile"))
 {
  strcat(help_string,"setlogfile <filename> ;\n");
  strcat(help_string,"Changes the LOGFILE name.  \n");
 }
 else if(!cas_cmp(argv[2],"settrace"))
 {
  strcat(help_string,"settrace ;\n");
  strcat(help_string,"Traces every command in trace.log for debugging purposes. Can get pretty large.  \n");
 }
 else if(!cas_cmp(argv[2],"setwindows"))
 {
  strcat(help_string,"setwindows ;\n");
  strcat(help_string,"Set Windows compatibility. Unfortunatly Windows's telnet doesn't follow\n");
  strcat(help_string,"normal rules and needs SScript to tell it there's a return sign AND a\n");
  strcat(help_string,"new line for it to parse text properly. Turn this on if you want to make\n");
  strcat(help_string,"Windows-compatible server-oriented scripts. This is not compatible with\n");
  strcat(help_string,"setstrictwrite.  \n");
 }
 else if(!cas_cmp(argv[2],"setsignalsoff"))
 {
  strcat(help_string,"setsignalsoff ;\n");
  strcat(help_string,"This function sets the signal handeling off, so SScript won't say\n");
  strcat(help_string,"anything if dies from errors like Seg fault or Broken pipe. Useful for \n");
  strcat(help_string,"server-oriented scripts.  \n");
 }
 else if(!cas_cmp(argv[2],"rconnect"))
 {
  strcat(help_string,"rconnect <variable number> ;\n");
  strcat(help_string,"Makes an other connection. <variable number> must contain\n");
  strcat(help_string,"\"<remote ip> <remote port> <protocol number> <type> ;\" (without the  \n");
  strcat(help_string,"quotes). You can then read and write with rread and rwrite. Returns an  \n");
  strcat(help_string,"error in <variable number> if the connect failed. <protocol number> is 0\n");
  strcat(help_string,"for IP and <type> is 1 for TCP.  \n");
 }
 else if(!cas_cmp(argv[2],"rread"))
 {
  strcat(help_string,"rread <variable number> ;\n");
  strcat(help_string,"Reads from the second connection and puts the result in\n");
  strcat(help_string,"<variable number>.  \n");
 }
 else if(!cas_cmp(argv[2],"rwrite"))
 {
  strcat(help_string,"rwrite <variable number> ;\n");
  strcat(help_string,"Writes what's in <variable number> to the second connection.  \n");
 }
 else if(!cas_cmp(argv[2],"rdisconnect"))
 {
  strcat(help_string,"rdisconnect ;\n");
  strcat(help_string,"Disconnects the other remote connection.  \n");
 }
 else if(!cas_cmp(argv[2],"for"))
 {
  strcat(help_string,"for <for number> <start number> to <end number> ;\n");
  strcat(help_string,"This is a loop which begins at <start number> and ends at <end\n");
  strcat(help_string,"number>. The current number where the loop is currently in can be\n");
  strcat(help_string,"accessed with $%. You can set <end number> to -1 to get an infinite\n");
  strcat(help_string,"loop.  \n");
 }
 else if(!cas_cmp(argv[2],"endfor"))
 {
  strcat(help_string,"endfor <for number> ;\n");
  strcat(help_string,"Goes back to the 'for' corresponding to <for number> untill <end\n");
  strcat(help_string,"number> is reached.  \n");
 }
 else if(!cas_cmp(argv[2],"ask"))
 {
  strcat(help_string,"ask <variable number> ;\n");
  strcat(help_string,"Waits for input from the user.  \n");
 }
 else if(!cas_cmp(argv[2],"exit"))
 {
  strcat(help_string,"exit ;\n");
  strcat(help_string,"Makes the program quit.  \n");
 }
 else if(!cas_cmp(argv[2],"ifword"))
 {
  strcat(help_string,"ifword <variable number> <word number> <word> <string>\n");
  strcat(help_string,"This function compares 2 words. It matches <word> with the word in\n");
  strcat(help_string,"<variable number> at position <word number> and if it does match, it\n");
  strcat(help_string,"sends <string> to the server.  \n");
 }
 else if(!cas_cmp(argv[2],"ifword2"))
 {
  strcat(help_string,"ifword2 <variable number> <word number> <word> <word number 2> <word 2> <string>\n");
  strcat(help_string,"This is like ifword, but tries to match 2 different sets of words.  \n");
 }
 else if(!cas_cmp(argv[2],"ifmaster"))
 {
  strcat(help_string,"ifmaster <variable number> <word number> <word> <string>\n");
  strcat(help_string,"This is like ifword, but the sender must also be the nick!user@host\n");
  strcat(help_string,"sets by setmaster. Used in IRC bots.  \n");
 }
 else if(!cas_cmp(argv[2],"ifmaster2"))
 {
  strcat(help_string,"ifmaster2 <variable number> <word number> <word> <word number 2> <word 2> <sting>\n");
  strcat(help_string,"This is like ifword2, but the sender must also be the nick!user@host\n");
  strcat(help_string,"sets by setmaster. Used in IRC bots.  \n");
 }
 else if(!cas_cmp(argv[2],"ifmatch"))
 {
  strcat(help_string,"ifmatch <variable number> <masked word> <string>\n");
  strcat(help_string,"If there is a match for <masked word> in <variable number>, then\n");
  strcat(help_string,"writes <string>.  \n");
 }
 else if(!cas_cmp(argv[2],"?compare"))
 {
  strcat(help_string,"?compare <variable number 1> <variable number 2> <sub name> ;\n");
  strcat(help_string,"If the first word of <variable number 1> is the same as <variable number\n");
  strcat(help_string,"2> then go to <sub name>.  \n");
 }
 else if(!cas_cmp(argv[2],"?match"))
 {
  strcat(help_string,"?match <variable number 1> <variable number 2> <sub name> ;\n");
  strcat(help_string,"If the masked word in <variable number 1> match the one in <variable\n");
  strcat(help_string,"number 2> then go to <sub name>.  \n");
 }
 else if(!cas_cmp(argv[2],"loop"))
 {
  strcat(help_string,"loop start <loop number> ;\n");
  strcat(help_string,"This is used to start a loop.\n\n");
  strcat(help_string,"loop end <loop number> ;\n");
  strcat(help_string,"This is the end of the loop. When the program reaches this line, it\n");
  strcat(help_string,"goes back to the right loop start ; line and loops indefinitly.\n");
 }
 else if(!cas_cmp(argv[2],"saveall"))
 {
  strcat(help_string,"saveall <file> ;\n");
  strcat(help_string,"Reads all there is to read from the server and saves it in <file>.  \n");
 }
 else if(!cas_cmp(argv[2],"addlog"))
 {
  strcat(help_string,"addlog <variable number> ;\n");
  strcat(help_string,"Add to SScript's log file what's in <variable number>.  \n");
 }
 else if(!cas_cmp(argv[2],"run"))
 {
  strcat(help_string,"run <variable number>\n");
  strcat(help_string,"Executes a shell command contained in <variable number>.  \n");
 }
 else if(!cas_cmp(argv[2],"goto"))
 {
  strcat(help_string,"goto <function name> ;\n");
  strcat(help_string,"Go to a function. You need to define a function with the sub command.  \n");
 }
 else if(!cas_cmp(argv[2],"sub"))
 {
  strcat(help_string,"sub <function name> ;\n");
  strcat(help_string,"Declares a function to be called with goto to $goto. \n");
 }
 else if(!cas_cmp(argv[2],"wait"))
 {
  strcat(help_string,"wait ;\n");
  strcat(help_string,"Makes the bot wait 1 sec. Useful for debugging purposes or if you\n");
  strcat(help_string,"want to see what the program is reading. \n");
 }
 else if(!cas_cmp(argv[2],"if"))
 {
  strcat(help_string,"if <variable number 1> [<,>,=] <variable number 2>\n");
  strcat(help_string,"<sub name> ;\n");
  strcat(help_string,"Check if the number in <variable number 1> is '>', '<' or '=' than the\n");
  strcat(help_string,"one in <variable number 2>. If it is, goto <sub name>. \n");
 }
 else if(!cas_cmp(argv[2],"cron"))
 {
  strcat(help_string,"cron <command line>\n");
  strcat(help_string,"SScript will run that command line every time just before it exits. Can\n");
  strcat(help_string,"be useful to restart itself when it gets a segfault or some other\n");
  strcat(help_string,"error. Note that this can be a dangerous command if not used wisely. If\n");
  strcat(help_string,"you run into a loop it can hang resources down. Be very carefull when\n");
  strcat(help_string,"using it. Also the <command line> should end with a '&' if you want\n");
  strcat(help_string,"sscript to sucessfully quit. \n");
 }
 else if(!cas_cmp(argv[2],"file"))
 {
  strcat(help_string,"file exist <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Checks if the file in <variable number 1> exists, and if it does, puts  \n");
  strcat(help_string,"'0' in <variable number 2>.\n");
 }
 else if(!cas_cmp(argv[2],"remoteip"))
 {
  strcat(help_string,"remoteip <variable number> ;\n");
  strcat(help_string,"For server-oriented scripts, set the remote IP number in <variable\n");
  strcat(help_string,"number>. \n");
 }
 else if(!cas_cmp(argv[2],"random"))
 {
  strcat(help_string,"random <variable number> <max number> ;\n");
  strcat(help_string,"This will output a random number from 0 to <max number> in <variable \n");
  strcat(help_string,"number>. \n");
 }
 else if(!cas_cmp(argv[2],"command"))
 {
  strcat(help_string,"command <variable number> ;\n");
  strcat(help_string,"This will make SScript execute a command line in <variable number> just\n");
  strcat(help_string,"like if it was a line in the current script. \n");
 }
 else if(!cas_cmp(argv[2],"resolve"))
 {
  strcat(help_string,"resolve [ip,host] <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Resolve an IP from <variable number 1> to an host and put it in \n");
  strcat(help_string,"<variable number 2>, or resolve an host from <variable number 1> to an\n");
  strcat(help_string,"IP and put it in <variable number 2>. \n");
 }
 else if(!cas_cmp(argv[2],"cl"))
 {
  strcat(help_string,"cl <library> <args>\n");
  strcat(help_string,"This loads a custom library. SScript comes currently with 1\n");
  strcat(help_string,"library: the gui-tk library that provides a graphical interface\n");
  strcat(help_string,"to SScript. See section 4 of this document for more. \n");
 }
 else if(!cas_cmp(argv[2],"udpsend"))
 {
  strcat(help_string,"udpsend <variable number> ;\n");
  strcat(help_string,"Send an UDP message to a remote host. <variable number> must contain\n");
  strcat(help_string,"'<ip> <port> <message>' Returns an error message in <variable number> if\n");
  strcat(help_string,"the function fails. \n");
 }
 else if(!cas_cmp(argv[2],"udplisten"))
 {
  strcat(help_string,"udplisten <variable number> <port number> ;\n");
  strcat(help_string,"Listens for UDP calls at the specified port and returns what it got. \n");
 }
 else if(!cas_cmp(argv[2],"icmplisten"))
 {
  strcat(help_string,"This is not available from the win32 version\n");
 }
 else if(!cas_cmp(argv[2],"raw"))
 {
  strcat(help_string,"This is not available from the win32 version\n");
 }
 else if(!cas_cmp(argv[2],"rawp"))
 {
  strcat(help_string,"rawp <variable number> <number of loops> ;\n");
  strcat(help_string,"This does the same as raw, but prints the result directly to the screen. \n");
 }
 else if(!cas_cmp(argv[2],"msgbox"))
 {
  strcat(help_string,"msgbox <variable number> ;\n");
  strcat(help_string,"Show an info box with the string in <variable box>. You must have\n");
  strcat(help_string,"specified the graphical mode in the config. \n");
 }
 else if(!cas_cmp(argv[2],"query"))
 {
  strcat(help_string,"query <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Asks the user a question, showing the string in <variable number 1> as \n");
  strcat(help_string,"the question, and storing the user's input in <variable number 2>. You  \n");
  strcat(help_string,"must have specified the graphical mode in the config.\n");
 }
 else if(!cas_cmp(argv[2],"viewfile"))
 {
  strcat(help_string,"viewfile <file name> [-query <variable number>] ;\n");
  strcat(help_string,"Open a text box to view the whole content of the file <file name>. You  \n");
  strcat(help_string,"must have specified the graphical mode in the config. If you add the \n");
  strcat(help_string,"-query option, SScript will also ask the question in <variable number>  \n");
  strcat(help_string,"to the user, and put his answer in <vairable number>.\n");
 }
 else if(!cas_cmp(argv[2],"devstat"))
 {
  strcat(help_string,"This command is not available in this win32 version\n");
 }
 else if(!cas_cmp(argv[2],"setowner"))
 {
  strcat(help_string,"setowner <userid> ;\n");
  strcat(help_string,"Sets the owner to <userid>. This can be useful for a server-side script\n");
  strcat(help_string,"running as root to set its children as user 'nobody' (userid: 65534).\n");
  strcat(help_string,"Must be run as root. Use carefully.\n");
 }
 else if(!cas_cmp(argv[2],"background"))
 {
  strcat(help_string,"background ;  \n");
  strcat(help_string,"Send the script in the background. This shouldn't be use with   \n");
  strcat(help_string,"server-oriented scripts if you set FORK_START to ON in config.h\n");
 }
 else
 {
  strcat(help_string,"Unknown function.\n");
 }
#ifdef GUI
 if(type) gui_help(help_string, argc, argv);
 else 
#endif
  text_help(help_string);
}

#ifdef GUI
int gui_help(char *help_string, int argc, char *argv[])
{
 if(displayed) return 0;
 displayed = 1;
 top = XtVaAppInitialize(&ac, "SScript", NULL, 0, &argc, argv, sscript_resources, NULL);
 mainbox = XtVaCreateManagedWidget("mainbox", boxWidgetClass, top, NULL);
 continuebutton = XtVaCreateManagedWidget("Quit",commandWidgetClass,mainbox,NULL);
 viewbox = XtVaCreateManagedWidget("viewbox", asciiTextWidgetClass, mainbox, XtNheight, 300, XtNwidth, 600, XtNscrollVertical, XawtextScrollWhenNeeded, XtNscrollHorizontal, XawtextScrollWhenNeeded, NULL);
 XtAddCallback(continuebutton, XtNcallback, (XtPointer)ContinueIt, NULL);
 XtVaSetValues(viewbox, XtNstring, help_string, NULL);
 XtRealizeWidget(top);
 while(displayed)
 {
  XtAppNextEvent(ac, &qevent);
  XtDispatchEvent(&qevent);
 }
}
#endif

int text_help(char *help_string[])
{
 printf("%s\n",help_string);
 return 0;
}

int debugger(char *file)
{
 FILE *fp;
 char tmp[255];
 int line,i;
 printf("Checking %s...\n",file);
 fp=fopen(file,"r");
 if(fileno(fp)<0)
 {
  printf("Error: Script not found.\n");
  press();
  exit(1);
 }
 if(fgets(tmp,255,fp)==NULL) printf("Error: Server line not found.\n");
 if(cas_cmp(lindex(tmp,0),"server")) printf("Error: Server line not found.\n");
 if(fgets(tmp,255,fp)==NULL) printf("Error: Port line not found.\n");
 if(cas_cmp(lindex(tmp,0),"port")) printf("Error: Port line not found.\n");
 if(fgets(tmp,255,fp)==NULL) printf("Error: Debug line not found.\n");
 if(cas_cmp(lindex(tmp,0),"debug")) printf("Error: Debug line not found.\n");
 if(fgets(tmp,255,fp)==NULL) printf("Error: Chop line not found.\n");
 if(cas_cmp(lindex(tmp,0),"chop")) printf("Error: Chop line not found.\n");
 if(fgets(tmp,255,fp)==NULL) printf("Error: Virtual line not found.\n");
 if(cas_cmp(lindex(tmp,0),"virtual")) printf("Error: Virtual line not found.\n");
 line=5;
 while(fgets(tmp,255,fp)!=NULL)
 {
  line++;
  for(i=0;lindex(tmp,i)!=NULL;i++) { }
  if(cas_cmp(lindex(tmp,0),"#") && 
     cas_cmp(lindex(tmp,0),"print") &&
     cas_cmp(lindex(tmp,0),"set") && 
     cas_cmp(lindex(tmp,0),"write") &&
     cas_cmp(lindex(tmp,0),"ifmatch") &&
     cas_cmp(lindex(tmp,0),"ifmatch2") &&
     cas_cmp(lindex(tmp,0),"ifword") && 
     cas_cmp(lindex(tmp,0),"ifword2") && 
     cas_cmp(lindex(tmp,0),"ifmaster") &&
     cas_cmp(lindex(tmp,0),"ifmaster2"))
  if(*lindex(tmp,i-1)!=';') printf("Warning: Line does not end with ';' [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"ifword") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"ifword2") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"ifmaster") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"ifmaster2") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"ifmatch") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"ifmatch2") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"require") && atoi(lindex(tmp,1))<1)
   printf("Error: Version number < 0 [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"save") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);  
  if(!cas_cmp(lindex(tmp,0),"append") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"rementry") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"remove") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"parse") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"for") && lindex(tmp,5)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"endfor") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"?compare") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"?match") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"loop") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"sub") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"goto") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"if") && lindex(tmp,4)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"random") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"udplisten") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!cas_cmp(lindex(tmp,0),"raw") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
 }
 printf("End of file.\n");
}

#ifdef GUI
int ComposerSave(Widget result, XtPointer p1, XtPointer p2)
{
 XawAsciiSaveAsFile(XawTextGetSource(viewbox), GlFile);
}

int ComposerAddServer(Widget result, XtPointer p1, XtPointer p2)
{
 char data[255];
 XawTextBlock text;
 static XawTextPosition pos;
 strcpy(data,"\n# server <ip>\nserver 127.0.0.1 ;\n");
 pos = XawTextGetInsertionPoint(viewbox);
 text.length = strlen(data);
 text.ptr = data;
 text.firstPos = 0;
 text.format = FMT8BIT;
 XawTextReplace(viewbox, pos, pos, &text);
 pos += text.length;
 XawTextSetInsertionPoint(viewbox, pos);
}

int ComposerAdd(Widget result, XtPointer p1, XtPointer p2)
{
 char data[255];
 XawTextBlock text;
 static XawTextPosition pos;
 strcpy(data,p1);
 if(!cas_cmp(data,"server"))
 strcpy(data,"\n# server <ip>\nserver 127.0.0.1 ;\n");
 else if(!cas_cmp(data,"port"))       
 strcpy(data,"\n# port <port>\nport 80 ;\n");
 else if(!cas_cmp(data,"debug"))
 strcpy(data,"\n# debug <0|1>\ndebug 0 ;\n");
 else if(!cas_cmp(data,"virtual"))
 strcpy(data,"\n# virtual <0|1>\nvirtual 0 ;\n");
 else if(!cas_cmp(data,"chop"))
 strcpy(data,"\n# chop <0|1>\nchop 0 ;\n");
 else if(!cas_cmp(data,"rread"))
 strcpy(data,"\n# rread <variable number> ;\nrread 100 ;\n");
 else if(!cas_cmp(data,"rwrite"))
 strcpy(data,"\n# rwrite <variable number> ;\nset 100 hello !\nrwrite 100 ;\n");
 else if(!cas_cmp(data,"rdisconnect"))
 strcpy(data,"\n# rdisconnect ;\nrdisconnect ;\n");
 else if(!cas_cmp(data,"include"))
 strcpy(data,"\n# include <name> <cl bin> ;\ninclude hello hello ;\n");
 else if(!cas_cmp(data,"setuserhost"))
 strcpy(data,"\n# setuserhost ;\nsetuserhost ;\n");
 else if(!cas_cmp(data,"setstrictcheck"))
 strcpy(data,"\n# setstrictcheck ;\nsetstrictcheck ;\n");
 else if(!cas_cmp(data,"setstrictwrite"))
 strcpy(data,"\n# setstrictwrite ;\nsetstrictwrite ;\n");
 else if(!cas_cmp(data,"settrace"))
 strcpy(data,"\n# settrace ;\nsettrace ;\n");
 else if(!cas_cmp(data,"setreversechop"))
 strcpy(data,"\n# setreversechop ;\nsetreversechop ;\n");
 else if(!cas_cmp(data,"setservice"))
 strcpy(data,"\n# setservice ;\nsetservice ;\n");
 else if(!cas_cmp(data,"setwindows"))
 strcpy(data,"\n# setwindows ;\nsetwindows ;\n");
 else if(!cas_cmp(data,"setsignalsoff"))
 strcpy(data,"\n# setsignalsoff ;\nsetsignalsoff ;\n");
 else if(!cas_cmp(data,"setremoteecho"))
 strcpy(data,"\n# setremoteecho ;\nsetremoteecho ;\n");
 else if(!cas_cmp(data,"require"))
 strcpy(data,"\n# require <version> ;\nrequire 18 ;\n");
 else if(!cas_cmp(data,"require-gui"))
 strcpy(data,"\n# require-gui ;\nrequire-gui ;\n");
 else if(!cas_cmp(data,"version"))
 strcpy(data,"\n# version ;\nversion ;\n");
 else if(!cas_cmp(data,"run"))
 strcpy(data,"\n# run <variable number> ;\nset 100 my.sh\nrun 100 ;\n");
 else if(!cas_cmp(data,"goto"))
 strcpy(data,"\n# goto <sub name> ;\ngoto my_sub ;\n");
 else if(!cas_cmp(data,"read"))
 strcpy(data,"\n# read <variable number> ;\nread 100 ;\n");
 else if(!cas_cmp(data,"write"))
 strcpy(data,"\n# write <string> ;\nwrite Hi $word 100 0 !\n");
 else if(!cas_cmp(data,"print"))
 strcpy(data,"\n# print <string> ;\nprint Thank you for using SScript\n");
 else if(!cas_cmp(data,"save"))
 strcpy(data,"\n# save <variable number> <file> ;\nsave 100 log.file ;\n");
 else if(!cas_cmp(data,"append"))
 strcpy(data,"\n# append <variable number> <file> ;\nappend 101 log.file ;\n");
 else if(!cas_cmp(data,"rementry"))
 strcpy(data,"\n# rementry <variable number> <file> ;\nrementry 100 database.file ;\n");
 else if(!cas_cmp(data,"remove"))
 strcpy(data,"\n# remove <vairable number> <file> ;\nremove 100 database.file ;\n");
 else if(!cas_cmp(data,"ping"))
 strcpy(data,"\n# ping <remote ip> ;\nping 127.0.0.1 ;\n");
 else if(!cas_cmp(data,"test"))
 strcpy(data,"\n# test <variable number> ;\nset 100 127.0.0.1 80 ;\ntest 100 ;\n");
 else if(!cas_cmp(data,"parse"))
 strcpy(data,"\n# parse [<,<<,>>,>,!,_>,<_] <variable number> <char> ;\nparse < 100 @ ;\n");
 else if(!cas_cmp(data,"dump"))
 strcpy(data,"\n# dump <variable number> ;\nset 100 my.file ;\ndump 100 ;\n");
 else if(!cas_cmp(data,"setmaster"))
 strcpy(data,"\n# setmaster <file containing: <masked nick!user@host> ;> ;\nsetmaster masters.list ;\n");
 else if(!cas_cmp(data,"set"))
 strcpy(data,"\n# set <variable number> <string>\nset 100 hi !\n");
 else if(!cas_cmp(data,"setlogfile"))
 strcpy(data,"\n# setlogfile <filename> ;\nsetlogfile my.log ;\n");
 else if(!cas_cmp(data,"exit"))
 strcpy(data,"\n# exit ;\nexit ;\n");
 else if(!cas_cmp(data,"saveall"))
 strcpy(data,"\n# saveall <filename> ;\nsaveall file.txt ;\n");
 else if(!cas_cmp(data,"addlog"))
 strcpy(data,"\n# addlog <variable number> ;\nset 100 Starting sub 24\naddlog 100 ;\n");
 else if(!cas_cmp(data,"file"))
 strcpy(data,"\n# file exist <variable 1> <variable 2> ;\nset 100 my.file\nfile exist 100 101 ;\n");
 else if(!cas_cmp(data,"icmplisten"))
 strcpy(data,"\n# icmplisten <variable number> ;\nicmplisten 100 ;\n");
 else if(!cas_cmp(data,"cl"))
 strcpy(data,"\n# cl <library> <command> <args> ... ;\ncl util crypt 100 101 ;\n");
 else if(!cas_cmp(data,"command"))
 strcpy(data,"\n# command <variable number> ;\nset 100 addlog 101 ;\ncommand 100 ;\n");
 else if(!cas_cmp(data,"background"))
 strcpy(data,"\n# background ;\nbackground ;\n");
 else if(!cas_cmp(data,"rconnect"))
 strcpy(data,"\n# rconnect <variable number> ;\nset 100 127.0.0.1 23 ;\nrconnect 100 ;\n");
 else if(!cas_cmp(data,"endfor"))
 strcpy(data,"\n# endfor <for number> ;\nendfor 1 ;\n");
 else if(!cas_cmp(data,"ask"))
 strcpy(data,"\n# ask <variable number> ;\nask 105 ;\n");
 else if(!cas_cmp(data,"ifmatch"))
 strcpy(data,"\n# ifmatch <variable number> <masked word> <string> ;\nifmatch 100 *user@*.host QUIT : $nick asked me to.\n");
 else if(!cas_cmp(data,"loop")) 
 strcpy(data,"\n# loop [start|end] <loop number> ;\nloop start 1 ;\nloop end 1 ;\n");
 else if(!cas_cmp(data,"for"))
 strcpy(data,"\n# for <for number> <start number> to <end number> ;\nfor 1 1 to 100 do\n");
 else if(!cas_cmp(data,"ifword"))
 strcpy(data,"\n# ifword <variable number> <word number> <word> <string>\nifword 100 0 help Here is my help: none.\n");
 else if(!cas_cmp(data,"ifword2"))
 strcpy(data,"\n# ifword2 <variable number> <word number> <word> <word number 2> <word 2> <string>\nifword2 100 0 help 1 commands There is no command available yet.\n");
 else if(!cas_cmp(data,"ifmaster"))
 strcpy(data,"\n# ifmaster <variable number> <word number> <word> <string>\nifmaster 100 3 :raw PRIVMSG $nick :raw is not available\n");
 else if(!cas_cmp(data,"ifmaster2"))
 strcpy(data,"\n# ifmaster2 <variable number> <word number> <word> <word number 2> <word 2> <string>\nifmaster2 100 3 :password 4 ScrtPass PRIVMSG $nick :Auth failed.\n");
 else if(!cas_cmp(data,"?compare"))
 strcpy(data,"\n# ?compare <variable number 1> <variable number 2> <sub name> ;\n?compare 100 101 my_sub ;\n");
 else if(!cas_cmp(data,"?match"))
 strcpy(data,"\n# ?match <variable number 1> <variable number 2> <sub name> ;\n?match 100 101 my_sub ;\n");
 else if(!cas_cmp(data,"if"))
 strcpy(data,"\n# if <variable number 1> [<,>,=] <variable number 2> <sub name> ;\nif 100 = 101 my_sub ;\n");
 else if(!cas_cmp(data,"resolve"))
 strcpy(data,"\n# resolve [ip,host] <variable number 1> <variable number 2> ;\nresolve host 100 101 ;\n");
 else if(!cas_cmp(data,"cron")) 
 strcpy(data,"\n# cron <command line>\ncron /usr/bin/who\n");
 else if(!cas_cmp(data,"random")) 
 strcpy(data,"\n# random <variable number> <max> ;\nrandom 100 6 ;\n");
 else if(!cas_cmp(data,"udpsend"))
 strcpy(data,"\n# udpsend <variable number> ;\nset 100 127.0.0.1 2000 Hi, this is the sender\nudpsend 100 ;\n");
 else if(!cas_cmp(data,"udplisten"))
 strcpy(data,"\n# udplisten <variable number> <port number> ;\nudplisten 100 2000\n");
 else if(!cas_cmp(data,"raw"))
 strcpy(data,"\n# raw <variable number 1> <number of loops> <variable number 2> ;\nraw 100 1 101 ;\n");
 else if(!cas_cmp(data,"viewfile"))
 strcpy(data,"\n# viewfile <file name> [-query <variable number>] ;\nviewfile test.txt -query 100 ;\n");
 else if(!cas_cmp(data,"devstats"))
 strcpy(data,"\n# devstat <device> <variable number> ;\ndevstat eth0 100 ;\n");
 else if(!cas_cmp(data,"getenv"))
 strcpy(data,"\n# getenv <word> <variable number> ;\ngetenv HOME 100 ;\n");
 else if(!cas_cmp(data,"query"))
 strcpy(data,"\n# query <variable number 1> <variable number 2> ;\nquery 100 101 ;\n");
 else if(!cas_cmp(data,"choicebox"))
 strcpy(data,"\n# choicebox <variable number> <button 1> <button 2> ... | <label>\nchoicebox Yes No Quit | Are you sure ?\n");
 else if(!cas_cmp(data,"msgbox"))
 strcpy(data,"\n# msgbox <variable number> ;\nset 100 Welcome !\nmsgbox 100 ;\n");
 else strcpy(data,"\n# Command not in list. Try sscript -help <command>\n");
 pos = XawTextGetInsertionPoint(viewbox);
 text.length = strlen(data);
 text.ptr = data;
 text.firstPos = 0;
 text.format = FMT8BIT;
 XawTextReplace(viewbox, pos, pos, &text);
 pos += text.length;
 XawTextSetInsertionPoint(viewbox, pos);
}

int composer(char *file, int argc1, char *argv1[])
{
 FILE *fd;
 char *file_buf, tmp[255];
 off_t len;
 struct stat stat_buf;
 if(displayed) return 0;
 displayed = 1;
 strcpy(GlFile, file);
 if(lang==0)
 sprintf(file,"Filename: %s", GlFile);
 else if(lang==1)
 sprintf(file,"Nom de fichier: %s", GlFile);
 else if(lang==2)
 sprintf(file,"Archivo: %s", GlFile);
 top = XtVaAppInitialize(&ac, "SScript", NULL, 0, &argc1, argv1, sscript_resources, XtNtitle, "Socket Script", NULL);
 mainbox = XtVaCreateManagedWidget("mainbox", boxWidgetClass, top, NULL);
 menubutton1 = XtVaCreateManagedWidget("menubutton1", menuButtonWidgetClass, mainbox, XtNlabel, "File", XtNborderWidth, 2, NULL);
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton1, XtNlabel, "Composer functions", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("savebutton", smeBSBObjectClass, menu, XtNlabel, "Save file", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerSave, NULL);
 entry = XtVaCreateManagedWidget("quitbutton", smeBSBObjectClass, menu, XtNlabel, "Quit", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)queryQuit, NULL);
 menubutton2 = XtVaCreateManagedWidget("menubutton2", menuButtonWidgetClass, mainbox, XtNlabel, "Header", XtNborderWidth, 2, NULL);
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton2, XtNlabel, "Add header commands", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Server", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "server");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Port", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "port");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Debug", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "debug");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Chop", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "chop");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Virtual", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "virtual");
 menubutton3 = XtVaCreateManagedWidget("menubutton3", menuButtonWidgetClass, mainbox, XtNlabel, "Version", XtNborderWidth, 2, NULL);
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton3, XtNlabel, "Add version-related commands", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Version", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "version");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Require", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "require");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Require-GUI", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "require-gui");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Include", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "include");
 menubutton4 = XtVaCreateManagedWidget("menubutton4", menuButtonWidgetClass, mainbox, XtNlabel, "Networking", XtNborderWidth, 2, NULL);
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton4, XtNlabel, "Add networking commands", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Read", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "read");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Write", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "write");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Ping", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "ping");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Test", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "test");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Dump", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "dump");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Rconnect", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "rconnect");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Rread", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "rread");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Rwrite", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "rwrite");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Rdisconnect", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "rdisconnect");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "UDP send", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "udpsend");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "UDP listen", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "udplisten");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Raw", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "raw");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "ICMPlisten", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "icmplisten");
 menubutton5 = XtVaCreateManagedWidget("menubutton5", menuButtonWidgetClass, mainbox, XtNlabel, "I/O", XtNborderWidth, 2, NULL);
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton5, XtNlabel, "Add file and screen commands", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Print", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "print");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Ask", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "ask");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Save", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "save");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Append", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "append");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Remove", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "remove");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Rementry", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "rementry");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Save All", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "saveall");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "File", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "file");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Add log", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "addlog");
 menubutton6 = XtVaCreateManagedWidget("menubutton6", menuButtonWidgetClass, mainbox, XtNlabel, "Parse", XtNborderWidth, 2, NULL);
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton6, XtNlabel, "Add parsing commands", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Parse", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "parse");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "set");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "If match", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "ifmatch");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "If word", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "ifword");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "If word 2", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "ifword2");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "If master", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "ifmaster");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "If master 2", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "ifmaster2");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "? compare", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "?compare");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "? match", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "?match");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "If", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "if");
 menubutton7 = XtVaCreateManagedWidget("menubutton7", menuButtonWidgetClass, mainbox, XtNlabel, "Loops", XtNborderWidth, 2, NULL);
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton7, XtNlabel, "Add loops commands", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "For", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "for");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "End for", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "endfor");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Loop", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "loop");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Go to", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "goto");
 menubutton8 = XtVaCreateManagedWidget("menubutton8", menuButtonWidgetClass, mainbox, XtNlabel, "GUI", XtNborderWidth, 2, NULL);
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton8, XtNlabel, "Add GUI commands", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Msg box", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "msgbox");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Choice box", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "choicebox");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Query", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "query");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Viewfile", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "viewfile");
 menubutton9 = XtVaCreateManagedWidget("menubutton9", menuButtonWidgetClass, mainbox, XtNlabel, "Settings", XtNborderWidth, 2, NULL);
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton9, XtNlabel, "Add setting options", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set master", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setmaster");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set log file", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setlogfile");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set Windows compatibility", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setwindows");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set signals off", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setsignalsoff");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set remote echo", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setremoteecho");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set user@host", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setuserhost");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set as service", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setservice");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set reverse chop", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setreversechop");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set strict-check", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setstrictcheck");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set strict-write", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "setstrictwrite");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Set trace", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "settrace");
 menubutton10 = XtVaCreateManagedWidget("menubutton10", menuButtonWidgetClass, mainbox, XtNlabel, "Misc", XtNborderWidth, 2, NULL);   
 menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, menubutton10, XtNlabel, "Add other commands", NULL);
 entry = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL);
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Resolve", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "resolve");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Cron", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "cron");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Random", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "random");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Dev stats", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "devstats");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Get env", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "getenv");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Run", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "run");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Command", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "command");
 entry = XtVaCreateManagedWidget("entry", smeBSBObjectClass, menu, XtNlabel, "Background", NULL);
 XtAddCallback(entry, XtNcallback, (XtPointer)ComposerAdd, "background");
 if(lang==0) sprintf(tmp,"Filename: %s",GlFile);
 if(lang==1) sprintf(tmp,"Fichier: %s",GlFile);
 if(lang==2) sprintf(tmp,"Archivo: %s",GlFile);
 last = XtVaCreateManagedWidget("label", labelWidgetClass, mainbox, XtNlabel, tmp, "borderWidth", 0, NULL);
 viewbox = XtVaCreateManagedWidget("viewbox", asciiTextWidgetClass, mainbox, XtNheight, 300, XtNwidth, 600, XtNscrollVertical, XawtextScrollAlways, XtNscrollHorizontal, XawtextScrollAlways, XtNeditType, XawtextEdit, NULL);
 if((fd=fopen(GlFile,"ro"))==NULL)
 {
  if(lang==0)
  XtVaSetValues(viewbox, XtNstring, "\nCan't open that file\n\n", NULL);
  else if(lang==1)
  XtVaSetValues(viewbox, XtNstring, "\nNe peut ouvrir ce fichier\n\n", NULL);
  else if(lang==2)
  XtVaSetValues(viewbox, XtNstring, "\nNo se puede abrir el archivo\n\n", NULL);
 }
 else
 {
  fstat(fileno(fd), &stat_buf);
  len = stat_buf.st_size;
  file_buf = malloc(len * sizeof(char) +1);
  fread(file_buf, 1, len, fd);
  file_buf[len] = '\0';
  XtVaSetValues(viewbox, XtNstring, file_buf, NULL);
  free(file_buf);
  fclose(fd);
 }
 XtRealizeWidget(top);
 while(displayed) {
  XtAppNextEvent(ac, &qevent);
  XtDispatchEvent(&qevent);
 }
}

int choiceHdl(Widget result, XtPointer p1, XtPointer p2) 
{
 if(result==choicebutton[0]) strcpy(queryGlVar,"1");
 else if(result==choicebutton[1]) strcpy(queryGlVar,"2");
 else if(result==choicebutton[2]) strcpy(queryGlVar,"3");
 else if(result==choicebutton[3]) strcpy(queryGlVar,"4");
 else if(result==choicebutton[4]) strcpy(queryGlVar,"5");
 else if(result==choicebutton[5]) strcpy(queryGlVar,"6");
 else if(result==choicebutton[6]) strcpy(queryGlVar,"7");
 else if(result==choicebutton[7]) strcpy(queryGlVar,"8");
 else if(result==choicebutton[8]) strcpy(queryGlVar,"9");
 else if(result==choicebutton[9]) strcpy(queryGlVar,"10");
 else strcpy(queryGlVar,"-1");
 XtDestroyWidget(mainbox);
 XtUnrealizeWidget(top);
 XtDestroyApplicationContext(ac);
 displayed = 0;
}

int choicebox(int argc1, char *argv1[])
{
 int i;
 if(displayed) return 0;
 displayed = 1;
 top = XtVaAppInitialize(&ac, "SScript", NULL, 0, &argc1, argv1, sscript_resources, XtNtitle, "Socket Script", NULL);
 mainbox = XtVaCreateManagedWidget("mainbox", boxWidgetClass, top, NULL);
 for(i=0;lindex(temp,i)!=NULL;i++)
 {
  if(!cas_cmp(lindex(temp,i),"|"))
  {
   last = XtVaCreateManagedWidget("label", labelWidgetClass, mainbox, XtNlabel, lrange(temp,i+1), "borderWidth", 0, NULL);
   break;
  }
 }
 i=0;
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
 choicebutton[i] = XtVaCreateManagedWidget(lindex(temp,i+2), commandWidgetClass, mainbox, NULL);
 XtAddCallback(choicebutton[i], XtNcallback, (XtPointer)choiceHdl, NULL);
 i++;
 }
 XtRealizeWidget(top);
 while(displayed) {
  XtAppNextEvent(ac, &qevent);
  XtDispatchEvent(&qevent);
 }
}
#endif

remote(char *script, char *host, int port, char *filename)
{
 int rsock, len, i, result;
 FILE *fr;
 char data[1024]="", inchar;
 struct sockaddr_in address;
 rsock=socket(AF_INET, SOCK_STREAM, 0);
 if(rsock<0)
 {
#ifdef GUI
   XFlush(display);
   if(lang==0)   
   msgbox("error","Internal error: Socket failed.",25);
   else if(lang==1)
   msgbox("error","Erreur interne: Socket erreur.",25);
   else if(lang==2)
   msgbox("error","Error Interno: Fallo el Socket.",25);
#else
   if(lang==0)
   fprintf(stderr,"*** Internal error: Socket failed [%d].\n",errno);
   else if(lang==1)
   fprintf(stderr,"*** Erreur interne: Socket erreur. [%d].\n",errno);
   else if(lang==2)
   fprintf(stderr,"*** Error Interno: Fallo el Socket. [%d].\n",errno);
#endif
   press();
   exit(1);
 }
 address.sin_family = AF_INET;
 address.sin_addr.s_addr = inet_addr(host);
 address.sin_port = htons(port);
 len = sizeof(address);
 result = connect(rsock, (struct sockaddr *)&address, len);
 if(result==-1)
 {
#ifdef GUI
  XFlush(display);
  if(lang==0)
  msgbox("error","Script error: Can't connect to remote host.",30);
  else if(lang==1)
  msgbox("error","Erreur script: Incapable de me connecter.",30);
  else if(lang==2)
  msgbox("error","Error en Script: No se puede conectar a host remoto.",30);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Can't connect to %s\n",host);
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Incapable de me connecter sur %s\n",host);
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: No se puede conectar a host remoto %s\n",host);
#endif
  press();
  exit(1);
 }
 sprintf(data,"%s ;\n",script);
 write(rsock,data,sizeof(data));
 fr=fopen(filename,"w");
 while(cas_cmp(lindex(data,0),"--DATA--"))
 {
  bzero(data, 1024);
  for(i=0;(result=read(rsock,&inchar,1))!='\0';i++)
  {
   data[i]=inchar;
   if(inchar=='\n') break;
  }
  fputs(data,fr);
 }
 if(fr!=NULL) fclose(fr);
}

int press()
{
 char blahe[2];
 printf("Press enter to exit...\n");
 gets(blahe);
}
