unit Unit1;
      {Camera/Shy the Steganographical Browser
Copyright (C) 2002  cDc-Communications through Hacktivismo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
   //***********************************************************
   //Author: the Pull pull@hacktivismo.com or osioniusx@yahoo.com
   //Affliated Credits:
   // Without these guys, C/S would not have been possible.
  //StoneFisk - Research, QA, test sites
  //Genetix - Graphics Consulting, QA, Docs, test sites
  //Saboteur - QA, test sites
  //Zax - QA, test sites
  //Novice222 - the perfunctory air traffic controller
  //Persons Unknown - QA, test sites
  //************************************************************

      {Non-affiliated credits: steg code base from "mail@itte.no" posted to
      Usenet. Lee, Neung Hoon (victor_hoon@hotmail.com) (Usenet
      post about grabbing source from html). iecache, embeddedwb,
      from Per Linds Larsen. Rijandael encryption
      from David Barton, www.scramdisk.com. Unicode controls from:
      Troy Wolbrink http://home.ccci.org/wolbrink/index.htm . Base64
      from Indy components. Note: //ExpireTime := FileTimeToDateTime(info^.ExpireTime); is
      commented out in IECache.pas. Earl F Glynn for a lot of image code.
      Enough can not be said about some of these opensource works,
      and about the Delphi community in general... when it comes to answering
      questions freely and sharing code.}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleCtrls, SHDocVw_TLB, EmbeddedWB,
  ExtCtrls, ExtDlgs, Buttons, TntStdCtrls, MSHTML_TLB, activex,
  IECache, IETravelLog, Menus, DCPcrypt, Rijndael,
  IdBaseComponent, IdCoder, IdCoder3to4, IdCoderMIME, Unicode, gifimage,
  ComCtrls, ToolWin,ImgList, VirtualExplorerTree,gif2jpeg, unit2,gif2Bmp, Registry, PaletteLibrary;

type
  TForm1 = class(TForm)
    Scriptlet1: TScriptlet;
    Image2: TImage;
    Label9: TLabel;
    Panel1: TPanel;
    Image1: TImage;
    TntMemo1: TTntMemo;
    Label6: TLabel;
    Label2: TLabel;
    Label1: TLabel;
    Label3: TLabel;
    mmMessage: TTntMemo;
    lblImageFile: TLabel;
    Panel2: TPanel;
    OpenPictureDialog1: TOpenPictureDialog;
    IECache1: TIECache;
    Panel3: TPanel;
    webbrowser1: TEmbeddedWB;
    Label4: TLabel;
    IETravelLog1: TIETravelLog;
    PopupMenu1: TPopupMenu;
    rijandael1: TDCP_rijndael;
    base64: TIdEncoderMIME;
    base642: TIdDecoderMIME;
    StatusBar1: TStatusBar;
    MainMenu1: TMainMenu;
    HelperApplications1: TMenuItem;
    View1: TMenuItem;
    Help1: TMenuItem;
    Help2: TMenuItem;
    HelpFile1: TMenuItem;
    About1: TMenuItem;
    BMPGIF1: TMenuItem;
    JPEGBMP1: TMenuItem;
    ShowGIFScreen1: TMenuItem;
    HighSecurityWebbrowsing1: TMenuItem;
    HighSecurityGIFBrowsing1: TMenuItem;
    Label5: TLabel;
    Label8: TLabel;
    Label7: TLabel;
    urlBar: TComboBoxEx;
    ToolBar1: TToolBar;
    BackButton: TToolButton;
    RefreshButton: TToolButton;
    ForwardButton: TToolButton;
    StopButton: TToolButton;
    WideEdit2: TWideEdit;
    Images1: TImageList;
    EncryptWBButton: TToolButton;
    WideEdit3: TWideEdit;
    ToolBar2: TToolBar;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton9: TToolButton;
    SmallImages: TImageList;
    EncryptMessage: TBitBtn;
    No1: TMenuItem;
    Dedication1: TMenuItem;
    Read1: TMenuItem;
    BitBtn1: TBitBtn;
    KillPopups1: TMenuItem;
    StatusBar2: TStatusBar;
    StatusBar3: TStatusBar;
    MaskPassword: TMenuItem;
    gifBox: TTntListBox;
    procedure btnLoadImageClick(Sender: TObject);
    procedure btnEncryptClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure GetHTMLSource;
    procedure webbrowser1DocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure EncryptMessageClick(Sender: TObject);
    procedure scanforGIF;
    function ExtractSteganography(BMP: TBitmap; var Text: string; CheckingOnly: boolean = false): boolean;
    procedure InsertSteganography(BMP: TBitmap; Message: string);
    procedure mmMessageChange(Sender: TObject);
    function GetTempDir: string;
    procedure DecryptBMP;
    procedure gifBoxClick(Sender: TObject);
    procedure parseHTML;
    procedure Button5Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure IETravelLog1Entry(Title, Url: String; var Cancel: Boolean);
    procedure webbrowser1CommandStateChange(Sender: TObject;
      Command: Integer; Enable: WordBool);
    procedure FormShow(Sender: TObject);
    procedure MyPopupHandler(Sender: TObject);
    function encryptHTML(encryptString:string):string;
    function decryptHTML(decryptString:string):string;
    procedure webbrowser1ScriptError(Sender: TObject; ErrorLine,
      ErrorCharacter, ErrorCode, ErrorMessage, ErrorUrl: String;
      var ContinueScript, Showdialog: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure HighSecurityWebbrowsing1Click(Sender: TObject);
    procedure HighSecurityGIFBrowsing1Click(Sender: TObject);
    procedure HelpFile1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure ShowGIFScreen1Click(Sender: TObject);
    procedure urlBarKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure StopButtonClick(Sender: TObject);
    procedure BackButtonClick(Sender: TObject);
    procedure RefreshButtonClick(Sender: TObject);
    procedure EncryptWBButtonClick(Sender: TObject);
    procedure ForwardButtonClick(Sender: TObject);
    procedure webbrowser1NavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton8Click(Sender: TObject);
    procedure ToolButton9Click(Sender: TObject);
    procedure No1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SilentHistoryOn;
    procedure SilentHistoryOff;
    procedure BMPGIF1Click(Sender: TObject);
    procedure urlBarSelect(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure WideEdit3Change(Sender: TObject);
    procedure WideEdit2Change(Sender: TObject);
    procedure Read1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure webbrowser1StatusTextChange(Sender: TObject;
      const Text: WideString);
    procedure webbrowser1NewWindow2(Sender: TObject; var ppDisp: IDispatch;
      var Cancel: WordBool);
    procedure KillPopups1Click(Sender: TObject);
    procedure webbrowser1SetSecureLockIcon(Sender: TObject;
      SecureLockIcon: Integer);
    procedure webbrowser1TitleChange(Sender: TObject;
      const Text: WideString);
    Function DecodeURL(Const Str : String) : String;
    procedure JPEGBMP1Click(Sender: TObject);
    procedure MaskPasswordClick(Sender: TObject);

  private
    { Private declarations }
    PaletteHandle:  hPalette;
  public
    { Public declarations }
   SessionStart: TDateTime;
   statusUrl:string;
  end;

var
  Form1: TForm1;
    Back: Boolean;
  PopUpItems: array[0..9] of TMenuItem;
  ItemsCounter: Integer;

implementation

{$R *.dfm}

function TForm1.ExtractSteganography(BMP: TBitmap; var Text: string; CheckingOnly: boolean = false): boolean;
var
  i,
  j: integer;
  Ch: Byte;
  PixSize: integer;
  PB    : pByte;
  Row   : pByteArray;
  BitCounter: integer;
  SigLength: integer;
  SIGNATURE: widestring;
begin
  Text:='';
  result:=false;
  SIGNATURE:= WideEdit2.text;
  SigLength:=Length(SIGNATURE);
  if not Assigned(BMP) then exit;
  with BMP do begin
    case PixelFormat of
      pf32bit: PixSize:=4;
      pf24bit: PixSize:=3;
      pf16bit: PixSize:=2;
      else
        exit;
    end;
    Ch:=0;
    BitCounter:=0;
    for i:=0 to Height-1 do begin
      Row:=ScanLine[i]; // Pointer to a buffer containing a horz line of pixels
      PB:=@Row[PixSize-1];
      for j:=0 to Width-1 do begin // One bit of encrypted data per per pixel !
        Ch:=Ch or ((PB^ and 1) shl BitCounter);
        if BitCounter = 7 then begin // Means we have read a full byte !
          if Ch <> 0 then begin // if the Character read is #0, we're at an end of data
            Text:=Text+Chr(Ch);
            if (Length(Text) = SigLength) then begin
              if Text = SIGNATURE then begin // it means it's a picture encrypted with this implementation
                result:=true;
                Text:=''; // But we don't want that string to be returned. *Now* real data is following
              end;
              if CheckingOnly then begin // If it's a check, we don't want to read it all !
                Text:='';
                exit;
              end;
            end;
          end
          else if (i + j) > 0 then // Ch = #0 and it's *not* the very first pixel data !
            exit;
          Ch:=0;
          BitCounter:=0; // reset bit counter
        end
        else
          inc(BitCounter); //read next bit
        inc(PB, PixSize);
      end;
    end;
  end;
end;

// SIGNATURE + Meaage

procedure TForm1.InsertSteganography(BMP: TBitmap; Message: string);
var
  i, j  : integer;
  row   :  pByteArray;
  PB    : pByte;
  NextCh: PChar;
  PixSize: integer;
  BytesToGo: integer;
  BitCounter: integer;
  SIGNATURE: WideString;
begin
  SIGNATURE:= WideEdit2.text;
  if not Assigned(BMP) then exit;
  Message:=SIGNATURE+Message;
  BytesToGo:=Length(Message)+2; // We get an extra #0 at the end of the string when cast as PChar
  with BMP do begin
    case PixelFormat of
      pf32bit: PixSize:=4;
      pf24bit: PixSize:=3;
      pf16bit: PixSize:=2;
      else
        exit;
    end;
    if (Width*Height) div PixSize < BytesTogo then
      begin
      label1.Caption :='(Max. Message Size: '+inttostr((Width*Height) div PixSize) +')';
      raise Exception.CreateFmt('Too long string to encrypt (Max: %d, Actual: %d)', [(Width*Height) div PixSize, BytesToGo]);
      end;
    NextCh:=@Message[1]; // Set String pointer to first character
    BitCounter:=0;
    for i:=0 to Height-1 do begin
      Row:=ScanLine[i];
      PB:=@Row[PixSize-1];
      for j:=0 to Width-1 do begin
        PB^:=(PB^ and $FE) // We want the upper 7 bits of the byte to be unchanged
             or ((Ord(NextCh^) shr BitCounter) and 1); // and add an extra 0/1 to store 1/8 of a char value
        if (BitCounter = 7) then begin // We've written a full Char
          inc(NextCh); // Place PChar on next char in data string
          dec(BytesToGo); // dec number of bytes left
          BitCounter:=0; // and reset bit counter (=bit "index")
        end
        else
          inc(BitCounter);
        if BytesToGo = 0 then exit;

        inc(PB, PixSize); // Move BMP buffer pointer
      end;
    end;
  end;
end;

procedure TForm1.btnLoadImageClick(Sender: TObject);
var
  Tmp: string;
  SIGNATURE:WideString;
  filenameofPic:string;
  GIF: TGIFImage;
  GIF2: TGIFImage;
  maxSize:integer;
begin
SIGNATURE:= '['+WideEdit2.text+']';
        tntmemo1.Clear;

  GIF := TGIFImage.Create;
  //this one is merely for error checking, see below
  GIF2 := TGIFImage.Create;

  if OpenPictureDialog1.Execute then begin
  filenameofPic:= OpenPictureDialog1.FileName;
  GIF.LoadFromFile(filenameofPic);

  try
       Image1.Picture.Bitmap.Assign(GIF);

        Image1.Picture.Bitmap.PixelFormat := pf24bit;

        try
         Gif2.Assign(Image1.Picture.Bitmap);
         except
        //if the bitmap is not 250 color indexed, convert it :) Joy!
        Image1.Picture.Bitmap.ReleasePalette;
        PaletteHandle := CreateOptimizedPaletteForSingleBitmap(Image1.Picture.Bitmap, 6);
        Image1.Picture.Bitmap.Palette := CopyPalette(PaletteHandle);
         end;


       finally
        Gif.Free;
        Gif2.Free;
      end;
     
  end;

    maxSize := (Image1.Picture.Width*Image1.Picture.Height div 8) - Length(Signature);
    maxSize := maxSize - round(maxSize*0.3);
    Label1.Caption:='(Max. size: '+IntToStr(maxSize)+')';

  if ExtractSteganography(Image1.Picture.Bitmap, Tmp, true) = true then
  DecryptBMP;

  lblImageFile.Caption :=filenameofPic;

  Label1.Enabled:=Assigned(Image1.Picture);
end;

procedure TForm1.btnEncryptClick(Sender: TObject);
var
SIGNATURE:WideString;
GIF: TGIFImage;
begin

 if Assigned(Image1.Picture) = true then
 begin
   SIGNATURE:= WideEdit2.text;
   mmMessage.Clear;
   getHTMLsource;
   InsertSteganography(Image1.Picture.Bitmap, SIGNATURE+encryptHTML(mmMessage.Text));
   DecryptBMP;

  if lblImageFile.Caption ='empty' then
  begin
  exit;
  end;
    //save to gif

  GIF := TGIFImage.Create;
  try
    GIF.ColorReduction := rmNone;
    GIF.DitherMode := dmNearest;
    try
    GIF.Assign(Image1.Picture.Bitmap);
    GIF.SaveToFile(lblImageFile.Caption);
   except
   //gif will have too many colors at times for our purposes
    GIF.ColorReduction := rmWindows256;
    GIF.DitherMode := dmNearest;
    GIF.Assign(Image1.Picture.Bitmap);


    end;
       GIF.SaveToFile(lblImageFile.Caption);

  finally
    GIF.Free;
  end;
  end;

end;

procedure Tform1.DecryptBMP;
var
  Tmp: string;
begin
  if ExtractSteganography(Image1.Picture.Bitmap, Tmp) then
  begin

    TntMemo1.Clear;
    TntMemo1.Text:=Tmp;
    TntMemo1.Text := decryptHTML(tntMemo1.Text);

  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin

 webbrowser1.GoForward;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  webbrowser1.GoBack;
end;

procedure TForm1.GetHTMLSource;
var
PSI: IPersistStreamInit;
Buf : TMemoryStream;
i : integer;
begin
    //  Change links to static in HTML Source and push to memo

 if webbrowser1.Document <> nil then
 begin
  webbrowser1.OleObject.Document.designMode := 'On';
  while (webbrowser1.readystate <> READYSTATE_COMPLETE) do Application.ProcessMessages;

    for i:=0 to (webbrowser1.OleObject.Document.All.tags('IMG').length-1) do
    begin
     if pos(webbrowser1.OleObject.Document.location.href,webbrowser1.OleObject.Document.All.tags('IMG').item(i).src) <> 0 then
      webbrowser1.OleObject.Document.All.tags('IMG').item(i).src := webbrowser1.OleObject.Document.All.tags('IMG').item(i).src;
    end;

    for i:=0 to (webbrowser1.OleObject.Document.All.tags('SCRIPT').length-1) do
    begin
     if pos(webbrowser1.OleObject.Document.location.href,webbrowser1.OleObject.Document.All.tags('SCRIPT').item(i).src) <> 0 then
      webbrowser1.OleObject.Document.All.tags('IMG').item(i).src := webbrowser1.OleObject.Document.All.tags('SCRIPT').item(i).src;
    end;

   end;
  Buf := TMemoryStream.Create;
  PSI := IHTMLDocument2( WebBrowser1.Document ) as IPersistStreamInit;


  if Succeeded( PSI.Save( TStreamAdapter.Create(Buf),LongBool(True) ) ) then
  begin
     Buf.Position := 0;
     mmMessage.Lines.LoadFromStream(Buf);
  end;
  Buf.Free;
  webbrowser1.OleObject.Document.designMode := 'Off';

end;

procedure TForm1.webbrowser1DocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin


 //Scan for GIF images in document
  scanforGIF;
  urlBar.Items.Add(url);
  StatusBar1.SimpleText := 'Done';
  statusbar3.SimpleText := 'Internet Mode';

end;



procedure TForm1.EncryptMessageClick(Sender: TObject);
var
SIGNATURE:WideString;
GIF: TGIFImage;
begin

 if Assigned(Image1.Picture) = true then
 begin
   SIGNATURE:= WideEdit2.text;
   InsertSteganography(Image1.Picture.Bitmap, SIGNATURE+encryptHTML(mmMessage.Text));
   DecryptBMP;

     if lblImageFile.Caption ='empty' then
  begin
  exit;
  end;

     GIF := TGIFImage.Create;
  try

    GIF.ColorReduction := rmNone;
    GIF.DitherMode := dmNearest;
    try
    GIF.Assign(Image1.Picture.Bitmap);
    GIF.SaveToFile(lblImageFile.Caption);
   except
   //gif will have too many colors at times for our purposes
    GIF.ColorReduction := rmWindows256;
    GIF.DitherMode := dmNearest;
    GIF.Assign(Image1.Picture.Bitmap);


    end;
       GIF.SaveToFile(lblImageFile.Caption);

  finally
    GIF.Free;
  end;
  end;
end;

procedure TForm1.scanforGIF;
var
i:integer;
i2:integer;
TMP:string;
GIF: TGIFImage;
GIF2: TGIFImage;
fileNameX:string;
begin
//Scan for gifs in webpage and post to lisbox

StatusBar1.SimpleText := 'Scanning for Gifs';
 if webbrowser1.Document <> nil then
 begin
 try
 for i:=0 to (webbrowser1.OleObject.Document.All.tags('IMG').length-1) do
 begin


 if pos('.gif', webbrowser1.OleObject.Document.All.tags('IMG').item(i).src) > 0 then
 begin

  Label8.caption := inttostr(strtoint(label8.caption) + 1);

  GIF := TGIFImage.Create;
  //this one is merely for error checking, see below
  GIF2 := TGIFImage.Create;

  //get cache link info for gif in question
  IECache1.GetEntryInfo(webbrowser1.OleObject.Document.All.tags('IMG').item(i).src);


  if IECache1.EntryInfo.LocalFileName <> '' then
  begin

  //local file
  if pos('file:',webbrowser1.OleObject.Document.All.tags('IMG').item(i).src) <> 0 then
  begin
   fileNameX := webbrowser1.OleObject.Document.All.tags('IMG').item(i).src;
   delete(fileNameX,1,8);
   fileNameX := decodeUrl(fileNameX);
  end;

  //not a local file
  if pos('file:',webbrowser1.OleObject.Document.All.tags('IMG').item(i).src) = 0 then
  begin
   fileNameX := IECache1.EntryInfo.LocalFileName;
  end;

     GIF.LoadFromFile(fileNameX);
   try
       Image2.Picture.Bitmap.Assign(GIF);  { or Bitmap.Assign(GIF.Bitmap); }

        Image2.Picture.Bitmap.PixelFormat := pf24bit;

        try
         Gif2.Assign(Image2.Picture.Bitmap);
         except
        //if the bitmap is not 250 color indexed, convert it :) Joy!
        Image2.Picture.Bitmap.ReleasePalette;
        PaletteHandle := CreateOptimizedPaletteForSingleBitmap(Image2.Picture.Bitmap, 6);
        Image2.Picture.Bitmap.Palette := CopyPalette(PaletteHandle);
         end;


       finally
        Gif.Free;
        Gif2.Free;
      end;

      //if we already have this stegged gif in our list, skip it
  for i2:=0 to (gifBox.Items.Count-1) do
  if webbrowser1.OleObject.Document.All.tags('IMG').item(i).src =
   gifBox.Items.Strings[i2] then exit;



 if ExtractSteganography(image2.Picture.Bitmap, TMP, true) = true then
 gifBox.Items.Add(webbrowser1.OleObject.Document.All.tags('IMG').item(i).src);

 end;
 end;

 end;
  except
 //generally, for local file stuff
 //ignore
 exit;
 end;
 end;

end;

function TForm1.GetTempDir: string;
begin
  SetLength(Result, GetTempPath(0, nil));
  GetTempPath(Length(Result), @Result[1]);
end;


procedure TForm1.mmMessageChange(Sender: TObject);
begin
//calculate size of stegged message
   if mmMessage.GetTextLen > 0 then
   begin
    label3.Caption := '(Actual Size: ' + inttostr(mmMessage.GetTextLen) +')';
    label3.Enabled := true;
   end;

    if mmMessage.GetTextLen = 0 then
    begin
    label3.Caption := '(Actual Size: )';
    label3.enabled :=false;
    end;

end;

procedure TForm1.gifBoxClick(Sender: TObject);
var
fileNameX:string;
Tmp:string;
SIGNATURE:WideString;
GIF: TGIFImage;
GIF2: TGIFImage;
maxSize: integer;
begin
 //load image, decrypt, and show
    fileNameX :='';


 If gifBox.Items.Count>0 then
  IECache1.GetEntryInfo(gifBox.Items[gifBox.Itemindex])
  else
  exit;

    label1.caption:='(Max. Message Size: )';
  label3.Caption:='(Actual Message Size: )';
  Image1.Picture := nil;

  SIGNATURE:= WideEdit2.text;
  tntmemo1.Clear;

   //parse differently if local file or not
   if pos('file:',gifBox.Items[gifBox.Itemindex]) = 0 then
  fileNameX := IECache1.EntryInfo.LocalFileName
  else
  begin
   fileNameX := gifBox.Items[gifBox.Itemindex];
   delete(fileNameX,1,8);
   fileNameX := decodeUrl(fileNameX);
   end;

  GIF := TGIFImage.Create;
  //this one is merely for error checking, see below
  GIF2 := TGIFImage.Create;

    GIF.LoadFromFile(fileNameX);

  try
       Image1.Picture.Bitmap.Assign(GIF);  { or Bitmap.Assign(GIF.Bitmap); }

        Image1.Picture.Bitmap.PixelFormat := pf24bit;

        try
         Gif2.Assign(Image1.Picture.Bitmap);
         except
        //if the bitmap is not 250 color indexed, convert it :) Joy!
        Image1.Picture.Bitmap.ReleasePalette;
        PaletteHandle := CreateOptimizedPaletteForSingleBitmap(Image1.Picture.Bitmap, 6);
        Image1.Picture.Bitmap.Palette := CopyPalette(PaletteHandle);
         end;


       finally
        Gif.Free;
        Gif2.Free;
      end;

    maxSize := (Image1.Picture.Width*Image1.Picture.Height div 8) - Length(Signature);
    maxSize := maxSize - round(maxSize*0.3);
    Label1.Caption:='(Max. size: '+IntToStr(maxSize)+')';

  if ExtractSteganography(Image1.Picture.Bitmap, Tmp, true) = true then
  DecryptBMP;
  //Parse HTML
  parseHTML;

  lblImageFile.Caption :=filenameX;
  Label1.Enabled:=Assigned(Image1.Picture);



end;

procedure TForm1.parseHTML;
var
Doc: IHTMLDocument2;
v:variant;
Element : iHTMLElement;

begin
//take Memo contents and parse in webbrowser

 //first, if no links is checked, kill link download

 if HighSecurityGIFBrowsing1.Checked then
 begin
 webbrowser1.DownloadOptions:=webbrowser1.DownloadOptions
 - [DLCTL_DLIMAGES,DLCTL_VIDEOS,DLCTL_BGSOUNDS]
 + [DLCTL_NO_CLIENTPULL, DLCTL_NO_BEHAVIORS, DLCTL_NO_DLACTIVEXCTLS, DLCTL_NO_JAVA, DLCTL_NO_RUNACTIVEXCTLS,DLCTL_NO_SCRIPTS];

 end;

 Doc := webbrowser1.Document as IHTMLDocument2;
 //Doc.designMode := 'On';

 Element := Doc.Get_body;
 Element := nil;

   v := VarArrayCreate([0, 0], varVariant);
  v[0] := tntmemo1.Text; // Here's your HTML string
  Doc.Write(PSafeArray(TVarData(v).VArray));

  Doc.Close;
  statusbar3.SimpleText:='Camera/Shy Mode';


end;


procedure TForm1.Button5Click(Sender: TObject);
var
GIF: TGIFImage;
begin
      if lblImageFile.Caption ='empty' then
  begin
    mmMessage.Clear;
  tntmemo1.Clear;
  exit;
  end;
  GIF := TGIFImage.Create;
  try

    GIF.ColorReduction := rmNone;
    GIF.DitherMode := dmNearest;
    try
    GIF.Assign(Image1.Picture.Bitmap);
    GIF.SaveToFile(lblImageFile.Caption);
   except
   //gif will have too many colors at times for our purposes
    GIF.ColorReduction := rmWindows256;
    GIF.DitherMode := dmNearest;
    GIF.Assign(Image1.Picture.Bitmap);


    end;
       GIF.SaveToFile(lblImageFile.Caption);

  finally
    GIF.Free;
  end;
    label1.caption:='(Max. Message Size: )';
  label3.Caption:='(Actual Message Size: )';
  Image1.Picture := nil;
  lblImageFile.Caption :='empty';
  mmMessage.Clear;
  tntmemo1.Clear;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  DecryptBMP;

end;

procedure TForm1.Button6Click(Sender: TObject);
begin
    parseHTML;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
 webbrowser1.Refresh;
end;



procedure TForm1.IETravelLog1Entry(Title, Url: String;
  var Cancel: Boolean);
begin


  //code for back and forward button
  PopUpItems[itemsCounter] := TMenuItem.Create(Self);
  PopUpItems[itemsCounter].Caption := Title;
  PopUpItems[itemsCounter].Hint := Url;
  PopUpItems[itemsCounter].OnClick := MyPopUpHandler;
  PopUpMenu1.Items.Add(PopUpItems[itemsCounter]);
  Inc(ItemsCounter);
  if ItemsCounter = 10 then Cancel := True;
end;

procedure TForm1.webbrowser1CommandStateChange(Sender: TObject;
  Command: Integer; Enable: WordBool);
begin

     if Command = CSC_NAVIGATEFORWARD then
     begin
    ForwardButton.Enabled := Enable;
       //yes, these routines create the pop-up menu, etc
        if ForwardButton.Enabled = true then
        begin
        ItemsCounter := 0;
        popupmenu1.Items.Clear;
        ietravellog1.EnumerateForward;
        Back := False;
        end;
    end;

    if Command = CSC_NAVIGATEBACK then
    begin
    BackButton.Enabled := Enable;
    // ietravellog1.EnumerateBack;

        if BackButton.Enabled = true then
        begin
        ItemsCounter := 0;
        popupmenu1.Items.Clear;
        ietravellog1.EnumerateBack;
        Back := True;
        end;
    end;


end;

procedure TForm1.FormShow(Sender: TObject);
begin
  webbrowser1.AssignDocument;
  webbrowser1.GoHome;
  IETravellog1.Connect;
 

end;

procedure TForm1.MyPopupHandler(Sender: TObject);
var
  index: Integer;
begin
  with Sender as TMenuItem do
    if back then
      Index := 0 - popupmenu1.Items.IndexOf(Sender as TmenuItem) - 1
    else
      Index := popupmenu1.Items.IndexOf(Sender as TmenuItem) + 1;
  IETravelLog1.TravelTo(Index);
end;

function TForm1.encryptHTML(encryptString:string):string;
var
  Cipher: TDCP_rijndael;
begin
//  encrypt string
   if encryptString = '' then
   exit;

Cipher:= TDCP_rijndael.Create(nil);
    Cipher.InitStr(WideEdit3.Text);
   // Cipher.EncryptCBC(Buffer,Buffer,Sizeof(Buffer));
    Cipher.EncryptCBC(encryptString[1],encryptString[1],Length(encryptString));
    result := base64.Encode(encryptString);
    Cipher.Burn;  { Erase key information }
    Cipher.Free;



end;

function TForm1.decryptHTML(decryptString:string):string;
var
  Cipher: TDCP_rijndael;
begin
//  encrypt string
   if decryptString = '' then
   exit;

   decryptString := base642.DecodeString(decryptString);
   
Cipher:= TDCP_rijndael.Create(nil);
    Cipher.InitStr(WideEdit3.Text);
    //Cipher.decryptCBC(Buffer,Buffer,Sizeof(Buffer));
    Cipher.decryptCBC(decryptString[1],decryptString[1],Length(decryptString));
    result:= decryptString;
    Cipher.Burn;  { Erase key information }
    Cipher.Free;

end;




procedure TForm1.webbrowser1ScriptError(Sender: TObject; ErrorLine,
  ErrorCharacter, ErrorCode, ErrorMessage, ErrorUrl: String;
  var ContinueScript, Showdialog: Boolean);
begin
 Showdialog := false;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  wideedit2.PasswordChar:='*';
  wideedit3.PasswordChar:='*';
  SessionStart := Now;
  ShowGIFScreen1.Click;
  SilentHistoryOn;
  PaletteHandle := CreateHalftonePalette(0);
end;

procedure TForm1.HighSecurityWebbrowsing1Click(Sender: TObject);
begin
 if HighSecurityWebbrowsing1.Checked then
 HighSecurityWebbrowsing1.Checked := false
 else
 HighSecurityWebbrowsing1.Checked := true;

  //if high security web browsing, then...
  if HighSecurityWebBrowsing1.Checked then
 begin
 webbrowser1.DownloadOptions:=webbrowser1.DownloadOptions
 - [DLCTL_DLIMAGES,DLCTL_VIDEOS,DLCTL_BGSOUNDS]
 + [DLCTL_NO_CLIENTPULL, DLCTL_NO_BEHAVIORS, DLCTL_NO_DLACTIVEXCTLS, DLCTL_NO_JAVA, DLCTL_NO_RUNACTIVEXCTLS,DLCTL_NO_SCRIPTS];

 end;

 //unchecked, so we shut it off here
 if HighSecurityWebBrowsing1.Checked =false then
 begin
 webbrowser1.DownloadOptions:=webbrowser1.DownloadOptions
  - [DLCTL_NO_CLIENTPULL, DLCTL_NO_BEHAVIORS, DLCTL_NO_DLACTIVEXCTLS, DLCTL_NO_JAVA, DLCTL_NO_RUNACTIVEXCTLS,DLCTL_NO_SCRIPTS]
  + [DLCTL_DLIMAGES,DLCTL_VIDEOS,DLCTL_BGSOUNDS];


 end;
 
end;

procedure TForm1.HighSecurityGIFBrowsing1Click(Sender: TObject);
begin
 if HighSecurityGIFBrowsing1.Checked then
 HighSecurityGIFBrowsing1.Checked := false
 else
 HighSecurityGIFBrowsing1.Checked := true;
end;

procedure TForm1.HelpFile1Click(Sender: TObject);
begin
 FAQform.show;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
 showmessage('Camera/Shy Produced by Hacktivismo' + #10#13 +
 'Created by thePull' + #10#13 +
 'Further Credits:' + #10#13 +
 'Without these guys, C/S would not have been possible.'+ #10#13 +
 'StoneFisk - Research, QA, test sites' + #10#13 +
 'Genetix - Graphics Consulting, QA, Docs, test sites' + #10#13 +
 'Saboteur - QA, test sites' + #10#13 +
 'Zax - QA, test sites' +  #10#13 +
 'Novice222 - the perfunctory air traffic controller' + #10#13 +
 'Persons Unknown - QA, test sites' + #10#13 + #10#13 +
 'Version: Inaugural Edition, 0.2.22 Beta');
end;

procedure TForm1.ShowGIFScreen1Click(Sender: TObject);
begin
 if ShowGIFScreen1.Checked then
 ShowGIFScreen1.Checked := false
 else
 ShowGIFScreen1.Checked := true;
   //maximize browser, hide everything else
 if ShowGIFScreen1.Checked then
 begin
 panel1.Visible := false;
 panel2.Width := form1.Width-10;
 gifbox.Width := form1.Width-10;

 end;

  //show gif screen, return browser to mid screen
 if ShowGIFScreen1.Checked = false then
 begin
 panel1.Visible := true;
 form1.Width := 742;
 form1.Height := 594;
 panel2.Width := 449;
 end;

end;

procedure TForm1.urlBarKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

   if Key = VK_Return then
  begin

  //no trust is for running from bmp only, reverse settings, no need
 //to check if they exist for now  -- doing this here instead of beforenavigate
 //seems to work well (beforenavigate is called when viewing from cache as well)
 if HighSecurityGIFBrowsing1.Checked then
 begin
 webbrowser1.DownloadOptions:=webbrowser1.DownloadOptions
 + [DLCTL_DLIMAGES,DLCTL_VIDEOS,DLCTL_BGSOUNDS]
 - [DLCTL_NO_CLIENTPULL, DLCTL_NO_BEHAVIORS, DLCTL_NO_DLACTIVEXCTLS, DLCTL_NO_JAVA, DLCTL_NO_RUNACTIVEXCTLS,DLCTL_NO_SCRIPTS];
 end;

  webbrowser1.go(urlBar.Text);
  end;
end;

procedure TForm1.StopButtonClick(Sender: TObject);
begin
 webbrowser1.Stop;
end;

procedure TForm1.BackButtonClick(Sender: TObject);
begin
 webbrowser1.GoBack;

end;

procedure TForm1.RefreshButtonClick(Sender: TObject);
begin
     webbrowser1.Refresh;
end;

procedure TForm1.EncryptWBButtonClick(Sender: TObject);
var
SIGNATURE:WideString;
GIF: TGIFImage;
begin

 if Assigned(Image1.Picture) = true then
 begin
   SIGNATURE:= WideEdit2.text;
   mmMessage.Clear;
   getHTMLsource;
   InsertSteganography(Image1.Picture.Bitmap, SIGNATURE+encryptHTML(mmMessage.Text));
   DecryptBMP;

 if lblImageFile.Caption ='empty' then
  begin
  exit;
  end;

   GIF := TGIFImage.Create;
  try

    GIF.ColorReduction := rmNone;
    GIF.DitherMode := dmNearest;
    try
    GIF.Assign(Image1.Picture.Bitmap);
    GIF.SaveToFile(lblImageFile.Caption);
   except
   //gif will have too many colors at times for our purposes
    GIF.ColorReduction := rmWindows256;
    GIF.DitherMode := dmNearest;
    GIF.Assign(Image1.Picture.Bitmap);


    end;
       GIF.SaveToFile(lblImageFile.Caption);

  finally
    GIF.Free;
  end;

 end;
end;

procedure TForm1.ForwardButtonClick(Sender: TObject);
begin
  webbrowser1.GoForward;
end;

procedure TForm1.webbrowser1NavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
 urlBar.Text := webbrowser1.LocationURL;
end;

procedure TForm1.ToolButton2Click(Sender: TObject);
var
  Tmp: string;
  SIGNATURE:WideString;
  filenameofPic:string;
     GIF: TGIFImage;
  GIF2: TGIFImage;
 maxSize:integer;
begin
SIGNATURE:= '['+WideEdit2.text+']';
        tntmemo1.Clear;
  GIF := TGIFImage.Create;
  //this one is merely for error checking, see below
  GIF2 := TGIFImage.Create;

  if OpenPictureDialog1.Execute then begin
  filenameofPic:= OpenPictureDialog1.FileName;
  GIF.LoadFromFile(filenameofPic);

  try
      Image1.Picture.Bitmap.Assign(GIF.Bitmap);
       Image1.Picture.Bitmap.PixelFormat := pf24bit;

        try
         Gif2.Assign(Image1.Picture.Bitmap);
         except
        //if the bitmap is not 250 color indexed, convert it :) Joy!
        Image1.Picture.Bitmap.ReleasePalette;
        PaletteHandle := CreateOptimizedPaletteForSingleBitmap(Image1.Picture.Bitmap, 6);
        Image1.Picture.Bitmap.Palette := CopyPalette(PaletteHandle);
         end;



       finally
        Gif.Free;
        Gif2.Free;
      end;
  end;

    maxSize := (Image1.Picture.Width*Image1.Picture.Height div 8) - Length(Signature);
    maxSize := maxSize - round(maxSize*0.3);
    Label1.Caption:='(Max. size: '+IntToStr(maxSize)+')';
  
  if ExtractSteganography(Image1.Picture.Bitmap, Tmp, true) = true then
  DecryptBMP;

  lblImageFile.Caption :=filenameofPic;
  //btnEncrypt.Enabled:=Assigned(Image1.Picture);
  Label1.Enabled:=Assigned(Image1.Picture);

end;

procedure TForm1.ToolButton3Click(Sender: TObject);
var
GIF: TGIFImage;
begin
  if lblImageFile.Caption ='empty' then
  begin
    mmMessage.Clear;
  tntmemo1.Clear;
  exit;
  end;

       GIF := TGIFImage.Create;
  try

    GIF.ColorReduction := rmNone;
    GIF.DitherMode := dmNearest;
    try
    GIF.Assign(Image1.Picture.Bitmap);
    GIF.SaveToFile(lblImageFile.Caption);
   except
   //gif will have too many colors at times for our purposes
    GIF.ColorReduction := rmWindows256;
    GIF.DitherMode := dmNearest;
    GIF.Assign(Image1.Picture.Bitmap);


    end;
       GIF.SaveToFile(lblImageFile.Caption);

  finally
    GIF.Free;
  end;
  label1.caption:='(Max. Message Size: )';
  label3.Caption:='(Actual Message Size: )';
  Image1.Picture := nil;
  lblImageFile.Caption :='empty';
  mmMessage.Clear;
  tntmemo1.Clear;

end;

procedure TForm1.ToolButton8Click(Sender: TObject);
begin
  DecryptBMP;

end;

procedure TForm1.ToolButton9Click(Sender: TObject);
begin
    parseHTML;
end;

procedure TForm1.No1Click(Sender: TObject);
begin
 if No1.Checked then
 No1.Checked := false
 else
 No1.Checked := true;

  //if high security web browsing, then...
  if No1.Checked then
 begin
 webbrowser1.DownloadOptions:=webbrowser1.DownloadOptions
 - [DLCTL_DLIMAGES,DLCTL_VIDEOS,DLCTL_BGSOUNDS,DLCTL_NO_CLIENTPULL]
 + [DLCTL_NO_BEHAVIORS, DLCTL_NO_DLACTIVEXCTLS, DLCTL_NO_JAVA, DLCTL_NO_RUNACTIVEXCTLS,DLCTL_NO_SCRIPTS];


 end;

 //unchecked, so we shut it off here
 if No1.Checked =false then
 begin
 webbrowser1.DownloadOptions:=webbrowser1.DownloadOptions
  - [DLCTL_NO_BEHAVIORS, DLCTL_NO_DLACTIVEXCTLS, DLCTL_NO_JAVA, DLCTL_NO_RUNACTIVEXCTLS,DLCTL_NO_SCRIPTS]
  + [DLCTL_DLIMAGES,DLCTL_VIDEOS,DLCTL_BGSOUNDS];
 end;

end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 //clear cache
  if IECache1.FindFirstEntry(0) = S_OK
  then begin
   if IECache1.EntryInfo.LastAccessTime > SessionStart then
   IECache1.DeleteEntry(IECache1.EntryInfo.SourceUrlName);
  try
   while IECache1.FindNextEntry = S_OK do
     if IECache1.EntryInfo.LastAccessTime > SessionStart then
     IECache1.DeleteEntry(IECache1.EntryInfo.SourceUrlName);
  except
  //do nothing, this is to continue in case of bad dates
  //otherwise cache deleting gets stuck and we can't have that
  end;
  end;
IECache1.CloseFindEntry;

SilentHistoryOff;

end;

procedure TForm1.SilentHistoryOn;
var
CacheReg: TRegistry;
begin
 //this turns off history when running

  CacheReg        := TRegistry.Create;
  CacheReg.RootKey:= HKEY_CURRENT_USER;
  CacheReg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Internet Settings\5.0\Cache\Extensible Cache\UserData',true);
  CacheReg.WriteInteger('CacheLimit',0);
  CacheReg.CloseKey;
  CacheReg.Free;

end;

procedure TForm1.SilentHistoryOff;
var
CacheReg: TRegistry;
begin
 //this turns on history when closing out

  CacheReg        := TRegistry.Create;
  CacheReg.RootKey:= HKEY_CURRENT_USER;
  CacheReg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Internet Settings\5.0\Cache\Extensible Cache\UserData',true);
 //good enough value
  CacheReg.WriteInteger('CacheLimit',$3e8);
  CacheReg.CloseKey;
  CacheReg.Free;

end;



procedure TForm1.BMPGIF1Click(Sender: TObject);
begin
   form3.Show;
end;

procedure TForm1.urlBarSelect(Sender: TObject);
begin
  //no trust is for running from bmp only, reverse settings, no need
 //to check if they exist for now  -- doing this here instead of beforenavigate
 //seems to work well (beforenavigate is called when viewing from cache as well)
 if HighSecurityGIFBrowsing1.Checked then
 begin
 webbrowser1.DownloadOptions:=webbrowser1.DownloadOptions
 + [DLCTL_DLIMAGES,DLCTL_VIDEOS,DLCTL_BGSOUNDS]
 - [DLCTL_NO_CLIENTPULL, DLCTL_NO_BEHAVIORS, DLCTL_NO_DLACTIVEXCTLS, DLCTL_NO_JAVA, DLCTL_NO_RUNACTIVEXCTLS,DLCTL_NO_SCRIPTS];
 end;

  webbrowser1.go(urlBar.Text);
 
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
     DeleteObject(PaletteHandle);
end;

procedure TForm1.WideEdit3Change(Sender: TObject);
begin
 if MaskPassword.Checked then
 WideEdit3.PasswordChar := '*';
end;

procedure TForm1.WideEdit2Change(Sender: TObject);
begin
 if MaskPassword.Checked then
 WideEdit2.PasswordChar := '*';
end;

procedure TForm1.Read1Click(Sender: TObject);
begin
 showmessage('Dedicated to the memory of Wang Ruowang, former ' +
  'doyen of the Chinese dissident community, a study in courage,' +
  ' and a lamp unto our feet.' + #10 + #13 + #10 + #13 +'http://www.tibet.ca/wtnarchive/2001/12/31_1.html');
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
 //clear text in image
 mmMessage.Lines.Clear;
 encryptMessage.Click;

end;

procedure TForm1.webbrowser1StatusTextChange(Sender: TObject;
  const Text: WideString);
begin
 //need an unicode status bar
 statusbar1.SimpleText := string(Text);
end;

procedure TForm1.webbrowser1NewWindow2(Sender: TObject;
  var ppDisp: IDispatch; var Cancel: WordBool);
begin
  //does anybody really need pop-up's?
  if KillPopups1.Checked then
    Cancel := True;
end;

procedure TForm1.KillPopups1Click(Sender: TObject);
begin
   if KillPopups1.Checked then
 KillPopups1.Checked := false
 else
 KillPopups1.Checked := true;

end;

procedure TForm1.webbrowser1SetSecureLockIcon(Sender: TObject;
  SecureLockIcon: Integer);
begin

  if SecureLockIcon = 0 then
  statusBar2.SimpleText := 'Unsecure';
    if SecureLockIcon = 1 then
  statusBar2.SimpleText := 'Multiple Encryption';
    if SecureLockIcon = 2 then
  statusBar2.SimpleText := 'Secure Unknown Level';
    if SecureLockIcon = 3 then
  statusBar2.SimpleText := 'Secure 40 bits';
    if SecureLockIcon = 4 then
  statusBar2.SimpleText := 'Secure 56 bits';
    if SecureLockIcon = 5 then
  statusBar2.SimpleText := 'Secure Fortezza';
    if SecureLockIcon = 6 then
  statusBar2.SimpleText := 'Secure 128 bits';
end;

procedure TForm1.webbrowser1TitleChange(Sender: TObject;
  const Text: WideString);
begin
 form1.Caption := string(Text)+' - Camera/Shy';
end;

Function TForm1.DecodeURL(Const Str : String) : String;
Var l, p : Integer;
Begin
  Result := '';
  l := Length(Str);
  p := 1;
  While p <= l Do
   Begin
     If (Str[p] = '%') And (p < l-1) Then
      Begin
        Result := Result + Char(StrToInt('$'+Str[p+1]+Str[p+2]));
        Inc(p, 3);
      End
     Else
      Begin
        Result := Result + Str[p];
        Inc(p);
      End;
   End;
End;

procedure TForm1.JPEGBMP1Click(Sender: TObject);
begin
   Form4.Show;
end;

procedure TForm1.MaskPasswordClick(Sender: TObject);
begin
 if MaskPassword.Checked = false then
 begin
 MaskPassword.Checked := true;
 wideedit3.PasswordChar :='*';
 wideedit2.PasswordChar :='*';
 end
 else
 begin
 MaskPassword.Checked := false;
 wideedit3.PasswordChar :=#00;
 wideedit2.PasswordChar :=#00;
 end;
end;

end.
