unit gif2jpeg;
          {Camera/Shy the Steganographical Browser
Copyright (C) 2002  cDc-Communications through Hacktivismo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Mask, ToolEdit, JPEG, gifimage;

type
  TForm4 = class(TForm)
    Label1: TLabel;
    FilenameEdit1: TFilenameEdit;
    Edit2: TEdit;
    FilenameEdit2: TFilenameEdit;
    Label2: TLabel;
    Edit1: TEdit;
    Label4: TLabel;
    Label3: TLabel;
    GIFtoJPEG: TButton;
    JPEGtoGIF: TButton;
    procedure JPEGtoGIFClick(Sender: TObject);
    procedure GIFtoJPEGClick(Sender: TObject);
    function cleanseQuotes(filename:string):string;
  private
    { Private declarations }

  public
    { Public declarations }
  end;

var
  Form4: TForm4;

implementation

{$R *.dfm}

procedure TForm4.JPEGtoGIFClick(Sender: TObject);
var
  GIF: TGIFImage;
  JPEG: TJPEGImage;
begin
  //save to gif
   GIF := TGIFImage.Create;
  JPEG := TJPEGImage.Create;

  try
    filenameEdit1.Text := cleanseQuotes(filenameEdit1.Text);
    JPEG.LoadFromFile(filenameEdit1.Text);

    GIF.ColorReduction := rmNone;
    GIF.DitherMode := dmNearest;
   try

    GIF.Assign(JPEG);
   except
   //gif will have too many colors at times for our purposes
    GIF.ColorReduction := rmWindows256;
    GIF.DitherMode := dmNearest;
    GIF.Assign(JPEG);


    end;
       GIF.SaveToFile(Edit2.Text);
  finally
    JPEG.Free;
    GIF.Free;
  end;


end;

procedure TForm4.GIFtoJPEGClick(Sender: TObject);
var
  GIF: TGIFImage;
  JPEG: TJPEGImage;
  GIF2: TGIFImage;
   Bitmap:  TBitmap;
begin

  GIF := TGIFImage.Create;
  //this one is merely for error checking, see below
  GIF2 := TGIFImage.Create;
  filenameEdit2.Text := cleanseQuotes(filenameEdit2.Text);
  GIF.LoadFromFile(filenameEdit2.Text);

      JPEG := TJPEGImage.Create;
      Bitmap := TBitmap.Create;

      try
       Bitmap.Assign(GIF);
             //now change jpeg to bmp for conversion

     GIF.ColorReduction := rmNone;
     GIF.DitherMode := dmNearest;

        try
        JPEG.Assign(Bitmap);



        JPEG.SaveToFile(Edit1.Text);

        except
        raise;
        end;
      finally
        JPEG.Free;
        Gif.Free;
        Gif2.Free;
        bitmap.Free;
      end;


end;


function TForm4.cleanseQuotes(filename:string):string;
var
s:integer;
begin
  //cleanse quotes. What can I say? I like the component but it
  //isn't opensource
  s:=pos('"',filename);
  delete(filename,s,1);
  //I don't need no stinkin checks
  s:=pos('"',filename);
  delete(filename,s,1);

  result:=filename;

end;



end.
