unit gif2Bmp;
         {Camera/Shy the Steganographical Browser
Copyright (C) 2002  cDc-Communications through Hacktivismo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Mask, ToolEdit, gifimage, PaletteLibrary;

type
  TForm3 = class(TForm)
    Edit2: TEdit;
    Label1: TLabel;
    FilenameEdit1: TFilenameEdit;
    Label2: TLabel;
    BMP2GIF: TButton;
    FilenameEdit2: TFilenameEdit;
    Label3: TLabel;
    Label4: TLabel;
    Edit1: TEdit;
    GIF2BMP: TButton;
    procedure BMP2GIFClick(Sender: TObject);
    procedure GIF2BMPClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    function cleanseQuotes(filename:string):string;
  private
    { Private declarations }
    PaletteHandle:  hPalette;
  public
    { Public declarations }

  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

procedure TForm3.BMP2GIFClick(Sender: TObject);
var
  GIF: TGIFImage;
  Bitmap: TBitmap;
begin
  //save to gif
   GIF := TGIFImage.Create;
  Bitmap := TBitmap.Create;

  try
    filenameEdit1.Text := cleanseQuotes(filenameEdit1.Text);
    Bitmap.LoadFromFile(filenameEdit1.Text);

    GIF.ColorReduction := rmNone;
    GIF.DitherMode := dmNearest;
   try

    GIF.Assign(Bitmap);
   except
   //gif will have too many colors at times for our purposes
    GIF.ColorReduction := rmWindows256;
    GIF.DitherMode := dmNearest;
    GIF.Assign(Bitmap);


    end;
       GIF.SaveToFile(Edit2.Text);
  finally
    Bitmap.Free;
    GIF.Free;
  end;


end;

procedure TForm3.GIF2BMPClick(Sender: TObject);
var
  GIF: TGIFImage;
  Bitmap: TBitmap;
  GIF2: TGIFImage;
begin

  GIF := TGIFImage.Create;
  //this one is merely for error checking, see below
  GIF2 := TGIFImage.Create;
  filenameEdit2.Text := cleanseQuotes(filenameEdit2.Text);
  GIF.LoadFromFile(filenameEdit2.Text);

      Bitmap := TBitmap.Create;
      try
       Bitmap.Assign(GIF);  { or Bitmap.Assign(GIF.Bitmap); }

        Bitmap.PixelFormat := pf24bit;

        try
         Gif2.Assign(Bitmap);
         except
        //if the bitmap is not 250 color indexed, convert it :) Joy!
        Bitmap.ReleasePalette;
        PaletteHandle := CreateOptimizedPaletteForSingleBitmap(Bitmap, 6);
        Bitmap.Palette := CopyPalette(PaletteHandle);
         end;

        Bitmap.SaveToFile(Edit1.Text);
      finally
        Bitmap.Free;
        Gif.Free;
        Gif2.Free;
      end;


end;

procedure TForm3.FormDestroy(Sender: TObject);
begin
 DeleteObject(PaletteHandle);
end;

procedure TForm3.FormCreate(Sender: TObject);
begin
 PaletteHandle := CreateHalftonePalette(0);
end;

function TForm3.cleanseQuotes(filename:string):string;
var
s:integer;
begin
  //cleanse quotes. What can I say? I like the component but it
  //isn't opensource
  s:=pos('"',filename);
  delete(filename,s,1);
  //I don't need no stinkin checks
  s:=pos('"',filename);
  delete(filename,s,1);

  result:=filename;

end;

end.
