/*********************************************************************
  Scrambling routines

  part of: Hide4PGP by Heinz Repp
  last modified: 12/04/99
*********************************************************************/


#include "hide4pgp.h"
#include "scramble.h"


/*********************************************************************
  Scramble:  linear transform of Byte = 8-bit vector after addition of
             previous encoded value (simple 'cipher block feedback')
  parameter: byte = input bitvector
  returns:   byte = output bitvector
*********************************************************************/

UBYTE Scramble (UBYTE BitVector)
{
  static UBYTE m[8] = {178, 155, 106, 39, 153, 116, 199, 89};
  static UBYTE r = 0;
  int i;

  BitVector ^= r;             /* 'CBF' mode */
  r = 105;
  for (i = 0; i < 8; i++)
    if (BitVector & (1u << i))
      r ^= m[i];

  return r;
}


/*********************************************************************
  DeScramble: reverse linear transform of Byte = 8-bit vector with
             successive addition of previous encoded value (CFB)
  parameter: byte = input bitvector
  returns:   byte = output bitvector
*********************************************************************/

UBYTE DeScramble (UBYTE BitVector)
{
  static UBYTE m[8] = {97, 18, 163, 186, 47, 216, 116, 228};
  static UBYTE last = 0;
  UBYTE r;
  int i;

  r = 119;
  for (i = 0; i < 8; i++)
    if (BitVector & (1u << i))
      r ^= m[i];

  r ^= last;
  last = BitVector;
  return r;
}


/*********************************************************************
  ResetScrambler: resets the internal registers of both Scramble and
             DeScramble routines to zero
  parameter: none
  returns:   nothing
*********************************************************************/

void ResetScrambler (void)
{
  UBYTE x;

  DeScramble (0);
  x = Scramble (x);
  Scramble (x ^ DeScramble (0));
}
