/*********************************************************************
  Routines for WAV-files
  support for 8, 12 and 16 bit samples (12 bit are treated as 16 bit)

  part of: Hide4PGP by Heinz Repp
  last modified: 12/13/99
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "hide4pgp.h"
#include "utils.h"


static long filelength, position;


/*********************************************************************
  skipto:    searches from byte offset stored in 'position' for
             specified subchunk, updates position to point behind
             current subchunk (word aligned)
  parameter: pointer to string with chunk type
  returns:   length, 0 if not found
             file read pointer points behind the chunk length entry
*********************************************************************/

UWORD32 skipto (char *subtype)
{
  UWORD32 length;
  int     found;

  while (position < filelength)
  {
    if (fseek (StegFile, position, SEEK_SET))
      UnexpEOF ();
    found = NextIs (subtype);
    length = GetStegLong ();
    position += length + 9 & ~1ul;  /* word aligned */
    if (found)
      return length;
  }
  return 0;
}


/*********************************************************************
  WAVNextBlock: advance read pointer to next data block
  parameter: none
  returns:   length of continous data block, 0L if none
*********************************************************************/

UWORD32 WAVNextBlock (void)
{
  return skipto ("data") / DataSize;
}


/*********************************************************************
  CheckIfWAV: check WAV file characteristics, optionally output
             specification data
  parameter: none
  returns:   data width flag, TRUE for 16 (or 12) bit, FALSE for 8
*********************************************************************/

int CheckIfWAV (UWORD32 (**NextBlockP) (void))
{
  WORD32  sample_fq;
  long    first, samples;
  int     bit_p_spl;

  if (! NextIs ("IFF") ||
      (filelength = GetStegLong (),
       ! NextIs ("WAVE")))
    return FALSE;

  if (verbose)
    fputs ("Microsoft RIFF / subtype WAVE format detected.\n", stderr);
  filelength += 8;
  position = 12;

  /* search the next format subchunk */
  if (skipto ("fmt ") == 0L)
    UnexpEOF ();

  if (GetStegWord () != 1)
    ErrorExit (WAVNOTPCM, "Error (WAV): Sound data not in PCM format.\n");

  if (verbose > 1)
    fprintf (stderr, "No. of channels  : %i\n", GetStegWord ());
  else
    GetStegWord ();
  sample_fq = GetStegLong ();
  if (verbose > 1)
    fprintf (stderr, "Sample frequency : %li Hz.\n", (long) sample_fq);
  fseek (StegFile, 6, SEEK_CUR);
  if ((bit_p_spl = GetStegWord ()) == 12 && hiding)
  {
    fseek (StegFile, -2L, SEEK_CUR);
    PutStegWord (bit_p_spl = 16);
    if (verbose)
      fputs ("Sample was 12 bit - changed to -> ", stderr);
  }
  if (verbose)
    fprintf (stderr, "Sample resolution: %i bit.\n", bit_p_spl);

  switch (bit_p_spl)
  {
    case 8:
      DataSize = 1;
      MaxBitsAllowed = 1;
      if (hiding)
        ModData = (void (*) (void *, size_t)) ModLBytes;
      else
        GetBits = GetBitsFromByte;
      break;

    case 16:
      DataSize = 2;
      MaxBitsAllowed = 4;
      if (hiding)
        ModData = (void (*) (void *, size_t)) ModLWords;
      else
        GetBits = GetBitsFromWord;
      break;

    default:
      ErrorExit (WAVRESNOTSUP, "Error (WAV): Sample resolution not supported.\n");
  }

  *NextBlockP = WAVNextBlock;

  /* sum up usable bytes in all blocks */
  first = position;
  while (samples = WAVNextBlock ())
    MediaLength += samples;
  position = first;

  return TRUE;
}
