/*
 * Compression routines for SNOW.
 * Uses simple Huffman coding.
 *
 * Written by Matthew Kwan - April 1997
 */

class SnowCompress extends BitFilter {
	private boolean		encode_flag = false;
	private BitFilter	next_filter = null;

	private int		value;
	private int		bit_count;
	private boolean		bit_array[];

	SnowCompress (boolean encode, BitFilter output) {
	    encode_flag = encode;
	    next_filter = output;

	    bit_count = 0;
	    value = 0;

	    if (!encode_flag)
		bit_array = new boolean[256];
	}

	public boolean		receive_bit (boolean bit) {
	    if (encode_flag) {
		value = (value << 1) | (bit ? 1 : 0);

		if (++bit_count == 8) {
		    boolean	s[] = huffcodes[value];

		    for (int i = 0; i < s.length; i++) {
			if (!next_filter.receive_bit (s[i]))
			    return (false);
		    }

		    value = 0;
		    bit_count = 0;
		}
	    } else {
		int	code;

		bit_array[bit_count++] = bit;

		if ((code = huffcode_find (bit_array, bit_count)) >= 0) {
		    for (int i=0; i<8; i++) {
			boolean		b = ((code & (128 >> i)) != 0);

			if (!next_filter.receive_bit (b))
			    return (true);
		    }

		    bit_count = 0;
		}

		if (bit_count >= 255)
		    return (false);
	    }

	    return (true);
	}

	public boolean		flush () {
	    return (next_filter.flush ());
	}

		// Find a huffman code that matches the array of bits.
		// If no match, return -1
	private int	huffcode_find (boolean bits[], int len) {
	    for (int i=0; i<256; i++) {
		boolean		found = true;

		if (huffcodes[i].length != len)
		    continue;

		for (int j=0; j<len; j++)
		    if (bits[j] != huffcodes[i][j]) {
			found = false;
			break;
		    }

		if (found)
		    return (i);
	    }

	    return (-1);
	}

		// Huffman codes. #include where are you?
	private boolean		huffcodes[][] = {
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			true, true, true, true},
		{true, false, true, true, false, false, false, true, false,
			true, false, true},
		{false, true, false, false, true, false, false},
		{true, false, true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
			false, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
			false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
			false, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
			false, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		false, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		false, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		false, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, true,
		true, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		false, true, false},
		{true, true, true},
		{false, true, false, false, true, false, true, false, false,
			false},
		{true, false, true, true, false, false, true, false, false},
		{true, false, true, true, true, true, true, true, true, true,
			true},
		{true, false, true, true, true, true, false, true, false,
			false, true, false},
		{true, false, true, true, false, false, false, true, false,
			true, false, false, false},
		{false, false, true, false, true, false, false, false, true,
			false, true, false, true},
		{false, false, true, false, true, false, true, true},
		{true, false, true, true, true, true, true, true, false},
		{false, false, true, false, false, false, true, true},
		{false, true, false, false, true, false, true, false, true},
		{true, false, true, true, true, true, false, true, false,
			false, true, true},
		{true, false, true, false, true, true, false},
		{true, false, true, true, true, true, true, false},
		{true, false, true, false, false, false},
		{true, false, true, true, true, true, false, false, true},
		{false, false, true, false, false, false, false},
		{false, true, false, false, true, false, true, true},
		{true, false, true, true, false, false, true, false, true},
		{false, false, true, false, true, false, true, false, true},
		{false, false, true, false, true, false, false, true, true},
		{true, false, true, true, true, true, false, true, true, true},
		{true, false, true, true, false, false, true, true, false,
			false},
		{false, true, false, false, true, false, true, false, false,
			true},
		{true, false, true, false, false, true, true, false, false,
			true},
		{false, false, true, false, true, false, false, false, false},
		{true, false, true, true, true, true, false, false, false},
		{true, false, true, true, true, true, true, true, true, true,
			false},
		{false, true, false, false, true, true, true, false, true,
			true, false},
		{true, false, true, false, false, true, false, true, false,
			true, false},
		{true, false, true, true, true, true, false, true, false,
			false, false},
		{true, false, true, false, false, true, false, true, false,
			false},
		{false, false, true, false, true, false, false, false, true,
			true},
		{false, true, false, false, true, true, true, true},
		{true, false, true, true, true, true, false, true, true,
			false},
		{true, false, true, true, false, false, false, true, true},
		{true, false, true, false, false, true, true, false, true},
		{false, false, true, false, false, false, true, false},
		{false, false, true, false, true, false, false, true, false},
		{true, false, true, true, false, false, false, false, false,
			false},
		{true, false, true, true, false, false, true, true, false,
			true},
		{false, true, true, true, false, false, false},
		{true, false, true, true, false, false, false, false, false,
			true, true},
		{true, false, true, true, false, false, false, true, false,
			true, true},
		{false, false, true, false, true, false, true, false, false},
		{true, false, true, true, false, false, true, true, true},
		{true, false, true, false, false, true, false, true, true},
		{true, false, true, true, false, false, false, false, true},
		{false, true, false, false, true, true, true, false, false},
		{true, false, true, false, false, true, true, true, true,
			false, false, false, true},
		{true, false, true, false, false, true, true, true, false},
		{true, false, true, false, false, true, false, false},
		{true, false, true, false, true, true, true, false},
		{true, false, true, true, true, true, false, true, false,
			true},
		{true, false, true, false, false, true, true, true, true,
			false, true},
		{true, false, true, true, false, false, false, true, false,
			false},
		{true, false, true, true, false, false, false, false, false,
			true, false},
		{false, true, false, false, true, true, true, false, true,
			false},
		{false, true, false, false, true, true, true, false, true,
			true, true, true},
		{true, false, true, false, false, true, true, true, true,
			false, false, true},
		{false, false, true, false, true, false, false, false, true,
			false, true, true},
		{true, false, true, false, false, true, false, true, false,
			true, true, true},
		{true, false, true, true, false, false, false, true, false,
			true, false, false, true},
		{true, false, true, true, true, true, true, true, true, false,
			false},
		{false, false, true, false, true, false, false, false, true,
			false, false},
		{false, true, false, true},
		{false, false, true, false, false, true},
		{true, true, false, true, true, false},
		{false, true, false, false, false},
		{true, true, false, false},
		{true, false, true, false, true, false},
		{false, true, true, true, false, true},
		{true, false, false, false, true},
		{false, false, true, true},
		{true, false, true, false, false, true, true, true, true,
		true},
		{false, true, false, false, true, true, false},
		{false, true, true, true, true},
		{true, false, true, true, true, false},
		{false, false, false, true},
		{false, true, true, false},
		{true, false, false, false, false, true},
		{true, false, true, true, true, true, true, true, true, false,
			true},
		{true, true, false, true, false},
		{false, false, false, false},
		{true, false, false, true},
		{true, true, false, true, true, true},
		{false, true, true, true, false, false, true},
		{false, false, true, false, true, true},
		{true, false, true, false, true, true, true, true},
		{true, false, false, false, false, false},
		{true, false, true, false, false, true, true, false, false,
			false},
		{true, false, true, false, false, true, true, true, true,
			false, false, false, false},
		{true, false, true, false, false, true, false, true, false,
			true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, true},
		{false, false, true, false, true, false, false, false, true,
			false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, false,
		true, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		false, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		false, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		false, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		false, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		false, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		false, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, false, true,
		true, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		false, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		false, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		false, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		false, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		false, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		false, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, false,
		true, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			false, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			false, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			false, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			false, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			false, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			false, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, false, false, true, true,
			true, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			false, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			false, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			false, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			false, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			false, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			false, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, false,
			true, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			false, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			false, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			false, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			false, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			false, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			false, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, false, true,
			true, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			false, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			false, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			false, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			false, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			false, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			false, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, false,
			true, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			false, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			false, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			false, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			false, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			false, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			false, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			true, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			true, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			true, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			true, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			true, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			true, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			true, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, false, true, true,
			true, true, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			false, false, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			false, false, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			false, false, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			false, false, true, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			false, true, false, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			false, true, false, true},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			false, true, true, false},
		{false, true, false, false, true, true, true, false, true,
			true, true, false, false, true, true, false, false,
			false, true, true, true}
	};
}
