#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#ifdef DMALLOC
#include <dmalloc.h>
#endif /* DMALLOC */
#include "extern.h"

#define MAX_ENTRIES 10000
#define WORDSIZE 82

int num_lines=0;

char **textlist(char *textfile) {
	FILE *fp;
	char **wordlist;
	char buffer[WORDSIZE];
	int count;
	char *chop;

	num_lines = 0;

	fp = fopen(textfile, "r");

	if (!fp) {
		fprintf(stderr, "textlist: error opening %s\n", textfile);
		exit(EXIT_FAILURE);
	}

	/* num_lines is actually one more than the number of lines, but we need */
	/* an extra spot for the NULL anyway, so dont get rid of it */

	while (!feof(fp) && (num_lines < MAX_ENTRIES)) {
		fgets(buffer, sizeof(buffer), fp);
		if (buffer[0] != '#' && buffer[0] != ';' && buffer[0] != '\n')
			num_lines++;
	}

	if (debug)
	 	printf("textlist: reading %s [%i]\n", textfile, num_lines-1);

	rewind(fp);

	wordlist = malloc_w(num_lines*sizeof(char*));

	count=0;
	while (!feof(fp)) {
		fgets(buffer, sizeof(buffer), fp);
		if (buffer[0] == '#' || buffer[0] == ';' || buffer[0] == '\n')
			continue;
		wordlist[count] = (char*)strdup_w(buffer);
		chop = (char*)strstr(wordlist[count], "\n"); /* credits to cgichk */
		if (chop) *chop = 0;						 /* and toby deshane  */
		count++;
	}

	if (count>0) count--;							/* count cant be -1 */
	wordlist[count] = malloc_w(sizeof(NULL));
	wordlist[count] = NULL;

	fclose(fp);

	return(wordlist);
}

void read_session(char *sessionfile) {
	FILE *fp;
	char buffer[30];
	int result;

	fp = fopen(sessionfile, "r");

	if (!fp) {
		fprintf(stderr, "read_session: error opening %s\n", sessionfile);
		exit(EXIT_FAILURE);
	}

	fgets(buffer, sizeof(buffer), fp);
	result = sscanf(buffer, "%i, %i, %i", &session_usernumber, &session_function, &session_count);

	if (result != 3) {
		fprintf(stderr, "read_session: invalid format (#, #, #)\n");
		exit(EXIT_FAILURE);
	}

	if (debug)
		printf("read_session: reading %s [%i, %i, %i]\n", sessionfile, session_usernumber, session_function, session_count);
		
	fclose(fp);
}

void write_session(char *sessionfile) {
	FILE *fp;

	fp = fopen(sessionfile, "w");

	if (!fp) {
		fprintf(stderr, "write_session: error opening %s\n", sessionfile);
		exit(EXIT_FAILURE);
	}

	fprintf(fp, "%i, %i, %i\n", session_usernumber, session_function, session_count);

	if (debug)
		printf("write_session: writing %s [%i, %i, %i]\n", sessionfile, session_usernumber, session_function, session_count);

	fclose(fp);
}

/* search : delimited pathlist for filename, if found returns full path else
 * returns NULL
 */

char *search_path(char *filename, char *pathlist) {
	int i = 0;
	char *curpath;
	char *fullpath;

	fullpath = (char*)malloc_w(sizeof(char)*80);

	while ((curpath = extract_colon_unit(pathlist, &i)) != NULL) {
		snprintf(fullpath, sizeof(char)*80, "%s/%s", curpath, filename);
		if (debug)
			printf("search_path: attempting to access %s\n", fullpath);
		if (access(fullpath, R_OK) == 0)
			return(fullpath);
	}

	free(fullpath);
	fprintf(stderr, "search_path: couldn't find or read %s\n", filename);
	exit(EXIT_FAILURE);
}
