/* main.c */
/* command line configurable variables */
extern char datafile_path[60];          /* location of data files */
extern char username_file[80];          /* file containing usernames */
extern char common_passwords_file[80];  /* file containing common passes */
extern char username_concat_file[80];   /* file containing concats */
extern char common_pairs_file[80];		/* file containing common pairs */
#ifdef USE_DUMMY
extern char submit_dummy_file[80];		/* file containing dummy combos */
#endif USE_DUMMY
extern char logfile[80];   	            /* file to log to */
extern unsigned int max_users;          /* max number of users to try */
extern unsigned int max_connects;	    /* max num of connects */
extern unsigned int per_user_delay;     /* delay between trying users */
extern unsigned int per_password_delay; /* delay between attempt */
extern char useragent[50];              /* username to pass to browser */
extern char url[160];                   /* url to bruteforce */
extern char proxy[40];                  /* proxy support */
extern int quiet;					    /* no output to stdout? */
extern int debug;                       /* print debug messages? */
extern int beep; 	                    /* beep on found? */

extern char *user_pass[2];			    /* username, password */
extern FILE *log;					    /* log file handle */
extern unsigned int found;				/* valid auth found */
extern unsigned int num_users;	        /* cur number of users tried */
extern int session_usernumber;          /* current usernumber */
extern int session_function; 	        /* current function */
extern int session_count; 	            /* current loop */
extern char session_file[80];			/* file containing session data */
//extern float acs;						/* average connects per second */
char pathlist[120];						/* path list for data files */

/* methods.c */
extern int common_passwords(char *username);
extern int username_derivations(char *username);
extern int username_concat(char *username);
extern void common_pairs(int num_users);
typedef enum {
	username_derivations_ident,
	username_concat_ident,
	common_passwords_ident,
	common_pairs_ident
} session_ident_types;

/* http.c */
extern void initialize_submit(void);
extern int submit(char *username, char *password);
extern void shutdown_submit(void);

/* files.c */
extern char **textlist(char *textfile);
extern int num_lines;
extern void read_session(char *sessionfile);
extern void write_session(char *sessionfile);
extern char *search_path(char *filename, char *pathlist);

/* signal.c */
extern void save_session_handler();
extern void install_handler();

/* misc.c */
extern void *malloc_w(size_t size);			/* malloc wrapper w/ error checking */
extern char *strdup_w(const char *s);			/* strdup wrapper w/ error checking */
extern char *extract(char *str, char token);
extern float stats(float average, float element, int num);
extern char *strrev(char *str);

/* extract.c */
extern char *extract_colon_unit(char *string, int *p_index);
