#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#ifdef DMALLOC
#include <dmalloc.h>
#endif /* DMALLOC */
#include "extern.h"

/* malloc wrapper with error checking */
void *malloc_w(size_t size) {
	void *ptr;

	ptr = malloc(size);

	if (!ptr) {
		fprintf(stderr, "malloc_w: couldn't allocate memory\n");
		exit(EXIT_FAILURE);
	}

	return (ptr);
}

/* strdup wrapper with error checking */
char *strdup_w(const char *s) {
	char *ptr;

	ptr = strdup(s);

	if (!ptr) {
		fprintf(stderr, "strdup_w: couldn't allocate memory\n");
		exit(EXIT_FAILURE);
	}

	return (ptr);
}

/*
 * seperates str using token, putting the first part in str and returning
 * the second part. (does a function like this already exist?
 */
char *extract(char *str, char token) {

	char *p = str;

	while (*p != token) {
		if (p == '\0')
			return(NULL);
		++p;
	}
	*p = '\0';
	p++;
	return(p);
}

/* calculate new average, average being new entry, element being the new
 * number and num being the total elements in average
 */

float stats(float average, float element, int num) {
	printf("avg: %f, el: %f, num: %i\n", average, element, num);
	return (((average*num)+element)/num+1);
}

/* code released as public domain by Bob Stout */
char *strrev(char *str)
{
      char *p1, *p2;

      if (! str || ! *str)
            return str;
      for (p1 = str, p2 = str + strlen(str) - 1; p2 > p1; ++p1, --p2)
      {
            *p1 ^= *p2;
            *p2 ^= *p1;
            *p1 ^= *p2;
      }
      return str;
}
