#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include "extern.h"

void save_session_handler() {

	if (!quiet)
		printf("Saving session to %s\n", session_file);
	write_session(session_file);

	exit(EXIT_SUCCESS);
}

void install_handler() {

	sigset_t usr1;

	if (debug)
		printf("install_handler: signal SIGUSR isntalling\n");

	signal(SIGUSR1, save_session_handler);
	sigemptyset(&usr1);
	sigaddset(&usr1, SIGUSR1);
	sigprocmask(SIG_UNBLOCK, &usr1, NULL);
}
