#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>
#ifdef DMALLOC
#include <dmalloc.h>
#endif /* DMALLOC */
#include "extern.h"

char **password_list = NULL;
char **concat_list = NULL;

int common_passwords(char *username) {
	int i;
	char *password;
	int result;
	char *path = NULL;

	if (!password_list) {
		path = search_path(common_passwords_file, pathlist);
		password_list = textlist(path);
	}

	session_function = common_passwords_ident;
	i = session_count;

	while ((password = password_list[i]) != NULL) {
		result = submit(username, password);
		sleep(per_password_delay);
		if (result == EXIT_SUCCESS) {
			strncpy(user_pass[0], username, sizeof(char)*41);
			strncpy(user_pass[1], password, sizeof(char)*41);
			return(EXIT_SUCCESS);
		}	
		session_count = i;
		i++;
	}

	return(EXIT_FAILURE);
}

int username_derivations(char *username) {
	char *password;
	int result;

	session_function = username_derivations_ident;

	password = (char*)malloc_w(sizeof(char)*41);

	strncpy(password, username, sizeof(char)*41);/* username as password ;) */
	result = submit(username, password); 
	if (result == EXIT_SUCCESS) {
		strncpy(user_pass[0], username, sizeof(char)*41);
		strncpy(user_pass[1], password, sizeof(char)*41);
		free(password);
		return(EXIT_SUCCESS);
	}

	snprintf(password, sizeof(char)*41, "%s%s", username, username);
	result = submit(username, password);
	sleep(per_password_delay);
	if (result == EXIT_SUCCESS) {
		strncpy(user_pass[0], username, sizeof(char)*41);
		strncpy(user_pass[1], password, sizeof(char)*41);
		free(password);
		return(EXIT_SUCCESS);
	}

	strrev(password);							/* reversed */
	result = submit(username, password);
	sleep(per_password_delay);
	if (result == EXIT_SUCCESS) {
		strncpy(user_pass[0], username, sizeof(char)*41);
		strncpy(user_pass[1], password, sizeof(char)*41);
		free(password);
		return(EXIT_SUCCESS);
	}

	session_count = 0;
	free(password);
	return(EXIT_FAILURE);
}

int username_concat(char *username) {
	int i=0;
	char *password;
	char *concat_password;
	int result;
	char *path = NULL;

	if (!concat_list) {
		path = search_path(username_concat_file, pathlist);
		concat_list = textlist(path);
	}
	
	session_function = username_concat_ident;
	i = session_count;

	password = (char*)malloc_w(sizeof(char)*41);
	concat_password = (char*)malloc_w(sizeof(char)*51);

	while (1) {
		if (concat_list[i] == NULL)
			break;
		strncpy(concat_password, username, sizeof(char)*51);
		password = strncat(concat_password, concat_list[i], sizeof(char)*51);
		result = submit(username, password);
		sleep(per_password_delay);
		if (result == EXIT_SUCCESS) {
			strncpy(user_pass[0], username, sizeof(char)*41);
			strncpy(user_pass[1], password, sizeof(char)*51);
			free(password);
			free(concat_password);
			return(EXIT_SUCCESS);
		}
		session_count = i;
		i++;
	}

	session_count = 0;
	free(password);
//	free(concat_password);				/* why is it already freed? */
	return(EXIT_FAILURE);
}

void common_pairs(int num_users) {
	int i=0;
	char **common_pairs_list;
	int result;
	char *path = NULL;
	char *username;
	char *password;

	session_function = common_pairs_ident;

	username = (char*)malloc_w(sizeof(char)*81);

	path = search_path(common_pairs_file, pathlist);
	common_pairs_list = textlist(path);

	while (1) {
		if (common_pairs_list[i] == NULL)
			break;
		strncpy(username, common_pairs_list[i], sizeof(char)*81);
		password = extract(username, ':');
		if (!password) {
			fprintf(stderr, "common_pairs: list element invalid\n");
			exit(EXIT_FAILURE);
		}
		result = submit(username, password);
		sleep(per_password_delay);
		if (result == EXIT_SUCCESS) {
			if (!quiet)
				printf("match [%s:%s]\n", username, password);
			if (beep)
				printf("\007");
			fprintf(log, "match [%s:%s]\n", username, password);
			found++;
		}
		session_count = i;
		i++;
		if (max_users == num_users && max_users != 0) {
			if (!quiet)
				printf("max users reached at %i\n", num_users);
			fprintf(log, "max users reached at %i\n", num_users);
			break;
		}
		num_users++;
	}

	session_count=0;
	free(username);
}
