/*
 *
 * +-------------------------------------+
 * |  Bronc Buster vs. Micheal Jackson   |
 * |       Friday, June 4th, 1999        |
 * |    World Championship Title Bout    |
 * | "Greatest Pop Singer in the World." |
 * +-------------------------------------+
 * . . . . . . . . . . . . who will win? .
 *
 * The 'Bronc Buster vs. Micheal Jackson' Scanner named in honour of the
 * legendary battle to take place in early June for the most respected title
 * in the world... Who will claim the title of the "Greatest Pop Singer in
 * the World?"  -- all code within was produced by aempirei (c)1999.
 *
 */

#include "mjackson.h"

int usage(char *arg);

int billie_jean_aka_bronc_buster(void);
void jackson_5(struct in_addr, FILE *);
void pop_star(int);

void sighandler(int signo) { /* generic signal handler */ }

int i1 = 0, i2 = 0;

char *device = NULL,
     *banner = NULL;

struct node *n1st,
            *nwlk,
            *ntmp;

void main(int argc, char *argv[]) {
   struct utsname hinfo;
   char errbuf[PCAP_ERRBUF_SIZE];
   int opt;
   int i, j;
   time_t janet;
   
   extern char *optarg;
   extern int opterr;

   setvbuf (stdout, NULL, _IONBF, 0);

   /* very cute centering technique */
   for(i = 0; i < 78; i++) putchar('*');
   putchar('\n');
   i = (78 - sizeof(VERSION " " AUTHORS)) >> 1;
   for(j = 0; j <= i; j++) putchar(' ');
   puts(VERSION " " AUTHORS);
   for(i = 0; i < 78; i++) putchar('*');
   putchar('\n');
   
   if (argc < 4) usage(argv[0]);

   opterr = 0; /* we like pretty output */
  
   while ((opt = getopt(argc, argv, "d:")) != -1) {
      switch (opt) {
         case 'd':
            device = calloc(min(strlen(optarg), 15) + 1, 1);
            memcpy(device, optarg, min(strlen(optarg), 15)); break;
            break;
         case '?': usage(argv[0]); break;
      }
   }

   if(argc - optind == 3) {
      i = sscanf(argv[optind++], "%i.%i", &i1, &i2);
      dst_port = ntohs(atoi(argv[optind++]));
      if(!(banner = malloc(strlen(argv[optind]) + 1))) {
         perror("malloc()");
         exit(EXIT_FAILURE);
      }
      strcpy(banner, argv[optind]);
   } else usage(argv[0]);

   if(!dst_port) {
      puts("error : invalid target port");
      usage(argv[0]);
   }

   if(i != 2) {
      puts("error : invalid network id");
      usage(argv[0]);
   }

   setuid (0);
   uname(&hinfo);
   
   printf("\nRunning on: '%s' running %s %s on a(n) %s\n\n",
      hinfo.nodename, hinfo.sysname, hinfo.release, hinfo.machine);

   if(getuid()) {
      printf(" * %s does not have root privilages\n", getlogin());
      exit(EXIT_FAILURE); /* get lost punk */
   }
   
   if(!device) {
      if((device = pcap_lookupdev(errbuf)) == NULL) {
         printf(" * pcap device lookup: %s\n", errbuf);
         exit(EXIT_FAILURE);
      }
   }

   sprintf(errbuf, "%i.%i.%i.%i", i1, i2, 1, 1);
   inet_aton(errbuf, &target_ip);

   init_moonwalk();

   printf("Selected Interface: %s\n", device);
   printf("Interface Address: %s\n", inet_ntoa(local_ip));
   printf("Scanning Range: %i.%i.*.*:%i\n", i1, i2, ntohs(dst_port));
   printf("String Search: \"%s\"\n", banner);
   printf("\nYou might want to grab a cup of coffee. Just an idea...\n\n");

   n1st = calloc(NLEN, 1);

   janet = time(NULL);
   
   i = billie_jean_aka_bronc_buster();

   term_moonwalk();

   pop_star(i);

   printf("- Audit Completion : %li seconds -\n", time(NULL) - janet);
   putchar('\n');
}

int usage (char *program) {
  printf(" usage: %s [-d <device>] <x.x> <port> <\"Banner\">\n", program);
  printf("   <x.x>           Class B style network ID\n"
	 "   <port>          target TCP service port\n"
         "   <\"Banner\">      banner string to search for\n"
         "   [-d <device>]   selected interface to listen on\n\n");
  exit(EXIT_FAILURE);
}

int billie_jean_aka_bronc_buster(void) {
   struct tcphdr tcp;
   struct ip ip;
   int found = 0;
   long L;
   char thriller[16];
   time_t pop_t, pop2_t;

   pop_t = time(NULL);
   nwlk = ntmp = n1st;
   
   for(L = 0; L <= 0xffff; L++) {
      sprintf(thriller, "%i.%i.%i.%i",
              i1, i2, (int)(L >> 8), (int)(L & 0xff));
      inet_aton(thriller, &target_ip);

      if(!(L & 0xff)) {
         printf("- %i.%i.%li.* - %i canidates "
                "- %.1f ip/sec "
                "- %li seconds remain \r",
                i1, i2, (L >> 8), found,
                (time(NULL) - pop_t) ? (float)L / (time(NULL) - pop_t) : 0,
                L ? (0xfeff - L) * (time(NULL) - pop_t) / L : 0);
      } else sendtcp();

      white_glove(&ip, (char *)&tcp, sizeof(tcp));
      if((dst_port == tcp.th_sport) && (SRC_P == tcp.th_dport))
         if(ntohs(tcp.th_win)) {
            found++;
            nwlk->ip = ip.ip_src;
            nwlk->n = calloc(NLEN, 1);
            nwlk = nwlk->n;
         }
   }

   printf("\n- waiting 10 seconds for any remaining responses\n");
   
   pop2_t = time(NULL);
   
   while(time(NULL) - pop2_t < 10) {
      white_glove(&ip, (char *)&tcp, sizeof(tcp));
      if((dst_port == tcp.th_sport) && (SRC_P == tcp.th_dport))
         if(ntohs(tcp.th_win)) {
            found++;
            nwlk->ip = ip.ip_src;
            nwlk->n = calloc(NLEN, 1);
            nwlk = nwlk->n;
         }
   }

   printf("- superficial analysis complete : "
          "%i canidates found in %li seconds\n",
          found, time(NULL) - pop_t);

   /* linked list clean-up last allocated block because it wasn't used */
   for(nwlk = n1st; (nwlk->n)->n != NULL; nwlk = nwlk->n);
   free(nwlk->n);
   nwlk->n = NULL;

   return found;
}

void pop_star(int found) {
   FILE *tito;
   int i, status;
   char fname[13];
   char buffer[70];

   sprintf(fname, "%04x.ip.list", rand() % 0xffff);

   if((tito = fopen(fname, "w")) == NULL) {
      printf("error : cannot open %s for output\n", fname);
      exit(EXIT_FAILURE);
   }

   for(i = 0, nwlk = n1st; (i < 25) && nwlk; i++, nwlk = nwlk->n) {
      if(!fork()) {
         jackson_5(nwlk->ip, tito);
         exit(EXIT_SUCCESS);
      }
      printf("- checking for \"%s\" - %i IPs remaining \r", banner, --found);
   }

   if(nwlk) {
      for(;nwlk; nwlk = nwlk->n) {
         wait(&status); /* wait till a child dies to make another */
         if(!fork()) {
            jackson_5(nwlk->ip, tito);
            exit(EXIT_SUCCESS);
         }
         printf("- checking for \"%s\" - %i IPs remaining \r", banner, --found);
      }
   }

   putchar('\n');
   for(i = 10; i; i--) {
         printf("- waiting %i second%sfor all processes to complete  \r",
                i, (i != 1) ? "s " : " ");
         sleep(1);
      if((waitpid(-1, &status, WNOHANG) == -1) && (errno == ECHILD)) break;
   }
   putchar('\n');

   fclose(tito);

   if((tito = fopen(fname, "r")) == NULL) {
      printf("error : cannot open %s for input\n", fname);
      exit(EXIT_FAILURE);
   }

   while(!feof(tito)) {
      fgets(buffer, 70, tito);
      if(buffer != NULL) printf(buffer);
   }

   fclose(tito);
   printf("- detected IP list stored in %s\n", fname);
}

void jackson_5(struct in_addr ip_addr, FILE *f_out) {
   SAin sa_dst;
   int sd, j;
   char buffer[240];

   sa_dst.sin_family = AF_INET;
   sa_dst.sin_port = dst_port;
   sa_dst.sin_addr = ip_addr;
   
   if((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) return;

   signal (SIGALRM, &sighandler);
   alarm(7);
   
   if(!connect(sd, (SA *)&sa_dst, sizeof(sa_dst))) {
      alarm(0);
      fcntl(sd, F_SETFL, O_NONBLOCK);
      for(j = 0; j < 7; j++) {
         sleep(1);
         bzero(buffer, 240);
         if(recv(sd, buffer, 239, MSG_PEEK) > 0) {
            if(strstr(buffer, banner)) {
               close(sd);
               fprintf(f_out, "%s\n", inet_ntoa(ip_addr));
               return;
            }
         }
      }
   }
   
   close(sd);
   return;
}

