#include "mjackson.h"

#define pcap_ip(a) ((struct ip *)(p + (a)))
#define pcap_tcp(a) ((struct tcphdr *)(p + (a) + sizeof(struct ip)))
#define ABC_123 (htons(0x3000 | (getpid() % 0x3000)))
void sig_just_beat_it(int);
struct in_addr get_local_ip(void);

struct in_addr local_ip; /* local ip address */
struct in_addr target_ip; /* target ip address */

u_short src_port; /* source port */
u_short dst_port; /* destination port */

int pcap_off; /* header offset for pcap_next captured packets */

pcap_t *pd_raw; /* packet capture descriptor */
int sd_tcp; /* raw socket descriptor */
int sd_icmp; /* icmp socket descriptor */

/* these are not externally defined in the header */
int clicks;

void init_moonwalk(void) {
   char errbuf[PCAP_ERRBUF_SIZE];

   pcap_off = 0;
   pd_raw = pcap_open_live(device, MIN_PKT << 2, 0, MIN_PKT, errbuf);
   if(pd_raw == NULL) {
      fprintf(stderr, "opening pcap device: %s", errbuf);
      exit(EXIT_FAILURE);
   }
   if((sd_tcp = socket(AF_INET, SOCK_RAW, IPPROTO_TCP)) < 0) {
      perror("opening raw socket (tcp)");
      exit(EXIT_FAILURE);
   }
   if((sd_icmp = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP)) < 0) {
      perror("opening raw socket (icmp)");
      exit(EXIT_FAILURE);
   }
   
   local_ip = get_local_ip();
}

void term_moonwalk(void) {
   close(sd_tcp);
   close(sd_icmp);
   pcap_close(pd_raw);
}

void sig_just_beat_it(int sigio) {
   SAin sa_dest;
   struct icmp_h icmp;

   sa_dest.sin_family = AF_INET;
   sa_dest.sin_addr = target_ip;
   sa_dest.sin_port = htons((rand() % 1000) + 1000);

   bzero(&icmp, sizeof(icmp));
   icmp.icmp_type = ICMP_ECHO;
   icmp.icmp_un.echo.id = getpid();
   icmp.icmp_sum = in_cksum((u_short *)&icmp, sizeof(icmp));
   
   sendto(sd_icmp, &icmp, sizeof(icmp), 0, (SA *)&sa_dest, sizeof(SAin));
   
   if(++clicks == 5) {
      printf("cannot receive messages on the interface '%s'\n", device);
      exit(EXIT_FAILURE);
   }
   
   alarm(1);
}

void sendtcp(void) {
  SAin sa_dest;
  struct tcphdr tcph;

  tcph.th_sport = SRC_P;
  tcph.th_dport = dst_port;
  tcph.th_flags = TH_SYN | TH_FIN;
  tcph.th_win = T_WIN;
  tcph.th_off = 5;
  tcph.th_urp = tcph.th_sum = tcph.th_ack = tcph.th_x2 = 0;
  tcph.th_seq = htonl(rand() % 0xffff);
/*-- TCP Checksum --*/
#ifdef SOLARIS_CKSUM_BUG
  tcph.th_sum = sizeof (struct tcphdr);
#else
  tcph.th_sum = tcp_cksum((char *)&tcph, sizeof(tcph), local_ip, target_ip);
#endif /* SOLARIS_CKSUM_BUG */

   sa_dest.sin_family = AF_INET;
   sa_dest.sin_addr = target_ip;
   sa_dest.sin_port = dst_port;
   
   if(sendto(sd_tcp, &tcph, sizeof(tcph), 0, (SA *)&sa_dest, sizeof(SAin)) < 0)
      perror("sending message");
}

u_long white_glove(struct ip *ip_ptr, char *packet, int pkt_len) {
   struct ip ip2;
   struct pcap_pkthdr pcap_hdr;
   char *p = NULL;
   int i, max, iphl;
   u_short sum;

   bzero(packet, pkt_len);
   bzero(ip_ptr, sizeof(struct ip));

   signal(SIGALRM, &sig_just_beat_it);
   clicks = 0;

   if(ip_ptr == NULL) ip_ptr = &ip2;

   alarm(1);
   if((p = (char *)pcap_next(pd_raw, &pcap_hdr)) == NULL) return 0;
   alarm(0);

   if(!pcap_off) max = min(50, pcap_hdr.caplen);
   else max = pcap_off + 1;
   
   for(i = pcap_off; i < max; i++) {
      if(pcap_ip(i)->ip_v != IPVERSION) continue;
      if(pcap_ip(i)->ip_hl > 5) continue;

      iphl = pcap_ip(i)->ip_hl << 2;

      memcpy(ip_ptr, pcap_ip(i), sizeof(struct ip));

      ip_ptr->ip_sum = pcap_ip(i)->ip_sum;
      pcap_ip(i)->ip_sum = 0;
      sum = in_cksum((u_short *)pcap_ip(i), iphl);

      pcap_ip(i)->ip_sum = ip_ptr->ip_sum;
      ip_ptr->ip_sum = sum;

      if(pcap_ip(i)->ip_sum == ip_ptr->ip_sum) {
         memcpy(packet, p + i + iphl,
                min(pkt_len, pcap_hdr.caplen));

         if(!pcap_off) pcap_off = i;
         return pcap_ip(i)->ip_src.s_addr;
      }
   }
   
   return 0;
}

struct in_addr get_local_ip(void) {
   SAin sa_dest;
   struct in_addr ip_addr;
   struct icmp_h icmp;
   struct ip ip;

   ip_addr.s_addr = 0;

   bzero(&icmp, sizeof(icmp));
   icmp.icmp_type = ICMP_ECHO;
   icmp.icmp_un.echo.id = getpid();
   icmp.icmp_sum = in_cksum((u_short *)&icmp, sizeof(icmp));

   sa_dest.sin_family = AF_INET;
   sa_dest.sin_addr = target_ip;
   sa_dest.sin_port = htons((rand() % 1000) + 1000);
   
   sendto(sd_icmp, &icmp, sizeof(icmp), 0, (SA *)&sa_dest, sizeof(SAin));
   bzero(&icmp, sizeof(icmp));

   usleep(50);
   
   if(white_glove(&ip, (char *)&icmp, sizeof(icmp)))
      if(icmp.icmp_type == ICMP_ECHO)
         if(icmp.icmp_un.echo.id == getpid())
            ip_addr = ip.ip_src;

   return ip_addr;
}

