#include "ess.h"

int ftplogin(char *username, char *password);
int ftplist(char *dir);
int ftplistdir();
int recvline();

int connstatus=0;
char line[1024];
#define UC(x) (((int)x)&0xFF)

int ftpchk()
{
char tmpbuff[1024];
int num=0;
int num1=1;
int buffnum=0;
int wait4buff=1;
int numofdir;
char buff[1024];
int status;

printf("\n#########[Checking ftpd]#########\n");
if((connport(ftpdport,1))==0)
  { close(sock);
    return(0); }

fprintf(logfile,"\n#########[Checking ftpd]#########\n");

if(ftpuser!=NULL)
  {
  //------Trying to login------//
  if(parse_space(ftpuser)<2)
    { printf("\n!! You need to enter the password for user %s in ess.conf !!",parseline[0].buff);
      return 0; }
  if(ftplogin(parseline[0].buff,parseline[1].buff))
    {	//..login allow..
    //------Getting the OS info------//
    usleep(10000);
    send(sock,"SYST\r\n",6,0);
    while(1)
      {
      if(!recvline())
        return(0);
      if(!strncmp(line,"215",3))
        break;
      }
    sprintf(tmpbuff,"OS type: %s\n",line+4);
    logger(tmpbuff);

    //------List file/dir in current/home dir------//
    printf("\nListing files in current directory.....\n");
    ftplistdir();

    //------Check for directories existence------//
    if(dir2chk!=NULL)
      { numofdir=parse_space(dir2chk);
        for(num=0;num!=numofdir;num++)
           ftplist(parseline[num].buff); }
    }
  else
    {
    //------Try executing SYST without logging in------//
    printf("\nTrying to execute SYST without logging in .... ");
    send(sock,"SYST\r\n",6,0);
    if(!recvline())
      return(0);
    if(strstr(line,"215"))
      { sprintf(tmpbuff,"\n\nOS type: %s",line+4);
        logger(tmpbuff); }
    else
      printf("failed");
    }
  }
close(sock);
}


int ftplist(char *dir)
{
  char tmpbuff[1024];
  int retnum;

  send(sock,"CWD /\r\n",7,0);
  while(1)
    {
    if(!recvline())
      return(0);
    if(!strncmp(line,"250",3))
      break; 
    }

  usleep(10000);
  sprintf (tmpbuff, "CWD %s\r\n", dir);
  send(sock,tmpbuff,strlen(tmpbuff),0);
  if(!recvline())
    return(0);

  if (strstr (line, "250"))	// success
    { sprintf(tmpbuff,"\n%s was found and accessible", dir);
      logger (tmpbuff);
      ftplistdir();
      retnum=1; }
  else if (strstr(line, "550"))
    { printf ("\n%s was not found\n", dir);
      retnum=0; }
  else if (strstr(line, "501"))
    { printf ("\n%s was not found\n", dir);
      retnum=0; }
  else if (strstr(line, "550"))
    { printf ("\n%s was found but we can't access it.\n", dir);
      retnum=0; }
  else
    printf(line);
  
  return retnum;
}


int ftplogin(char *username, char *password)
{
  char usern[255];
  char passwd[255];
  char tmpbuff[1024];

  sprintf(usern, "USER %s\r\n", username);
  sprintf(passwd, "PASS %s\r\n", password);

  send(sock,usern,strlen(usern),0);

  while(1)
    {
    if(!recvline())
      return(0);
    if(!strncmp(line,"220",3))
      { printf("%s\n",line);
        fprintf(logfile,"%s\n",line);
        check4bug(line,2); }
    else
      break;
    }

  if (strstr (line, "530"))
    { sprintf (tmpbuff,"\nToo many logged in user %s.\n", username);
      logger(tmpbuff);
      return(0); }
  else if (strstr (line, "421"))
    { sprintf(tmpbuff,"\n!! %s login not allowed !!\n",username);
      logger(tmpbuff);
      return(0); }

  usleep(20000);
  send(sock,passwd,strlen(passwd),0);
  if(!recvline())
    return(0);

  if (strstr (line, "530"))
     { printf ("\nLogin incorrect for user %s.\n", username);
       return(0); }
  else if (strstr (line, "230"))
     { sprintf(tmpbuff,"\n!! %s login allowed !!\n",username);
      logger(tmpbuff);
      return(1); }
  else 
    { sprintf(tmpbuff,"\n!! %s login not allowed !!\n",username);
      logger(tmpbuff);
      return(0); }
}


int ftplistdir()
{
int data_sock,data_sock2;
int sin_size;
int recvstat=1;
char buff[1025];
char sendbuff[255];
char *a,*b;
char dirlist[1024];
FILE *ftpdirfd;
struct sockaddr_in Ourdata_conn;
struct sockaddr_in Theirdata_conn;

memset(buff,'\0',sizeof(buff));
start_data_sock:
data_sock=socket(AF_INET, SOCK_STREAM, 0);
sin_size = sizeof(struct sockaddr_in);

if(getsockname(sock,(struct sockaddr *)&Ourdata_conn,&sin_size) == -1)
  printf("Error 1\n");

Ourdata_conn.sin_port = 0;

if(bind(data_sock, (struct sockaddr *)&Ourdata_conn, sizeof(struct sockaddr))==-1)
  { perror("bind");
    close(data_sock);
    goto start_data_sock; } // incase port in use
if(getsockname(data_sock,(struct sockaddr *)&Ourdata_conn,&sin_size) == -1)
  printf("Error 2\n");
if(listen(data_sock, 1) == -1)
  perror("listen");

a=(char *)&Ourdata_conn.sin_addr;
b=(char *)&Ourdata_conn.sin_port;

sprintf(sendbuff,"PORT %d,%d,%d,%d,%d,%d\r\n",UC(a[0]),UC(a[1]),UC(a[2]),UC(a[3]),UC(b[0]),UC(b[1]));

send(sock,sendbuff,strlen(sendbuff),0);
while(1)
  {
  if(!recvline())
    return(0);
  if(!strncmp(line,"200",3)) // port command successful
    break; 
  }
//printf("Port> %s\n",line);

if(!fork())
 {
 FILE *ftpdir;
 ftpdir=fopen(".ftpdir","w");
 data_sock2 = accept(data_sock, (struct sockaddr*)&Theirdata_conn,&sin_size);
 while(recvstat)
   { recvstat=recv(data_sock2,buff,sizeof(buff),0);
//     fwrite(buff,recvstat,1,stdout);
     fwrite(buff,recvstat,1,ftpdir); }
 fclose(ftpdir);
 close(data_sock2);
 _exit(0);
 }

send(sock,"LIST\r\n",6,0);
while(1)
  {
  if(!recvline())
    return(0);
  if(!strncmp(line,"226",3)) // 226 Transfer complete.
    break;
  }
//printf("After List> %s\n",line);
wait();

memset(dirlist,'\0',sizeof(dirlist));
ftpdirfd=fopen(".ftpdir","r");
while(fgets(dirlist,sizeof(dirlist),ftpdirfd))
  { printf(dirlist);
    fprintf(logfile,dirlist); }
fclose(ftpdirfd);
unlink(".ftpdir");

close(data_sock);
close(data_sock2);
}



int recvline()
{
int len;
int buffoffset=0;
char buff[1];

if(connstatus!=-1)
  {
  memset(line,'\0',sizeof(line));
  while(1)
    {
    if((timeout(1,lag_sec))==1)
      len=recv(sock,buff,1,0);
    else
      return(0);

    if(len==0)
      { printf("\n .. connection closed by server ..");
        fprintf(logfile,"\n .. connection closed by server ..");
        close(sock);
        connstatus=-1;
        return(0); }
    line[buffoffset]=buff[0];
    if(line[buffoffset]=='\n')
      { line[buffoffset]='\0';
        break; }
    buffoffset++;
    }
  }
else
  { printf("\n .. connection closed by server ..");
    fprintf(logfile,"\n .. connection closed by server ..");
    return(0); }

return(1);
}
