// This file contains httpchk() & gatechk()
/*---------------------------------------------------------------------------*
 *                 Cgichk, a CGI vunerability scanner                        *
 *                      Copyright (C) , 1999 by                              *
 *                                                                           *
 *          Peter Orloff                 (fdisk@netplan.gr)                  *
 *          Chen Kin Siong              (cksss@singnet.com.sg)               *
 *                                                                           *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2, or (at your option)       *
 * any later version.                                                        *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
 *---------------------------------------------------------------------------*
 *                                                                           *
 * Contact us to the above email addresses with any suggestions,problems,    *
 * modifications,config file updates,love letters,selfpics (girls only),etc. *
 *                                                                           *
 * If you are going to modify this program and republish it send a copy and  *
 * a relative email to BOTH of the original authors in the above addresses   *
 *---------------------------------------------------------------------------*/


#include "ess.h"
void rand_http_escape(char *uri);

/*
  Implement basic subterfuge attack against naive byte-matching IDSs.
  <dugsong@monkey.org> 
*/
void rand_http_escape(char *uri)
 {
   static char *hex = "0123456789ABCDEF";
   char *tmp, *p, *q;

   if ((tmp = strdup(uri)) == NULL) {
     perror("strdup");
     exit(1);
   }
   for (p = tmp, q = uri ; *p ; p++) {
     /* XXX - only handle F-Zf-z in case URI is already escaped... */
     if ((rand() & 1) &&       ((*p >= 70 && *p <= 90) || (*p >= 102 && *p <= 122))) {
       *q++ = '%';
       *q++ = hex[*p >> 4];
       *q++ = hex[*p & 15];
     }
     else *q++ = *p;
   }
   *q = '\0';
   free(tmp);
 }

int httpchk(int cgiscan,char *cgidatafile)
{
char foundcgi[1024];
char *cgistr;
char buffer[1024];
char tmpbuff[1024];
char tmpbuff1[1024];
char tmpbuff2[1024];
char tmpbuff3[1024];
char cginame[1024];
char cgilocate[1024];
char *cgilocate1;
int num=0;
int num1=1;
int buffnum=0;
int chk4eof=1;
char cgibuff[1024];
char httpdver[1024];
FILE *cgidata;
int nix=0;
int ms=0;
int ttrack=0;
char ostype[10];

printf("\n#########[Checking httpd]#########\n");
if((connport(httpdport,1))==0)
  { close(sock);
    return(0); }

srand(getpid());
sprintf(tmpbuff3,"HEAD / HTTP/1.0\r\n\r\n");
send(sock,tmpbuff3,strlen(tmpbuff3),0);

fprintf(logfile,"\n#########[Checking httpd]#########\n");

memset(buffer,'\0',sizeof(buffer));
memset(tmpbuff,'\0',sizeof(tmpbuff));
memset(httpdver,'\0',sizeof(httpdver));

if((timeout(1,lag_sec))==1) {
  while(chk4eof)
    chk4eof=recv(sock, buffer, sizeof(buffer),0); }
else
  return(0);

if(chk4eof==0 && strlen(buffer)<1)
  { printf("\n .. connection closed by server ..");
    close(sock); }

while(num != num1)
  {
  bzero(tmpbuff,sizeof(tmpbuff));
  num=buffnum;
  memccpy(tmpbuff,buffer+buffnum,'\n',strlen(buffer));
  if(!strncmp(tmpbuff,"Server:",7))
    { printf("\e[0;1;36m%s\e[0m",tmpbuff);
      strcpy(httpdver,tmpbuff); }
  else
    printf("%s",tmpbuff);
  buffnum=strlen(tmpbuff)+buffnum;
  num1=buffnum;
  }

if(strstr(httpdver,"nix") || strstr(httpdver,"nux") || strstr(httpdver,"BSD"))
  nix=1;
else if(strstr(httpdver,"Microsoft") || strstr(httpdver,"IIS") || strstr(httpdver,"TeamTrack"))
  ms=1;
else
 nix=1,ms=1;

fprintf(logfile,"----------HTTP SERVER INFO----------\n");
fprintf(logfile,"%s",buffer);
fprintf(logfile,"\nHttpd Version : %s\n",httpdver+7);
check4bug(httpdver+7,3);

if(cgiscan!=1)
  return(0);

bzero(buffer,sizeof(buffer));
bzero(tmpbuff,sizeof(tmpbuff));
bzero(tmpbuff3,sizeof(tmpbuff3));
bzero(foundcgi,sizeof(foundcgi));

if((cgidata=fopen(cgidatafile,"r")) == NULL)
  { printf("Could not find CGI data file %s",cgidatafile);
    return(0); }

while(fgets(tmpbuff1,sizeof(tmpbuff1),cgidata))
  {
  if(strncmp(tmpbuff1,"#",1))
    {
    sscanf(tmpbuff1,"%s %s %s",cginame,cgilocate,ostype);

    cgilocate1=strdup(cgilocate);
    rand_http_escape(cgilocate + 1);

    if(strlen(cginame)>0)
      {
      if(strstr(ostype,"nix") && nix==1 || strstr(ostype,"ms") && ms==1 || strstr(ostype,"all"))
        {
        if((connport(httpdport,1))==0)
          return(0);

        printf("\nSearching for %-15s : ",cginame);
        bzero(cgibuff,sizeof(cgibuff));

        sprintf(tmpbuff2,"GET %s HTTP/1.0\nHost: %s\r\n\r\n",cgilocate,host2scan);
        send(sock, tmpbuff2,strlen(tmpbuff2),0);
	 
        if((timeout(1,lag_sec))==1)
          chk4eof=recv(sock, cgibuff, sizeof(cgibuff),0);
        else
          return(0);

        if(chk4eof>0)
          {
          close(sock);
          cgistr = strstr(cgibuff,"HTTP/");
          if(cgistr != NULL) 
            {
            if(!strncmp(cgistr+9,"200",3))
              {
              printf("\e[0;1;33m!!\e[0;1;31mFound\e[0;1;33m!!\e[0m");
              fprintf(logfile,"Found %s in %s\n",cginame,cgilocate1);
              strcat(foundcgi,cginame);
              strcat(foundcgi," ");
              }
            else
              printf("Not Found");
 
            bzero(cginame,sizeof(cginame));
            bzero(cgilocate,sizeof(cgilocate));
            }
          else
            printf("Not Found");
          }
        else
         printf("Connection closed...");
        }
      }
    bzero(ostype,sizeof(ostype));
    }
  }
check4bug(foundcgi,6);
puts("");
}


int gatechk()
{
char getcmd[]="GET /..../ HTTP/1.0\r\n";
char tmpbuff[1024];
char *cgistr;

printf("\n#########[Checking WinGate Logfile server]#########\n");
if((connport(8010,1))==0)
  return(0);

fprintf(logfile,"\n#########[Checking WinGate Logfile server]#########\n");

logger("\nChecking for common httpd bug....");
sprintf(tmpbuff,"Host: %s\r\n\r\n",host2scan);
send(sock,getcmd,strlen(getcmd),0);
send(sock,tmpbuff,strlen(tmpbuff),0);

if((recvbuff(0))==0)
  return(0);
close(sock);

cgistr = strstr(rebuff,"HTTP/");
if(cgistr != NULL)
  if(!strncmp(cgistr+9,"200",3))
    { logger("\n!! Remote user might be able to get sensitive file from target");
       sprintf(tmpbuff,"\neg: http://%s:8010/..../dir/file",host2scan);
       logger(tmpbuff); }
}
