/* RAW socket utility routine:
 * 
 * Write out an IP header.
 * shadows@whitefang.com
 * Thamer Al-Herbish
 */

#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <netinet/in_systm.h>
#include <netinet/ip.h>

#include <unistd.h>
#include <string.h>

#if !defined(HAVE_INCKSUM)
#include "checksum.h"
#endif

#if !defined(IPVERSION)
#define IPVERSION 4  /* Incase some system does not have this definition. */
#endif               /* We'll always be using 4 as the version anyway. */


#define DEFAULT_TTL 60  /* Just hard code the ttl in the ip header.*/

void ip_gen(char *packet,unsigned char protocol,struct in_addr saddr,
	    struct in_addr daddr,unsigned short length)
{
#if !defined(LINUX)
  struct ip *iphdr;
#else
  struct iphdr *iphdr;
#endif /* LINUX */

#if !defined(LINUX)
  iphdr = (struct ip *)packet;
  memset((char *)iphdr,'\0',sizeof(struct ip));
  
  iphdr->ip_hl = 5;
  iphdr->ip_v = IPVERSION;
  
#ifdef IP_LEN_HORDER
  iphdr->ip_len = length;
#else
  iphdr->ip_len = htons(length);
#endif /* IP_LEN_HORDER */

  iphdr->ip_id = htons(getpid());
  iphdr->ip_ttl = DEFAULT_TTL;
  iphdr->ip_p = protocol;

  iphdr->ip_src = saddr;
  iphdr->ip_dst = daddr;
  
  iphdr->ip_sum = (unsigned short)in_cksum((unsigned short *)iphdr,
					   sizeof(struct ip));
  
#else /* LINUX */
  
  iphdr = (struct iphdr *)packet;
  memset((char *)iphdr,'\0',sizeof(struct iphdr));
  
  iphdr->ihl = 5;
  iphdr->version = IPVERSION;
    
#ifdef IP_LEN_HORDER
  iphdr->tot_len = length;
#else
  iphdr->tot_len = htons(length);
#endif /* IP_LEN_HORDER */
  
  iphdr->id = htons(getpid());
  iphdr->ttl = DEFAULT_TTL;
  iphdr->protocol = protocol;

  iphdr->saddr = saddr.s_addr;
  iphdr->daddr = daddr.s_addr;

  iphdr->check = (unsigned short)in_cksum((unsigned short *)iphdr,
					  sizeof(struct iphdr));
#endif /* LINUX */
  return;
}
