/* Libicmp 0.1a
 * Tim.Lawless@usm.edu
 * 
 * Libicmp is intended to provide a simple interface for sending and reciving
 * icmp datagrams. Beyond the obvious diffrence of using ICMP, applications
 * Using this interface would behave much in the same way an UDP application
 * behaves. 
 *
 * The documentation for this version is non-existant. I know how
 * Works. I should write some, but I figure if your playing with
 * this you probably are skilled enough to understand what I'm doing
 * from the two included "test" applications. 
 *
 * Feel free to take, use, improve. Use any lisence you desire.
 */
// used by eSS for udp portscanner & pinger..

#include "ess.h"
#include "libicmp.h"

sigjmp_buf icmpjmp;
void icmprecvout();

u_short
cksum (u_short * buf, int nwords)
{
  unsigned long sum;

  for (sum = 0; nwords > 0; nwords--)
    sum += *buf++;
  sum = (sum >> 16) + (sum & 0xffff);
  sum += (sum >> 16);
  return ~sum;
}


/* If your opening up a socket for listening, set both paramaters to 0 */
ICMP_SOCKET *
open_icmp_socket (unsigned long int host, unsigned short int psudoport)
{
  ICMP_SOCKET *isock;

  isock = malloc (sizeof (ICMP_SOCKET));
  bzero (isock, sizeof (ICMP_SOCKET));

  if (host || psudoport)
    {
      isock->host = ip2scan;
      isock->psudoport = psudoport;
    }

  if ((isock->socketfd = socket (AF_INET, SOCK_RAW, 1)) < 0)
    {
	perror ("libicmpnet::open_icmp_socket");
      return NULL;
    }

  return isock;
}

ICMP_DGRAM *build_icmp_dgram (void *msg, int size)
{
  ICMP_DGRAM *dgram;

  if (size > MAX_DGRAM_SIZE)
    return NULL;

  if (!(dgram = malloc (sizeof(ICMP_DGRAM))))
    return NULL;

  bzero (dgram, sizeof (ICMP_DGRAM));

  dgram->size = size;

  if (!(memcpy (dgram->buf, msg, size)))
    {
      free (dgram);
      return NULL;
    }
  return dgram;
}


int get_icmp_dgram (ICMP_SOCKET * icmp_socket)
{
  char buffer[BUFSIZE];
  struct iphdr *ip = (struct iphdr *) buffer;
  struct icmphdr *icmp = (struct icmphdr *) (buffer + sizeof (struct iphdr));
  ICMP_DGRAM * icmp_dgram;
  ICMP_DGRAM * dgram_overlay = (ICMP_DGRAM *) (buffer + sizeof (struct iphdr) + sizeof(struct icmphdr));
  int inc;
  int i, checksum;

  checkjmp=0;
  alarm(udp_lag_sec);
//  printf("ICMP listerner started......\n");
  sigsetjmp(icmpjmp,SIGALRM);
  signal(SIGALRM,icmprecvout);

  if(checkjmp==0)
    {
    icmplistern=1;
    i = read (icmp_socket->socketfd, buffer, BUFSIZE);

    alarm(0);

    checksum = icmp->checksum;
    icmp->checksum = 0;

    icmp_dgram = malloc (sizeof (ICMP_DGRAM));
      
    if(!icmp_dgram)
      printf("....\n");
    bzero (icmp_dgram, sizeof (ICMP_DGRAM));
 
    memcpy (icmp_dgram, dgram_overlay, dgram_overlay->size + sizeof(unsigned short int));

    icmptype=icmp->type;
   #ifdef DEBUGess
    printf("tos=%d ttl=%d\n",ip->tos,ip->ttl);
   #endif
    return icmp->type;
    }
  icmptype=-1;
  return -1;
}


int
send_icmp_dgram (ICMP_SOCKET * icmp_socket, ICMP_DGRAM * icmp_dgram)
{

  char buffer[BUFSIZE - sizeof (struct iphdr)];
  struct icmphdr *icmp = (struct icmphdr *) buffer;
  struct sockaddr_in sockaddr;
  int i;

  bzero(buffer,BUFSIZE - sizeof (struct iphdr));

  memcpy ((buffer + sizeof (struct icmphdr)), icmp_dgram,
	  icmp_dgram->size + sizeof (unsigned short int));

  icmp->type = 8;
  icmp->un.echo.id = icmp_socket->psudoport; 
  icmp->checksum = cksum ((u_short *) icmp, sizeof(struct icmphdr) + 
				  icmp_dgram->size + sizeof (unsigned short int)); 
  sockaddr.sin_family = AF_INET;
//  sockaddr.sin_addr.s_addr = icmp_socket->host;
  sockaddr.sin_addr.s_addr = inet_addr(ip2scan);

  if (
      (i =
       sendto (icmp_socket->socketfd, buffer,
	       sizeof (struct icmphdr) + icmp_dgram->size + 
		   sizeof (unsigned short int), 0,
	       (struct sockaddr *) &sockaddr, sizeof (sockaddr))) < 0)
    return 0;

  return i;
}



int
close_icmp_socket (ICMP_SOCKET * icmp_socket)
{
  if (!icmp_socket)
    return errno;

  if (icmp_socket->socketfd)
    close (icmp_socket->socketfd);

  free (icmp_socket);

  return 0;
}


void icmprecvout()  // udp port found
{
checkjmp=1;
siglongjmp(icmpjmp,1);
}
