#include "ess.h"
#include "libicmp.h"

void main(int argc, char *argv[])
{
FILE *fp;
int count;
int hostargv=0;
int cgiscan=0;
int udpscan=0;
int tmpint;
char *confstr[1024];
char *tmppointer;
char *showmnt;
char *userscan;
char *cgidatafile; // our config file for httpchecker
char icmpmsg[] = "ess"; // ess's fingerprint
pthread_t thread[50];
void *status;
int numofthread;
struct in_addr addr;
struct sockaddr_in sin;
struct timeval timestart;
struct timeval timeend;
long timetaken=0;
int totaltime=0;
int successreply=0;
int autolagset=0;
struct ifreq ifr;

if(argc < 3)
  { 
  printf("\n -=<*> ech0 Security presents <*>=-");
  printf("\n\n%s\n",version);
  printf("\nUsage : hostlist/hostname logfile");
  printf("\n\neg:- %s target.org scan.log",argv[0]);
  printf("\n     %s hostlist scan.log\n\n",argv[0]);
  exit(0);
  }

if(strlen(argv[2])>255 || strlen(argv[1])>255)
  { printf("Error: argv too long\n");
    exit(0); }

if((fp = fopen(argv[1], "r")) == NULL)
  { sprintf(host2scan,"%s",argv[1]);  /* if file not found..assume it as hostname */
    hostargv=1; }

// set our options from the config file
tmppointer=confparser("timeout");
if(tmppointer==NULL) {
  autolagset=1;
  if(getuid()!=0)
    { printf("!! Need root access to use auto assign timeout value !!\nModify %s and add timeout value.\n",CFILE);
      exit(0); } }
else { lag_sec=atoi(tmppointer); udp_lag_sec=2; }
user2fing=confparser("finger"); // see fingerchk.c
user2vrfy=confparser("vrfy");   // see smtpchk.c
dir2chk=confparser("ftpdir");   // see ftpchk.c
ftpuser=confparser("ftplogin"); // see ftpchk.c
rshuser=confparser("rshuser");  // see rshchk.c
cgidatafile=confparser("cgidatafile");
servicefile=confparser("service");
portscanopt=atoi(confparser("portscan"));
if(!strcmp(uptolow(confparser("cgiscan")),"yes"))
  { cgiscan = 1; }
if(!strcmp(uptolow(confparser("udpscan")),"yes")) {
  udpscan = 1; 
  if(getuid()!=0)
    { printf("!! Need root access to run udp scan !!\nModify %s and disable udp scan.\n",CFILE); 
      exit(0); } }
showmnt=confparser("showmount");
if(showmnt==NULL) showmnt="showmount";  // if user left blank

//-----Get port numbers from services file
ftpdport=getportbydaem("ftp","tcp");
telnetdport=getportbydaem("telnet","tcp");
smtpdport=getportbydaem("smtp","tcp");
fingerdport=getportbydaem("finger","tcp");
namedport=getportbydaem("domain","udp");
httpdport=getportbydaem("www","tcp");
if(httpdport==0)
  httpdport=getportbydaem("http","tcp");
pop2dport=getportbydaem("pop-2","tcp");
pop3dport=getportbydaem("pop-3","tcp");
imapdport=getportbydaem("imap2","tcp");
rshport=getportbydaem("shell","tcp");
rpcbindport=getportbydaem("sunrpc","tcp");
xwinport=getportbydaem("x11","tcp");
//-----EOF

printf("\n\n\n\n\n\t\t    [ ech0 security scanner ]\n\n");

tmppointer=confparser("net_interface");
get_local_ip(tmppointer);
memset(osfound,'\0',sizeof(osfound));

#ifdef DEBUGess
  printf("localIP = %s\n",localip);
  printf("localIPs = %s\n",localIPs);
#endif

curruser=getlogin();  // get currect username
FD_ZERO(&readfs);
FD_ZERO(&writefs);

(void)signal(SIGINT,overANDout);  // to catch ctrl+c

if(hostargv==1)
  goto startscan;

while(fscanf(fp, "%s", &host2scan) != EOF)
     {
     startscan:
     printf("Locating %s\n",host2scan);
     if((he=gethostbyname(host2scan)) != NULL)
       {
       ip2scan=inet_ntoa(*((struct in_addr *)he->h_addr));
       printf("Scanning host: %s/%s\n\n",host2scan,ip2scan);

       if(strstr(localIPs,ip2scan) && portscanopt!=3)
         portscanopt=1;
       if(!strncmp(ip2scan,"127",3) && portscanopt!=3)
         portscanopt=1;

       // ICMP request/reply timer (timeout value prediction mechanism)
       if(autolagset==1) {
	 timetaken=0;
	 totaltime=0;
	 successreply=0;
         udp_lag_sec=5;
	 printf("Pinging %s....\n",host2scan);
	 if(!(isock = open_icmp_socket(ip2scan, 54322)))
  	   { printf("Failed to Open Socket. \n"); exit(0); }
	 idgram = build_icmp_dgram(icmpmsg,sizeof(icmpmsg));
	 for(count=0;count<4;count++) {
           if(count==0)
    	     send_icmp_dgram(isock,idgram);
	   gettimeofday (&timestart,NULL);
	   icmplistern=0;
	   tmpint=get_icmp_dgram(isock);
	   gettimeofday (&timeend,NULL);
	   timetaken=1000*(timeend.tv_sec-timestart.tv_sec)+(timeend.tv_usec-timestart.tv_usec)/1000;

	   if(tmpint==-1)
 	     printf("..request timeout..\n");
	   else
 	     printf("Got icmp type %d in %dms\n",tmpint,timetaken);

	   if(tmpint==0)
             { successreply++; totaltime=totaltime+timetaken; }
           usleep(500000);
	   send_icmp_dgram(isock,idgram);
           }
	 close_icmp_socket(isock);
         if(successreply!=0) {
           #ifdef DEBUGess
            printf("\nTotal of %dms in %d times [%d]\n",totaltime,successreply,totaltime/successreply);
           #endif
	   totaltime=totaltime/successreply;
	   printf("\nAverage ping time = %dms",totaltime);
	   if(totaltime<=90)
	     { lag_sec=5; udp_lag_sec=2; }
	   if(totaltime>90)
	     { lag_sec=totaltime/100+5; udp_lag_sec=totaltime/100+2; }
           }
         else
           { lag_sec=10; udp_lag_sec=4; } // set default
	 printf("\ntimeout = %d  UDP portscan timeout = %d\n\n",lag_sec,udp_lag_sec);
	 }
       // End of timeout value prediction mechanism

       logfile=fopen(argv[2],"a");
       fprintf(logfile,"-=*[Scan results of %s]*=-\n",host2scan);

       if(portscanopt!=0 && portscanopt!=3)
         {
	 porti=0;doneportscan=0;wingatelog=0;conntimeout=0;timeoutno=0;firewallguess=-1;
	 ftpscan=0;telnetscan=0;smtpscan=0;fingerscan=0;httpscan=0;xwinscan=0;
	 pop2scan=0;pop3scan=0;imapscan=0;rpcscan=0;rshscan=0;namescan=0;

         pthread_mutex_init (&lock, NULL);

	 //Tcp portscanning
         processport("tcp");  // fill structure portinfo .. see smalls.c
	 printf("Scanning for TCP port..\n");
	 fprintf(logfile,"\n[TCP port found]\n");

	 if(portscanopt==1)
           numofthread=20;
	 else if(portscanopt==2)
           numofthread=1;

	 for(count=0;count<10;count++)
	    tcpprint[count].num=1;

         for(count=0;count<numofthread;count++)
            pthread_create(&thread[count],NULL,(void *)&portscan,NULL);
	 while(doneportscan<numofthread)  // dont think we need pthread_join anymore
            wait();
         for(count=0;count<numofthread;count++)
            pthread_join(thread[count],&status);

	 //Udp portscanning
         if(udpscan==1) {
	   processport("udp");
  	   if(!(isock = open_icmp_socket(ip2scan, 54321)))  // see libicmp.c
             { printf("Failed to Open Socket. \n"); break; }
           idgram = build_icmp_dgram(icmpmsg,sizeof(icmpmsg));
	   printf("\nScanning for UDP port..\n");
           if(successreply==0)
             printf("!! UDP port scans might be ineffective [ICMP communication is restricted] !!\n\n");
           fprintf(logfile,"\n[UDP port found]\n");
           for(count=0;count<portmax;count++)
             {
	     icmplistern=0;
             pthread_create(&thread[21],NULL,(void *)&get_icmp_dgram,(void *)isock);
             usleep(20000);  // allow icmp listerner to start first
             if(icmplistern==1) {
  	       sock=socket(AF_INET, SOCK_DGRAM, 0);
  	       sin.sin_family=AF_INET;
  	       sin.sin_port=htons(portdata[count].port);
	       sin.sin_addr=*((struct in_addr *)he->h_addr);
	       bzero(&(sin.sin_zero), 8);
	       sendto(sock, "\n", 1, 0,(struct sockaddr*)&sin,sizeof(struct sockaddr));
  	       close(sock); }
	     pthread_join(thread[21],&status);
             if(icmptype==-1) {
	       printf("Found port: %d/%s\n",portdata[count].port,port2daemon(portdata[count].port));
	       fprintf(logfile,"Found port: %d/%s\n",portdata[count].port,port2daemon(portdata[count].port));

	       if(portdata[count].port==namedport)
	         namescan=1;
               }
             //pthread_detach(thread[0]);
             }
 	   close_icmp_socket(isock);
           }	 // end of UDP port scanner
	 wait();

         logger(tcpstacks);     // print the tcp stacks info
         if(strlen(osfound)!=0)
	   logger(osfound);     // report the os guessed
         }
       else if(portscanopt==0)
         { ftpscan=1;telnetscan=1;smtpscan=1;fingerscan=1;httpscan=1;xwinscan=1;
	   pop2scan=1;pop3scan=1;imapscan=1;rpcscan=1;rshscan=1;wingatelog=1;namescan=1; }

       if(portscanopt==3) {  // check for the defined scans
         userscan=uptolow(confparser("custom"));
         if(strstr(userscan,"ftp")) { ftpchk(); }
         if(strstr(userscan,"telnet")) { telnetchk(); }
         if(strstr(userscan,"smtp")) { smtpchk(); }
	 if(strstr(userscan,"named")) { namedchk(); }
	 if(strstr(userscan,"finger")) { fingerchk(); }
 	 if(strstr(userscan,"http")) { httpchk(cgiscan,cgidatafile); }
	 if(strstr(userscan,"pop2")) { pop2chk(); }
	 if(strstr(userscan,"pop3")) { pop3chk(); }
	 #ifdef HAVE_RPC_RPC_H
         if(strstr(userscan,"rpc")) { rpc_scan(showmnt); }
	 #endif
	 if(strstr(userscan,"imap")) { imapchk(); }
	 #ifdef HAVE_RCMD
	 if(strstr(userscan,"rsh")) { rshchk(); }
	 #endif
	 #ifdef HAVE_X11_LIBS
         if(strstr(userscan,"x11")) { checkX(ip2scan); }
	 #endif
         if(strstr(userscan,"wingate")) { gatechk(); }
	 }
       else { /* Start the scan with port++ order */
         if(ftpscan==1)
           ftpchk();
         if(telnetscan==1)
           telnetchk();
         if(smtpscan==1)
           smtpchk();
         if(namescan==1)
           namedchk();
         if(fingerscan==1)
           fingerchk();
         if(httpscan==1)
           httpchk(cgiscan,cgidatafile);
         if(pop2scan==1)
           pop2chk();
         if(pop3scan==1)
           pop3chk();
         if(imapscan==1)
           imapchk();
	 #ifdef HAVE_RPC_RPC_H
         if(rpcscan==1)
           rpc_scan(showmnt);
	 #endif 
	 #ifdef HAVE_RCMD
          if(rshscan==1)
           rshchk();
	 #endif
	 #ifdef HAVE_X11_LIBS
         if(xwinscan==1)
           checkX(ip2scan);
	 #endif
         if(wingatelog==1)
           gatechk();
         }

       fprintf(logfile,"\n---------------[end of %s]--------------\n\n\n",host2scan);
       printf("\n---------------[end of %s]--------------\n",host2scan);
       fclose(logfile);
       if(hostargv==1)
         exit(0);
       }
     else
       {
       printf("!! Error: %s not found !!\n",host2scan);
       printf("---------------[end of %s]--------------\n\n",host2scan);
       if(hostargv==1)
         exit(0);
       }
     }
fclose(fp);
}
