// OS FingerPrinting data file parser
// Look in file "fingerprint" for more info
#include "ess.h"

void oscheck(int tcpwinsize,int tcpfrag,int tcpttl,int tcptos)
{
FILE *osfd;
char buff[1024];
char osname[1024];
char *tmp;
int num;
int num1;
int match;

sprintf(tcpstacks,"\n\nWindow Size=%d TTL=%d TOS=%d FRAG=%d",tcpwinsize,tcpttl,tcptos,tcpfrag);

osfd=fopen("fingerprint","r");
while(fgets(buff,sizeof(buff),osfd))
  {
  if(strncmp(buff,"#",1))
    {
    if(!strncmp(buff,"OS ",3))
      { sprintf(osname,buff+3);
        match=0; }

    // Check for Windows Size
    if(!strncmp(buff,"WinSize",7))
      {
      if((tmp=strstr(buff,"-"))==NULL)
        { num=atoi(buff+8);
          if(tcpwinsize==num)
            match++; }
      else
        { num=atoi(buff+8); 
          num1=atoi(tmp+1);
          if(tcpwinsize>num && tcpwinsize<num1)
            match++; }
      }

    // Check for FRAG value
    if(!strncmp(buff,"FRAG ",5))
      {
      num=atoi(buff+5);
      if(tcpfrag==num)
        match++;
      }

    // Check for TTL value
    if(!strncmp(buff,"TTL ",4))
      {
      if(strstr(buff,"NULL"))
        match++;
      else
        {
        if((tmp=strstr(buff,"-"))==NULL)
          { num=atoi(buff+4);
            if(tcpttl==num)
              match++; }
        else
          { num=atoi(buff+4); num1=atoi(tmp+1);
            if(tcpttl>num && tcpttl<num1)
              match++; }
        }
      }

    // Check for TOS value
    if(!strncmp(buff,"TOS ",4))
      {
      num=atoi(buff+4);
      if(tcptos==num)
        match++;
      }

    if(match==4)
      { sprintf(osfound,"\nOS Guess: %s",osname);
        break; }
    memset(buff,'\0',sizeof(buff));
    }
  }
fclose(osfd);
}
