/* Generate a TCP packet
 * with a SYN flag and pass it through a raw socket.
 * 
 * Thamer Al-Herbish shadows@whitefang.com
 */
// used by eSS for syn port scanner :P

#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <netinet/in_systm.h>

/*#if defined(LINUX)
#include <linux/ip.h>
#include <linux/tcp.h>
#else */
#include <netinet/ip.h>
#include <netinet/tcp.h>
//#endif

#include <string.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>
#include "rawsock_utils.h"
#include "ess.h"

int syn2port(char *target,char *source,int port2conn);

int syn2port(char *target,char *source,int port2conn)
{
  unsigned char packet[
#if !defined(LINUX)
  sizeof(struct ip) +
#else /* LINUX */
  sizeof(struct iphdr) +
#endif /* LINUX */
  sizeof(struct tcphdr)];
  struct sockaddr_in mysocket;
  unsigned short sport, dport;
  struct in_addr saddr, daddr;
  struct tcphdr *tcp;
  unsigned long seq, ack;
 // int sockd, on = 1;
  int on=1;
  char tmpbuff[1024];
  int tmpint;
  int i;
  int portport=1;

  struct recv_tcp
  { struct iphdr ip;
    struct tcphdr tcp; }
  recv_tcp;
  
  memset(tmpbuff,'\0',sizeof(tmpbuff));
  sport = getpid();
  saddr.s_addr = inet_addr(source);
  
  dport = port2conn;
  daddr.s_addr = inet_addr(target);
  
  if((sock = socket(AF_INET,SOCK_RAW,IPPROTO_TCP)) < 0)  {
    perror("socket");
    exit(1);
  }
  
  if(setsockopt(sock,IPPROTO_IP,IP_HDRINCL,(char *)&on,sizeof(on)) < 0)  {
    perror("setsockopt");
    exit(1);
  }
  
  /* Very bad random sequence number generator */
  
  srand(getpid());
  
  seq = rand()%time(NULL);
  ack = rand()%time(NULL);
  
  ip_gen(packet,IPPROTO_TCP,saddr,daddr,sizeof(packet));
  
#if !defined(LINUX)

  tcp = (struct tcphdr *)(packet + sizeof(struct ip));

  tcp_gen((char *)tcp,sport,dport,seq,ack);

#if !defined(SOLARIS_CKSUM_BUG)
  tcp->th_sum = trans_check(IPPROTO_TCP,(char *)tcp,
			    sizeof(struct tcphdr),
			    saddr,
			    daddr);
  
#else /* SOLARIS_CKSUM_BUG */

  tcp->th_sum = sizeof(struct tcphdr);

#endif /* SOLARIS_CKSUM_BUG */

#else /* LINUX */
  
  tcp = (struct tcphdr *)(packet + sizeof(struct iphdr));

  tcp_gen((char *)tcp,sport,dport,seq,ack);
  
#if !defined(SOLARIS_CKSUM_BUG)
  tcp->check = trans_check(IPPROTO_TCP,(char *)tcp,
			   sizeof(struct tcphdr),
			   saddr,
			   daddr);
#else /* SOLARIS_CKSUM_BUG */

  tcp->check = sizeof(struct tcphdr);

#endif /* SOLARIS_CKSUM_BUG */

#endif /* LINUX */
  
  memset(&mysocket,'\0',sizeof(mysocket));
  
  mysocket.sin_family = AF_INET;
  mysocket.sin_port = htons(dport);
  mysocket.sin_addr = daddr;

  if(sendto(sock,&packet,sizeof(packet),0x0,(struct sockaddr *)&mysocket,
            sizeof(mysocket)) != sizeof(packet))  {
    perror("sendto");
    exit(1);
  }
  
  if((timeout(2,lag_sec/2))==1)
    tmpint=read(sock, (struct recv_tcp *)&recv_tcp, sizeof(recv_tcp));
  else
   { close(sock);
     return(0); }
 
  if(recv_tcp.tcp.rst==1)
    return 0;
  else
    {
    keeptcpstack(recv_tcp.tcp.window,recv_tcp.ip.ttl,recv_tcp.ip.tos,recv_tcp.ip.frag_off);

    #ifdef DEBUGess
//      printf("[%d] rst=%d fin=%d win=%d ttl=%d tos=%d frag=%d id=%d\n",dport,recv_tcp.tcp.rst,recv_tcp.tcp.fin,recv_tcp.tcp.window,recv_tcp.ip.ttl,recv_tcp.ip.tos,recv_tcp.ip.frag_off,recv_tcp.ip.id);
      printf("win=%d ttl=%d tos=%d frag=%d id=%d\n",recv_tcp.tcp.window,recv_tcp.ip.ttl,recv_tcp.ip.tos,recv_tcp.ip.frag_off,recv_tcp.ip.id);
    #endif
//    printf(" ack_seq=%d doff=%d urg_pt=%d proto=%d\n",recv_tcp.tcp.ack_seq,recv_tcp.tcp.doff,recv_tcp.tcp.urg_ptr,recv_tcp.ip.protocol);
    return 1;
    }
}
