/* RAW socket utility routine:
 * 
 * Write out a TCP header.
 * shadows@whitefang.com
 * Thamer Al-Herbish
 */
// used by eSS for syn port scanner :P

#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <netinet/in_systm.h>

#if defined(LINUX)
#include <linux/tcp.h>
#else
#include <netinet/tcp.h>
#endif

#include <unistd.h>
#include <string.h>

#if defined(X2_OFF)         /* SCO */
#define TH_OFFSET 0x50         /* TCP header offset */
#else
#define TH_OFFSET 5
#endif

#define TCP_WINDOW_SIZE 512 /* Just have it hardcoded. */

void tcp_gen(char *packet,unsigned short sport,
	     unsigned short dport,unsigned long seq,
	     unsigned long ack)
{
  struct tcphdr *tcp;
  
  tcp = (struct tcphdr *)packet;
  memset((char *)tcp,'\0',sizeof(struct tcphdr));

#if !defined(LINUX)
  tcp->th_sport = htons(sport);
  tcp->th_dport = htons(dport);
  
  tcp->th_seq = htonl(seq);
  tcp->th_ack = htonl(ack);
  
#ifdef X2_OFF
  tcp->th_x2_off = TH_OFFSET;
#else /* X2_OFF */
  tcp->th_off = TH_OFFSET;
  tcp->th_x2 = 0;
#endif /* X2_OFF */

  tcp->th_win = htons(TCP_WINDOW_SIZE);
//  tcp->th_flags = TH_FIN;
  tcp->th_flags = TH_SYN;
  
#else /* LINUX */

  tcp->source = htons(sport);
  tcp->dest = htons(dport);
  
  tcp->seq = htonl(seq);
  tcp->ack_seq = htonl(ack);
  
  tcp->res1 = 0;
  tcp->doff = TH_OFFSET;

  tcp->window = htons(TCP_WINDOW_SIZE);
  tcp->syn = 1;
//  tcp->fin = 1;

#endif /* LINUX */

  return;
}
