/* Transport header checksum
 * for TCP and UDP
 * shadows@whitefang.com
 */
// used by eSS for syn port scanner :P

#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>

#include <errno.h>
#include <string.h>

#if !defined(HAVE_INCKSUM)
#include "checksum.h"
#endif

struct psuedohdr  {
  struct in_addr source_address;
  struct in_addr dest_address;
  unsigned char place_holder;
  unsigned char protocol;
  unsigned short length;
} psuedohdr;

unsigned short trans_check(unsigned char proto,
			   char *packet,
			   int length,
			   struct in_addr source_address,
			   struct in_addr dest_address)
{
  char *psuedo_packet;
  unsigned short answer;
  
  psuedohdr.protocol = proto;
  psuedohdr.length = htons(length);
  psuedohdr.place_holder = 0;

  psuedohdr.source_address = source_address;
  psuedohdr.dest_address = dest_address;
  
  if((psuedo_packet = malloc(sizeof(psuedohdr) + length)) == NULL)  {
    perror("malloc");
    exit(1);
  }
  
  memcpy(psuedo_packet,&psuedohdr,sizeof(psuedohdr));
  memcpy((psuedo_packet + sizeof(psuedohdr)),
	 packet,length);
  
  answer = (unsigned short)in_cksum((unsigned short *)psuedo_packet,
				    (length + sizeof(psuedohdr)));
  free(psuedo_packet);
  return answer;
}
