#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14642);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0686");
 
 name["english"] = "Fedora Core 1 2004-284: samba";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2004-284 (samba).

Samba is the protocol by which a lot of PC-related machines share
files, printers, and other information (such as lists of available
files and printers). The Windows NT, OS/2, and Linux operating systems
support this natively, and add-on packages can enable the same thing
for DOS, Windows, VMS, UNIX of all kinds, MVS, and more. This package
provides an SMB server that can be used to provide network services to
SMB (sometimes called 'Lan Manager') clients. Samba uses NetBIOS over
TCP/IP (NetBT) protocols and does NOT need the NetBEUI (Microsoft Raw
NetBIOS frame) protocol.


* Wed Aug 25 2004 Jay Fenlason <fenlason@redhat.com> 3.0.6-1.FC2

- Upgade to 3.0.6
 include the following patches:
   samba-3.0.5rc1-passwd.patch from me.  This changes the character
     used in the password field of the entries generated by winbind
     from a 'x' to a '*'.  'x' means something special ('password is
     in /etc/shadow') to another pam module.
   samba-3.0.5pre1-smbclient-kerberos.patch from
     Alexander Larsson (alexl@redhat.com).  Make kerberized smbclient
     work better.
   samba-3.0.5pre1-use_authtok.patch from Nalin Dahyabhai
     <nalin@redhat.com> Fix an apparent braino in pam_winbind.c and
     correct Cristian Gafton's name
   samba-3.0.6-schema.patch from Gerald (Jerry) Carter <jerry@samba.org>
     Correct the LDAP schema
   samba-3.0.5rc1-64bit-timestamps.patch from Ravikumar
     (rkumar@hp.com) to allow correct timestamp handling on 64-bit
     platforms and fix #126109.
   samba-3.0.4-install.mount.smbfs.patch from Juanjo Villaplana
     (villapla@si.uji.es) to prevent building the srpm from trashing
     the installed /usr/bin/smbmount

* Thu May 20 2004 Jay Fenlason <fenlason@redhat.com> 3.0.4-2.FC1

- include -winbind patch from Gerald (Jerry) Carter (jerry@samba.org)
 https://bugzilla.samba.org/show_bug.cgi?id=1315
 to make winbindd work against Windows versions that do not have
 128 bit encryption enabled.



Solution : http://www.fedoranews.org/updates/FEDORA-2004-284.shtml
Risk Factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the samba package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"samba-3.0.6-2.FC1", release:"FC1") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.6-2.FC1", release:"FC1") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"samba-common-3.0.6-2.FC1", release:"FC1") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"samba-swat-3.0.6-2.FC1", release:"FC1") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"samba-debuginfo-3.0.6-2.FC1", release:"FC1") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_exists(rpm:"samba-", release:"FC1") )
{
 set_kb_item(name:"CAN-2004-0686", value:TRUE);
}
