#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12531);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0180", "CAN-2004-0405");
 name["english"] = "FreeBSD : SA-04:07.cvs";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of FreeBSD which contains a
path validation issue in cvs. This issue may be exploited by an attacker
to overwrite arbitrary files on the client side of cvs, or to 
read files outside of the cvs root on the server side.

Solution : http://www.vuxml.org/freebsd/0792e7a7-8e37-11d8-90d1-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the FreeBSD";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^cvs+ipv6", string:pkgs);
if ( package )
{
if ( pkg_cmp(pkg:package, reference:"cvs+ipv6-1.11.15_2") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
}



package = get_kb_item("Host/FreeBSD/release");


if ( egrep(pattern:"FreeBSD-5\.", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-5.2.1_5") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.[0-8]([^0-9]|$)", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.8_18") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.9", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.9_5") < 0 )
 {
  security_warning(port);
  exit(0);
 }
}
