#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12536);
 script_bugtraq_id(9974);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0152", "CAN-2004-0153");
 name["english"] = "FreeBSD Ports: emil < 2.1b9";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the emil package which is older
than 2.1b9.

emil is a mail format converter. There are multiple buffer overflows in the
remote version of this software which are triggered when it processes
attachments filenames.

An attacker could exploit this flaw to execute arbitrary code remotely, 
with the privileges of the emil process. To exploit this flaw, an attacker
would need to send a malformed email to a victim using emil on this host,
and wait for him to decode the message with emil. Since emil is usually used
in batch scripts, it may be possible to exploit this flaw without any human
intervention.

Solution : http://www.vuxml.org/freebsd/ce46b93a-80f2-11d8-9645-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the emil package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^emil-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"emil-2.1b9") < 0 ) 
	security_hole(0);
