#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15803);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id ( 11014 );
 name["english"] = "FreeBSD Ports : hafyie < 1.0_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

hafyie < 1.0_1

Hafiye-1.0 doesnt filter the payload when printing it to  the terminal. A 
malicious attacker can send packets with escape sequence payloads to exploit 
this vulnerability.

If Hafiye has been started with -n packet count option ,  the vulnerability 
could allow remote code execution. For remote code execution the victim must 
press Enter after program exit.

See also : http://deicide.siyahsapka.org/hafiye_esc.txt
Solution : http://www.vuxml.org/freebsd/027380b7-3404-11d9-ac1b-000d614f7fad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the hafiye package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^hafiye-[01]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"hafiye-1.0_1") < 0  )
	{
	security_hole(0);
	exit(0);
	}
