#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12564);
 script_bugtraq_id(9530);
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports : libtool insecure temp file creation";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the GNU libtool package which
contains a security problem.


libtool is a generic shared library support script. There is a bug in the remote
version of libtool which may allow a user to take advantage of an insecure
temporary file creation to overwrite files belonging to another user.

Solution : http://www.vuxml.org/freebsd/cacaffbc-5e64-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libtool package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^libtool-1\.3", string:pkgs);

if ( package && pkg_cmp(pkg:package, reference:"libtool-1.3.5_2") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}

package = egrep(pattern:"^libtool-1\.4", string:pkgs);

if ( package && pkg_cmp(pkg:package, reference:"libtool-1.4.3_3") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}


package = egrep(pattern:"^libtool-1\.5", string:pkgs);

if ( package && pkg_cmp(pkg:package, reference:"libtool-1.5.2") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
