#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12565);
 script_bugtraq_id(10193);
 script_version ("$Revision: 1.4 $");
 name["english"] = "FreeBSD Ports: libxine < 1.0r3_5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of libxine installed.

libxine is a set of libraries for the Xine multimedia player. There is a flaw
in the remote version of this package which may let an attacker to overwrite
arbitrary files on the remote host.

To exploit this flaw, an attacker would need to send a malicious MRL link
to a Xine user on this host.

Solution : http://www.vuxml.org/freebsd/e50b04e8-9c55-11d8-9366-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libxine package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^libxine-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"libxine-1.0.r3_5") < 0 ) security_warning(0);
