#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15576);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0885");
 name["english"] = "FreeBSD Ports : mod_ssl< 1.3.31+2.8.20";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has at least one of these packages installed :

ru-apache+mod_ssl <= 1.3.31+30.20+2.8.18
apache+mod_ssl < 1.3.31+2.8.20
apache+mod_ssl+ipv6 <= 1.3.31+2.8.18_4
apache2 <= 2.0.52_1

There is a security issue in the remote version of this software which may
allow a client to use any ciper suite configured by the virtual host, 
wether or not a certain cipher suite has been configured for a certain
directory.

Solution : http://www.vuxml.org/freebsd/4238151d-207a-11d9-bfe2-0090962cff2a.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^apache+mod_ssl-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache+mod_ssl-1.3.31+2.8.20") < 0 ) 
	security_warning(0);

package = egrep(pattern:"^ru-apache+mod_ssl-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ru-apache+mod_ssl-1.3.31+30.20+2.8.20") <= 0 ) 
	security_warning(0);

package = egrep(pattern:"^apache+mod_ssl+ipv6", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache+mod_ssl+ipv6-1.3.31+2.8.18_4") <= 0 ) 
	security_warning(0);
package = egrep(pattern:"^apache2-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache2-2.0.52_1") <= 0 ) 
	security_warning(0);
