#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12587);
 script_bugtraq_id(9980);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0376");
 name["english"] = "FreeBSD Ports: oftpd < 0.3.7";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of oftpd installed.

oftpd is an anonymous FTP server. There is a denial of service vulnerability
in this service which may allow an attacker to disable it remotely by
sending a malformed PORT command.


Solution : http://www.vuxml.org/freebsd/290d81b9-80f1-11d8-9645-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the oftpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^oftpd-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"oftpd-0.3.7") < 0 ) 
	security_warning(0);
