#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15816);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : wzftpd < 0.4.3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

wzdftp < 0.4.3

wzdftpd contains a potential remote Denial-of-Service.

Solution : http://www.vuxml.org/freebsd/e0070221-2dd8-11d9-a9e7-0001020eed82.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wzdftpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^wzdftpd-0\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"wzdftpd-0.4.3") < 0  )
	{
	security_warning(0);
	exit(0);
	}
