#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12629);
 script_bugtraq_id(9029);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0858");
 name["english"] = "FreeBSD Ports: zebra < 0.93b_7, quagga < 0.96.4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of zebra and/or quagga installed.

zebra and quagga are two routing softwares. There is a bug in either of
these programs which may allow an attacker to disable them remotely
by sending a malformed packet to the telnet port of these devices.

Solution : http://www.vuxml.org/freebsd/cad045c0-81a5-11d8-9645-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the zebra/quagga packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^zebra-0", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"zebra-0.93b_7") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^quagga-0", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"quagga-0.96.4") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
